/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPoweredTile;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPoweredMachineEntity
extends AbstractMachineEntity
implements IInternalPoweredTile {
    private Capacitors capacitorType = Capacitors.BASIC_CAPACITOR;
    private ICapacitor capacitor;
    private int storedEnergyRF;
    protected float lastSyncPowerStored = -1.0f;

    protected AbstractPoweredMachineEntity(SlotDefinition slotDefinition) {
        super(slotDefinition);
    }

    public void init() {
        super.init();
        this.onCapacitorTypeChange();
    }

    @Override
    public void doUpdate() {
        boolean powerChanged;
        super.doUpdate();
        if (this.worldObj.isRemote) {
            return;
        }
        boolean bl = powerChanged = this.lastSyncPowerStored != (float)this.storedEnergyRF && this.shouldDoWorkThisTick(5);
        if (powerChanged) {
            this.lastSyncPowerStored = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.isSideDisabled(from.ordinal());
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        if (this.isSideDisabled(dir.ordinal())) {
            return 0;
        }
        return this.getCapacitor().getMaxEnergyReceived();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.getCapacitor().getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = MathHelper.clamp_int((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public boolean hasPower() {
        return this.storedEnergyRF > 0;
    }

    public Capacitors getCapacitorType() {
        return this.capacitorType;
    }

    public ICapacitor getCapacitor() {
        return this.capacitor != null ? this.capacitor : this.capacitorType.capacitor;
    }

    public int getEnergyStoredScaled(int scale) {
        return VecmathUtil.clamp((int)Math.round((float)scale * ((float)this.storedEnergyRF / (float)this.getMaxEnergyStored())), (int)0, (int)scale);
    }

    protected void setCapacitor(ICapacitor capacitor) {
        this.capacitor = capacitor;
        this.setEnergyStored(this.getEnergyStored());
    }

    public void setCapacitor(Capacitors capacitorType) {
        this.capacitorType = capacitorType;
        this.capacitor = null;
        this.onCapacitorTypeChange();
        this.setEnergyStored(this.getEnergyStored());
        this.forceClientUpdate = true;
    }

    public void onCapacitorTypeChange() {
    }

    public int getPowerUsePerTick() {
        return this.getCapacitor().getMaxEnergyExtracted();
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack contents) {
        super.setInventorySlotContents(slot, contents);
        if (this.slotDefinition.isUpgradeSlot(slot)) {
            this.updateCapacitorFromSlot();
        }
    }

    @Override
    public ItemStack decrStackSize(int fromSlot, int amount) {
        ItemStack res = super.decrStackSize(fromSlot, amount);
        if (this.slotDefinition.isUpgradeSlot(fromSlot)) {
            this.updateCapacitorFromSlot();
        }
        return res;
    }

    private void updateCapacitorFromSlot() {
        if (this.slotDefinition.getNumUpgradeSlots() <= 0) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
            return;
        }
        ItemStack contents = this.inventory[this.slotDefinition.minUpgradeSlot];
        if (contents == null || contents.getItem() != EnderIO.itemBasicCapacitor) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
        } else {
            this.setCapacitor(Capacitors.values()[contents.getItemDamage()]);
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        int energy;
        super.readCommon(nbtRoot);
        this.setCapacitor(Capacitors.values()[nbtRoot.getShort("capacitorType")]);
        if (nbtRoot.hasKey("storedEnergy")) {
            float storedEnergyMJ = nbtRoot.getFloat("storedEnergy");
            energy = (int)(storedEnergyMJ * 10.0f);
        } else {
            energy = nbtRoot.getInteger("storedEnergyRF");
        }
        this.setEnergyStored(energy);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        nbtRoot.setInteger("storedEnergyRF", this.storedEnergyRF);
        nbtRoot.setShort("capacitorType", (short)this.capacitorType.ordinal());
    }
}

