/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.InventoryWrapper;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IMachine;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.SlotDefinition;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractMachineEntity
extends TileEntityEio
implements ISidedInventory,
IMachine,
IRedstoneModeControlable,
IRedstoneConnectable,
IIoConfigurable {
    public short facing;
    protected int ticksSinceSync = -1;
    protected boolean forceClientUpdate = true;
    protected boolean lastActive;
    protected int ticksSinceActiveChanged = 0;
    protected ItemStack[] inventory;
    protected final SlotDefinition slotDefinition;
    protected RedstoneControlMode redstoneControlMode;
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    protected Map<ForgeDirection, IoMode> faceModes;
    private final int[] allSlots;
    protected boolean notifyNeighbours = false;
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    private final ResourceLocation soundRes;

    public static ResourceLocation getSoundFor(String sound) {
        return sound == null ? null : new ResourceLocation(EnderIO.DOMAIN + ":" + sound);
    }

    public AbstractMachineEntity(SlotDefinition slotDefinition) {
        this.slotDefinition = slotDefinition;
        this.facing = (short)3;
        this.inventory = new ItemStack[slotDefinition.getNumSlots()];
        this.redstoneControlMode = RedstoneControlMode.IGNORE;
        this.soundRes = AbstractMachineEntity.getSoundFor(this.getSoundName());
        this.allSlots = new int[slotDefinition.getNumSlots()];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    @Override
    public IoMode toggleIoModeForFace(ForgeDirection faceHit) {
        IoMode curMode = this.getIoMode(faceHit);
        IoMode mode = curMode.next();
        while (!this.supportsMode(faceHit, mode)) {
            mode = mode.next();
        }
        this.setIoMode(faceHit, mode);
        return mode;
    }

    @Override
    public boolean supportsMode(ForgeDirection faceHit, IoMode mode) {
        return true;
    }

    @Override
    public void setIoMode(ForgeDirection faceHit, IoMode mode) {
        if (mode == IoMode.NONE && this.faceModes == null) {
            return;
        }
        if (this.faceModes == null) {
            this.faceModes = new EnumMap<ForgeDirection, IoMode>(ForgeDirection.class);
        }
        this.faceModes.put(faceHit, mode);
        this.forceClientUpdate = true;
        this.notifyNeighbours = true;
        this.updateBlock();
    }

    @Override
    public void clearAllIoModes() {
        if (this.faceModes != null) {
            this.faceModes = null;
            this.forceClientUpdate = true;
            this.notifyNeighbours = true;
            this.updateBlock();
        }
    }

    @Override
    public IoMode getIoMode(ForgeDirection face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    public SlotDefinition getSlotDefinition() {
        return this.slotDefinition;
    }

    public boolean isValidUpgrade(ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinUpgradeSlot(); i <= this.slotDefinition.getMaxUpgradeSlot(); ++i) {
            if (!this.isItemValidForSlot(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (!this.isItemValidForSlot(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
            if (!this.isItemValidForSlot(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public final boolean isItemValidForSlot(int i, ItemStack itemstack) {
        if (this.slotDefinition.isUpgradeSlot(i)) {
            return itemstack != null && itemstack.getItem() == EnderIO.itemBasicCapacitor && itemstack.getItemDamage() > 0;
        }
        return this.isMachineItemValidForSlot(i, itemstack);
    }

    protected abstract boolean isMachineItemValidForSlot(int var1, ItemStack var2);

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    public short getFacing() {
        return this.facing;
    }

    public ForgeDirection getFacingDir() {
        return ForgeDirection.getOrientation((int)this.facing);
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public abstract boolean isActive();

    public String getSoundName() {
        return null;
    }

    public boolean hasSound() {
        return this.getSoundName() != null;
    }

    public float getVolume() {
        return Config.machineSoundVolume;
    }

    public float getPitch() {
        return 1.0f;
    }

    protected boolean shouldPlaySound() {
        return this.isActive() && !this.isInvalid();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (Config.machineSoundsEnabled && this.hasSound()) {
            if (this.shouldPlaySound()) {
                if (this.sound == null) {
                    this.sound = new MachineSound(this.soundRes, (float)this.xCoord + 0.5f, (float)this.yCoord + 0.5f, (float)this.zCoord + 0.5f, this.getVolume(), this.getPitch());
                    FMLClientHandler.instance().getClient().getSoundHandler().playSound((ISound)this.sound);
                }
            } else if (this.sound != null) {
                this.sound.endPlaying();
                this.sound = null;
            }
        }
    }

    public void doUpdate() {
        if (this.worldObj.isRemote) {
            this.updateEntityClient();
            return;
        }
        boolean requiresClientSync = this.forceClientUpdate;
        boolean prevRedCheck = this.redstoneCheckPassed;
        if (this.redstoneStateDirty) {
            this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
            this.redstoneStateDirty = false;
        }
        if (this.shouldDoWorkThisTick(5)) {
            requiresClientSync |= this.doSideIo();
        }
        requiresClientSync |= prevRedCheck != this.redstoneCheckPassed;
        if (requiresClientSync |= this.processTasks(this.redstoneCheckPassed)) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
        if (this.notifyNeighbours) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
            this.notifyNeighbours = false;
        }
    }

    protected void updateEntityClient() {
        if (this.isActive() != this.lastActive) {
            ++this.ticksSinceActiveChanged;
            if (this.ticksSinceActiveChanged > 20 || this.isActive()) {
                this.ticksSinceActiveChanged = 0;
                this.lastActive = this.isActive();
                this.forceClientUpdate = true;
            }
        }
        if (this.hasSound()) {
            this.updateSound();
        }
        if (this.forceClientUpdate) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.forceClientUpdate = false;
        }
    }

    protected boolean doSideIo() {
        if (this.faceModes == null) {
            return false;
        }
        boolean res = false;
        Set<Map.Entry<ForgeDirection, IoMode>> ents = this.faceModes.entrySet();
        for (Map.Entry<ForgeDirection, IoMode> ent : ents) {
            IoMode mode = ent.getValue();
            if (mode.pulls()) {
                res |= this.doPull(ent.getKey());
            }
            if (!mode.pushes()) continue;
            res |= this.doPush(ent.getKey());
        }
        return res;
    }

    protected boolean doPush(ForgeDirection dir) {
        if (this.slotDefinition.getNumOutputSlots() <= 0) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        TileEntity te = this.worldObj.getTileEntity(loc.x, loc.y, loc.z);
        return this.doPush(dir, te, this.slotDefinition.minOutputSlot, this.slotDefinition.maxOutputSlot);
    }

    protected boolean doPush(ForgeDirection dir, TileEntity te, int minSlot, int maxSlot) {
        if (te == null) {
            return false;
        }
        for (int i = minSlot; i <= maxSlot; ++i) {
            int num;
            ItemStack item = this.inventory[i];
            if (item == null || (num = ItemUtil.doInsertItem((Object)te, (ItemStack)item, (ForgeDirection)dir.getOpposite())) <= 0) continue;
            item.stackSize -= num;
            if (item.stackSize <= 0) {
                item = null;
            }
            this.inventory[i] = item;
            this.markDirty();
        }
        return false;
    }

    protected boolean doPull(ForgeDirection dir) {
        if (this.slotDefinition.getNumInputSlots() <= 0) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return false;
        }
        boolean hasSpace = false;
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot && !hasSpace; ++slot) {
            hasSpace = this.inventory[slot] == null ? true : this.inventory[slot].stackSize < Math.min(this.inventory[slot].getMaxStackSize(), this.getInventoryStackLimit(slot));
        }
        if (!hasSpace) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        TileEntity te = this.worldObj.getTileEntity(loc.x, loc.y, loc.z);
        if (te == null) {
            return false;
        }
        if (!(te instanceof IInventory)) {
            return false;
        }
        Object target = te instanceof ISidedInventory ? (ISidedInventory)te : new InventoryWrapper((IInventory)te);
        int[] targetSlots = target.getAccessibleSlotsFromSide(dir.getOpposite().ordinal());
        if (targetSlots == null) {
            return false;
        }
        for (int inputSlot = this.slotDefinition.minInputSlot; inputSlot <= this.slotDefinition.maxInputSlot; ++inputSlot) {
            if (!this.doPull(inputSlot, (ISidedInventory)target, targetSlots, dir)) continue;
            return false;
        }
        return false;
    }

    protected boolean doPull(int inputSlot, ISidedInventory target, int[] targetSlots, ForgeDirection side) {
        for (int i = 0; i < targetSlots.length; ++i) {
            int res;
            int tSlot = targetSlots[i];
            ItemStack targetStack = target.getStackInSlot(tSlot);
            if (targetStack == null || !target.canExtractItem(i, targetStack, side.getOpposite().ordinal()) || (res = ItemUtil.doInsertItem((Object)this, (ItemStack)targetStack, (ForgeDirection)side)) <= 0) continue;
            targetStack = targetStack.copy();
            targetStack.stackSize -= res;
            if (targetStack.stackSize <= 0) {
                targetStack = null;
            }
            target.setInventorySlotContents(tSlot, targetStack);
            return true;
        }
        return false;
    }

    protected abstract boolean processTasks(boolean var1);

    public void invalidate() {
        super.invalidate();
        if (this.worldObj.isRemote) {
            this.updateSound();
        }
    }

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        this.setFacing(nbtRoot.getShort("facing"));
        this.redstoneCheckPassed = nbtRoot.getBoolean("redstoneCheckPassed");
        this.forceClientUpdate = nbtRoot.getBoolean("forceClientUpdate");
        this.readCommon(nbtRoot);
    }

    public void readCommon(NBTTagCompound nbtRoot) {
        int rsContr;
        this.inventory = new ItemStack[this.slotDefinition.getNumSlots()];
        NBTTagList itemList = (NBTTagList)nbtRoot.getTag("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.tagCount(); ++i) {
                NBTTagCompound itemStack = itemList.getCompoundTagAt(i);
                byte slot = itemStack.getByte("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemStack);
            }
        }
        if ((rsContr = nbtRoot.getInteger("redstoneControlMode")) < 0 || rsContr >= RedstoneControlMode.values().length) {
            rsContr = 0;
        }
        this.redstoneControlMode = RedstoneControlMode.values()[rsContr];
        if (nbtRoot.hasKey("hasFaces")) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!nbtRoot.hasKey("face" + dir.ordinal())) continue;
                this.setIoMode(dir, IoMode.values()[nbtRoot.getShort("face" + dir.ordinal())]);
            }
        }
    }

    public void readFromItemStack(ItemStack stack) {
        if (stack == null || stack.stackTagCompound == null) {
            return;
        }
        NBTTagCompound root = stack.stackTagCompound;
        if (!root.hasKey("eio.abstractMachine")) {
            return;
        }
        this.readCommon(root);
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        nbtRoot.setShort("facing", this.facing);
        nbtRoot.setBoolean("redstoneCheckPassed", this.redstoneCheckPassed);
        nbtRoot.setBoolean("forceClientUpdate", this.forceClientUpdate);
        this.forceClientUpdate = false;
        this.writeCommon(nbtRoot);
    }

    public void writeCommon(NBTTagCompound nbtRoot) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(itemStackNBT);
            itemList.appendTag((NBTBase)itemStackNBT);
        }
        nbtRoot.setTag("Items", (NBTBase)itemList);
        nbtRoot.setInteger("redstoneControlMode", this.redstoneControlMode.ordinal());
        if (this.faceModes != null) {
            nbtRoot.setByte("hasFaces", (byte)1);
            for (Map.Entry<ForgeDirection, IoMode> e : this.faceModes.entrySet()) {
                nbtRoot.setShort("face" + e.getKey().ordinal(), (short)e.getValue().ordinal());
            }
        }
    }

    public void writeToItemStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.stackTagCompound == null) {
            stack.stackTagCompound = new NBTTagCompound();
        }
        NBTTagCompound root = stack.stackTagCompound;
        root.setBoolean("eio.abstractMachine", true);
        this.writeCommon(root);
        String name = stack.hasDisplayName() ? stack.getDisplayName() : EnderIO.lang.localizeExact(stack.getUnlocalizedName() + ".name");
        name = name + " " + EnderIO.lang.localize("machine.tooltip.configured");
        stack.setStackDisplayName(name);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int getSizeInventory() {
        return this.slotDefinition.getNumSlots();
    }

    public int getInventoryStackLimit(int slot) {
        return this.getInventoryStackLimit();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack decrStackSize(int fromSlot, int amount) {
        ItemStack fromStack = this.inventory[fromSlot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.stackSize <= amount) {
            this.inventory[fromSlot] = null;
            return fromStack;
        }
        ItemStack result = new ItemStack(fromStack.getItem(), amount, fromStack.getItemDamage());
        if (fromStack.stackTagCompound != null) {
            result.stackTagCompound = (NBTTagCompound)fromStack.stackTagCompound.copy();
        }
        fromStack.stackSize -= amount;
        return result;
    }

    public void setInventorySlotContents(int slot, ItemStack contents) {
        this.inventory[slot] = contents == null ? contents : contents.copy();
        if (contents != null && contents.stackSize > this.getInventoryStackLimit(slot)) {
            contents.stackSize = this.getInventoryStackLimit(slot);
        }
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return null;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public String getInventoryName() {
        return this.getMachineName();
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        if (this.isSideDisabled(var1)) {
            return new int[0];
        }
        return this.allSlots;
    }

    public boolean canInsertItem(int slot, ItemStack itemstack, int side) {
        if (this.isSideDisabled(side) || !this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        ItemStack existing = this.inventory[slot];
        if (existing != null) {
            return existing.isStackable() && existing.isItemEqual(itemstack);
        }
        return this.isMachineItemValidForSlot(slot, itemstack);
    }

    public boolean canExtractItem(int slot, ItemStack itemstack, int side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        if (!this.slotDefinition.isOutputSlot(slot)) {
            return false;
        }
        return this.canExtractItem(slot, itemstack);
    }

    protected boolean canExtractItem(int slot, ItemStack itemstack) {
        if (this.inventory[slot] == null || this.inventory[slot].stackSize < itemstack.stackSize) {
            return false;
        }
        return itemstack.getItem() == this.inventory[slot].getItem();
    }

    public boolean isSideDisabled(int var1) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)var1);
        IoMode mode = this.getIoMode(dir);
        return mode == IoMode.DISABLED;
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }
}

