/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;

public class NightVisionUpgrade
extends AbstractUpgrade {
    private static String UPGRADE_NAME = "nightVision";
    public static final NightVisionUpgrade INSTANCE = new NightVisionUpgrade();

    public static NightVisionUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.stackTagCompound == null) {
            return null;
        }
        if (!stack.stackTagCompound.hasKey("enderio.darksteel.upgrade." + UPGRADE_NAME)) {
            return null;
        }
        return new NightVisionUpgrade((NBTTagCompound)stack.stackTagCompound.getTag("enderio.darksteel.upgrade." + UPGRADE_NAME));
    }

    private static ItemStack createUpgradeItem() {
        ItemStack pot = new ItemStack((Item)Items.potionitem, 1, 0);
        int res = PotionHelper.applyIngredient((int)0, (String)Items.nether_wart.getPotionEffect(new ItemStack(Items.nether_wart)));
        res = PotionHelper.applyIngredient((int)res, (String)PotionHelper.goldenCarrotEffect);
        pot.setItemDamage(res);
        return pot;
    }

    public NightVisionUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
    }

    public NightVisionUpgrade() {
        super(UPGRADE_NAME, "enderio.darksteel.upgrade.nightVision", NightVisionUpgrade.createUpgradeItem(), Config.darkSteelNightVisionCost);
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.getItem() != DarkSteelItems.itemDarkSteelHelmet) {
            return false;
        }
        NightVisionUpgrade up = NightVisionUpgrade.loadFromItem(stack);
        return up == null;
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
    }
}

