/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpoonUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.teleport.TravelController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;

public class ItemDarkSteelPickaxe
extends ItemPickaxe
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel {
    private long lastBlickTick = -1L;

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return false;
        }
        return equipped.getItem() == DarkSteelItems.itemDarkSteelPickaxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        if (!ItemDarkSteelPickaxe.isEquipped(player)) {
            return false;
        }
        return EnergyUpgrade.getEnergyStored(player.getCurrentEquippedItem()) >= requiredPower;
    }

    public static ItemDarkSteelPickaxe create() {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelPickaxe() {
        super(ItemDarkSteelSword.MATERIAL);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        String str = "darkSteel_pickaxe";
        this.setUnlocalizedName(str);
        this.setTextureName(EnderIO.DOMAIN + ":" + str);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        TravelUpgrade.INSTANCE.writeToItem(is);
        SpoonUpgrade.INSTANCE.writeToItem(is);
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean onBlockDestroyed(ItemStack item, World world, Block block, int x, int y, int z, EntityLivingBase entLiving) {
        if ((double)block.getBlockHardness(world, x, y, z) != 0.0 && this.useObsidianEffeciency(item, block)) {
            this.extractEnergy(item, Config.darkSteelPickPowerUseObsidian, false);
        }
        return super.onBlockDestroyed(item, world, block, x, y, z, entLiving);
    }

    public boolean onItemUse(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (!this.isTravelUpgradeActive(player, item) && world.isRemote) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, x, y, z, side, par8, par9, par10);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    static boolean doRightClickItemPlace(EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int slot;
        int current = player.inventory.currentItem;
        int n = slot = current == 0 && Config.slotZeroPlacesEight ? 8 : current + 1;
        if (slot < 9 && player.inventory.mainInventory[slot] != null && !(player.inventory.mainInventory[slot].getItem() instanceof IDarkSteelItem)) {
            player.inventory.currentItem = slot;
            Minecraft mc = Minecraft.getMinecraft();
            boolean result = mc.playerController.onPlayerRightClick((EntityPlayer)mc.thePlayer, (World)mc.theWorld, player.inventory.mainInventory[slot], mc.objectMouseOver.blockX, mc.objectMouseOver.blockY, mc.objectMouseOver.blockZ, mc.objectMouseOver.sideHit, mc.objectMouseOver.hitVec);
            player.inventory.currentItem = current;
            return result;
        }
        return false;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelPickPowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack item) {
        if (this.hasSpoonUpgrade(item) && this.getEnergyStored(item) > 0) {
            return block == Blocks.snow_layer ? true : block == Blocks.snow || super.canHarvestBlock(block, item);
        }
        return super.canHarvestBlock(block, item);
    }

    private boolean hasSpoonUpgrade(ItemStack item) {
        return SpoonUpgrade.loadFromItem(item) != null;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.useObsidianEffeciency(stack, block)) {
            return ItemDarkSteelSword.MATERIAL.getEfficiencyOnProperMaterial() + Config.darkSteelPickEffeciencyBoostWhenPowered + (float)Config.darkSteelPickEffeciencyObsidian;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || this.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.getEfficiencyOnProperMaterial() + Config.darkSteelPickEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.getEfficiencyOnProperMaterial();
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public float func_150893_a(ItemStack item, Block block) {
        if (block.getMaterial() == Material.glass) {
            return this.efficiencyOnProperMaterial;
        }
        return super.func_150893_a(item, block);
    }

    private boolean useObsidianEffeciency(ItemStack item, Block block) {
        boolean useObsidianSpeed = false;
        int energy = this.getEnergyStored(item);
        if (energy > Config.darkSteelPickPowerUseObsidian) {
            boolean bl = useObsidianSpeed = block == Blocks.obsidian;
            if (!useObsidianSpeed && Config.darkSteelPickApplyObsidianEffeciencyAtHardess > 0.0f) {
                try {
                    useObsidianSpeed = block != null && block.getBlockHardness(null, -1, -1, -1) >= Config.darkSteelPickApplyObsidianEffeciencyAtHardess;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return useObsidianSpeed;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet set = Sets.newHashSet((Object[])new String[]{"pickaxe"});
        if (this.hasSpoonUpgrade(stack)) {
            set.add("shovel");
        }
        return set;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.getUnlocalizedName());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean getIsRepairable(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyObsidian + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effObs") + " ");
            list.add(EnumChatFormatting.WHITE + "     " + "(" + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.cost") + " " + PowerDisplayUtil.formatPower(Config.darkSteelPickPowerUseObsidian) + " " + PowerDisplayUtil.abrevation() + ")");
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped);
    }

    @Override
    public void extractInternal(ItemStack equipped, int power) {
        this.extractEnergy(equipped, power, false);
    }

    private boolean isTravelUpgradeActive(EntityPlayer ep, ItemStack equipped) {
        return ItemDarkSteelPickaxe.isEquipped(ep) && ep.isSneaking() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (this.isTravelUpgradeActive(player, stack)) {
            if (world.isRemote && TravelController.instance.activateTravelAccessable(stack, world, player, TravelSource.STAFF)) {
                player.swingItem();
                return stack;
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.isRemote && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, player)) {
                player.swingItem();
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return stack;
        }
        return super.onItemRightClick(stack, world, player);
    }
}

