/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelPickaxe;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDarkSteelAxe
extends ItemAxe
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem {
    private int logOreId = -1;
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.getCurrentEquippedItem();
        if (equipped == null) {
            return false;
        }
        return equipped.getItem() == DarkSteelItems.itemDarkSteelAxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelAxe.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        if (!ItemDarkSteelAxe.isEquipped(player)) {
            return 0;
        }
        return EnergyUpgrade.getEnergyStored(player.getCurrentEquippedItem());
    }

    public static ItemDarkSteelAxe create() {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected ItemDarkSteelAxe() {
        super(ItemDarkSteelSword.MATERIAL);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        String str = "darkSteel_axe";
        this.setUnlocalizedName(str);
        this.setTextureName(EnderIO.DOMAIN + ":" + str);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        par3List.add(is);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        int blockMetadata;
        Block block;
        if (!player.worldObj.isRemote && player.isSneaking() && this.isLog(block = player.worldObj.getBlock(X, Y, Z), blockMetadata = player.worldObj.getBlockMetadata(X, Y, Z))) {
            int powerStored = EnergyUpgrade.getEnergyStored(itemstack);
            TreeHarvestUtil harvester = new TreeHarvestUtil();
            HarvestResult res = new HarvestResult();
            BlockCoord bc = new BlockCoord(X, Y, Z);
            harvester.harvest(player.worldObj, bc, res);
            ArrayList<BlockCoord> sortedTargets = new ArrayList<BlockCoord>(res.getHarvestedBlocks());
            this.harvestComparator.refPoint = bc;
            Collections.sort(sortedTargets, this.harvestComparator);
            int maxBlocks = powerStored / Config.darkSteelAxePowerUsePerDamagePointMultiHarvest;
            int numUsedPower = 0;
            for (int i = 0; numUsedPower < maxBlocks && i < sortedTargets.size(); ++i) {
                if (!this.doMultiHarvest(player, player.worldObj, (BlockCoord)sortedTargets.get(i), block, blockMetadata % 4)) continue;
                ++numUsedPower;
            }
            return numUsedPower != 0;
        }
        return false;
    }

    private boolean doMultiHarvest(EntityPlayer player, World worldObj, BlockCoord bc, Block refBlock, int refMeta) {
        Block block = worldObj.getBlock(bc.x, bc.y, bc.z);
        int meta = worldObj.getBlockMetadata(bc.x, bc.y, bc.z);
        ArrayList itemDrops = block.getDrops(worldObj, bc.x, bc.y, bc.z, meta, 0);
        worldObj.setBlockToAir(bc.x, bc.y, bc.z);
        boolean usedPower = false;
        if (itemDrops != null) {
            for (ItemStack stack : itemDrops) {
                worldObj.spawnEntityInWorld((Entity)new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.copy()));
                if (TreeHarvestUtil.canDropApples(block, meta)) {
                    if (worldObj.rand.nextInt(200) != 0) continue;
                    worldObj.spawnEntityInWorld((Entity)new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, new ItemStack(Items.apple)));
                    continue;
                }
                if (block != refBlock) continue;
                this.extractEnergy(player.getCurrentEquippedItem(), Config.darkSteelAxePowerUsePerDamagePointMultiHarvest, false);
                usedPower = true;
            }
        }
        return usedPower;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if (evt.entityPlayer.isSneaking() && ItemDarkSteelAxe.isEquippedAndPowered(evt.entityPlayer, Config.darkSteelAxePowerUsePerDamagePointMultiHarvest) && this.isLog(evt.block, evt.metadata)) {
            evt.newSpeed = evt.originalSpeed / Config.darkSteelAxeSpeedPenaltyMultiHarvest;
        }
        if (ItemDarkSteelAxe.isEquipped(evt.entityPlayer) && evt.block.getMaterial() == Material.leaves) {
            evt.newSpeed = 6.0f;
        }
    }

    public boolean onItemUse(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (world.isRemote) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, x, y, z, side, par8, par9, par10);
        }
        return false;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelAxePowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || this.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.getEfficiencyOnProperMaterial() + Config.darkSteelAxeEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.getEfficiencyOnProperMaterial();
        }
        return super.getDigSpeed(stack, block, meta);
    }

    private boolean isLog(Block block, int meta) {
        if (this.logOreId == -1) {
            this.logOreId = OreDictionary.getOreID((String)"logWood");
        }
        int targetOreId = OreDictionary.getOreID((ItemStack)new ItemStack(block, 1, meta));
        int workAroundId = OreDictionary.getOreID((ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
        return targetOreId == this.logOreId || workAroundId == this.logOreId;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.getUnlocalizedName());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean getIsRepairable(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnderIO.lang.localize("item.darkSteel_axe.tooltip.multiHarvest"));
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelAxeEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockCoord> {
        BlockCoord refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockCoord arg0, BlockCoord arg1) {
            int d1 = this.refPoint.getDistSq(arg0);
            int d2 = this.refPoint.getDistSq(arg1);
            return MultiHarvestComparator.compare(d1, d1);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

