/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.BaublesUtil;
import crazypants.util.BotaniaUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class MagnetController
implements IEntitySelector {
    private static List<Item> blacklist = null;

    public MagnetController() {
        PacketHandler.INSTANCE.registerMessage(PacketMagnetState.class, PacketMagnetState.class, PacketHandler.nextID(), Side.SERVER);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ActiveMagnet mag = this.getActiveMagnet(event.player);
        if (mag != null && event.player.getHealth() > 0.0f) {
            this.doHoover(event.player);
            if (event.side == Side.SERVER && event.player.worldObj.getTotalWorldTime() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(mag.item);
                event.player.inventory.setInventorySlotContents(mag.slot, mag.item);
                event.player.inventory.markDirty();
            }
        }
    }

    private ActiveMagnet getActiveMagnet(EntityPlayer player) {
        ItemStack[] inv = player.inventory.mainInventory;
        int maxSlot = Config.magnetAllowInMainInventory ? 36 : 9;
        for (int i = 0; i < maxSlot; ++i) {
            if (!ItemMagnet.isActive(inv[i]) || !ItemMagnet.hasPower(inv[i])) continue;
            return new ActiveMagnet(inv[i], i);
        }
        return null;
    }

    public void doHoover(EntityPlayer player) {
        if (blacklist == null) {
            MagnetController.initBlacklist();
        }
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)(player.posX - (double)Config.magnetRange), (double)(player.posY - (double)Config.magnetRange), (double)(player.posZ - (double)Config.magnetRange), (double)(player.posX + (double)Config.magnetRange), (double)(player.posY + (double)Config.magnetRange), (double)(player.posZ + (double)Config.magnetRange));
        List interestingItems = player.worldObj.selectEntitiesWithinAABB(EntityItem.class, aabb, (IEntitySelector)this);
        List xp = player.worldObj.selectEntitiesWithinAABB(EntityXPOrb.class, aabb, (IEntitySelector)this);
        if (!xp.isEmpty()) {
            interestingItems.addAll(xp);
        }
        for (Entity entity : interestingItems) {
            double x = player.posX + 0.5 - entity.posX;
            double y = player.posY + 1.0 - entity.posY;
            double z = player.posZ + 0.5 - entity.posZ;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.25) {
                entity.onCollideWithPlayer(player);
                continue;
            }
            double speed = 0.035;
            entity.motionX += x / distance * speed;
            entity.motionY += y * speed;
            if (y > 0.0) {
                entity.motionY = 0.12;
            }
            entity.motionZ += z / distance * speed;
        }
    }

    private static void initBlacklist() {
        blacklist = new ArrayList<Item>();
        for (String name : Config.magnetBlacklist) {
            Item item;
            String[] parts = name.split(":");
            if (parts.length != 2 || (item = GameRegistry.findItem((String)parts[0], (String)parts[1])) == null) continue;
            blacklist.add(item);
        }
    }

    public boolean isEntityApplicable(Entity var1) {
        if (var1.isDead) {
            return false;
        }
        if (var1 instanceof EntityItem) {
            if (!blacklist.isEmpty()) {
                Item item = ((EntityItem)var1).getEntityItem().getItem();
                for (Item blacklisted : blacklist) {
                    if (blacklisted != item) continue;
                    return false;
                }
            }
            return !BotaniaUtil.hasSolegnoliaAround(var1);
        }
        return true;
    }

    public static void setMagnetActive(EntityPlayerMP player, PacketMagnetState.SlotType type, int slot, boolean isActive) {
        ItemStack stack = null;
        IInventory baubles = null;
        int dropOff = -1;
        switch (type) {
            case INVENTORY: {
                stack = player.inventory.getStackInSlot(slot);
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles == null) break;
                stack = baubles.getStackInSlot(slot);
            }
        }
        if (stack == null || stack.getItem() == null || stack.getItem() != DarkSteelItems.itemMagnet || ItemMagnet.isActive(stack) == isActive) {
            return;
        }
        if (!Config.magnetAllowDeactivatedInBaublesSlot && type == PacketMagnetState.SlotType.BAUBLES && !isActive) {
            ItemStack[] inv = player.inventory.mainInventory;
            for (int i = 0; i < inv.length && dropOff < 0; ++i) {
                if (inv[i] != null) continue;
                dropOff = i;
            }
            if (dropOff < 0) {
                return;
            }
        }
        ItemMagnet.setActive(stack, isActive);
        switch (type) {
            case INVENTORY: {
                player.inventory.setInventorySlotContents(slot, stack);
                player.inventory.markDirty();
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                if (dropOff < 0) {
                    baubles.setInventorySlotContents(slot, stack);
                } else {
                    baubles.setInventorySlotContents(slot, null);
                    player.inventory.setInventorySlotContents(dropOff, stack);
                }
                player.inventory.markDirty();
            }
        }
    }

    private static class ActiveMagnet {
        ItemStack item;
        int slot;

        ActiveMagnet(ItemStack item, int slot) {
            this.item = item;
            this.slot = slot;
        }
    }
}

