/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import com.enderio.core.api.client.render.IWidgetIcon;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ConduitProbeOverlayRenderer {
    public ConduitProbeOverlayRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        ItemStack equippedProbe = this.getEquippedProbe();
        if (equippedProbe != null && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            this.doRenderOverlay(event, equippedProbe);
        }
    }

    private ItemStack getEquippedProbe() {
        ItemStack equipped = Minecraft.getMinecraft().thePlayer.getCurrentEquippedItem();
        if (equipped != null && equipped.getItem() == EnderIO.itemConduitProbe) {
            return equipped;
        }
        return null;
    }

    private void doRenderOverlay(RenderGameOverlayEvent event, ItemStack equippedProbe) {
        IconEIO icon2;
        IconEIO icon1;
        if (equippedProbe.getItemDamage() == 0) {
            icon1 = IconEIO.PROBE_OVERLAY_PROBE;
            icon2 = IconEIO.PROBE_OVERLAY_COPY_OFF;
        } else {
            icon1 = IconEIO.PROBE_OVERLAY_PROBE_OFF;
            icon2 = IconEIO.PROBE_OVERLAY_COPY;
        }
        ScaledResolution res = event.resolution;
        double offsetX = res.getScaledWidth() - 48;
        double offsetY = res.getScaledHeight() - 16;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        icon1.getMap().render((IWidgetIcon)icon1, offsetX - 32.0, offsetY - 32.0, 32.0, 32.0, 0.0, true);
        icon2.getMap().render((IWidgetIcon)icon2, offsetX, offsetY - 32.0, 32.0, 32.0, 0.0, true);
    }
}

