/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.generator.stirling.StirlingGeneratorContainer;
import crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class TooltipHandlerBurnTime
implements SpecialTooltipHandler.ITooltipCallback {
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        int time = 0;
        TileEntityStirlingGenerator gen = this.getStirlingGen(itemstack);
        if (this.isStirlingGen(itemstack, gen)) {
            int rate = gen.getPowerUsePerTick();
            String msg = String.format("%s %s %s %s %s %s%s", EnderIO.lang.localize("power.generates"), PowerDisplayUtil.formatPower((long)gen.getBurnTime(itemstack) * (long)rate), PowerDisplayUtil.abrevation(), EnderIO.lang.localize("power.generation_rate"), PowerDisplayUtil.formatPower(rate), PowerDisplayUtil.abrevation(), PowerDisplayUtil.perTickStr());
            list.add(msg);
        } else if (Config.addFurnaceFuelTootip && (time = TileEntityFurnace.getItemBurnTime((ItemStack)itemstack)) > 0) {
            list.add(EnderIO.lang.localize("tooltip.burntime") + " " + time);
        }
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public boolean shouldHandleItem(ItemStack item) {
        int time = TileEntityFurnace.getItemBurnTime((ItemStack)item);
        return time > 0 || this.isStirlingGen(item);
    }

    private TileEntityStirlingGenerator getStirlingGen(ItemStack stack) {
        AbstractMachineEntity te;
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        if (player != null && player.openContainer instanceof StirlingGeneratorContainer && (te = (AbstractMachineEntity)((StirlingGeneratorContainer)player.openContainer).getInv()) instanceof TileEntityStirlingGenerator) {
            return (TileEntityStirlingGenerator)te;
        }
        return null;
    }

    private boolean isStirlingGen(ItemStack stack) {
        return this.isStirlingGen(stack, this.getStirlingGen(stack));
    }

    private boolean isStirlingGen(ItemStack stack, TileEntityStirlingGenerator gen) {
        return gen == null ? false : gen.getBurnTime(stack) > 0;
    }
}

