/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enderface;

import com.enderio.core.common.Handlers;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;

@Handlers.Handler
public enum EnderIOController {
    INSTANCE;

    private TObjectIntMap<UUID> openedContainers = new TObjectIntHashMap();
    private int clientWindowId;
    private boolean locked = false;

    public void addContainer(EntityPlayerMP player, Container opened) {
        this.openedContainers.put((Object)player.getGameProfile().getId(), opened.windowId);
    }

    void lockAndWaitForChange(int windowId) {
        this.clientWindowId = windowId;
        this.locked = true;
    }

    void unlock() {
        this.locked = false;
    }

    @SubscribeEvent
    public void onContainerTick(PlayerOpenContainerEvent event) {
        Container c = event.entityPlayer.openContainer;
        if (c != null && !(c instanceof ContainerPlayer) && (c.windowId == this.clientWindowId || this.openedContainers.containsValue(c.windowId))) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.side.isServer()) {
                int windowId = this.openedContainers.get((Object)event.player.getGameProfile().getId());
                if (event.player.openContainer == null || event.player.openContainer.windowId != windowId) {
                    this.openedContainers.remove((Object)event.player.getGameProfile().getId());
                }
            } else {
                int windowId = event.player.openContainer.windowId;
                if (windowId != this.clientWindowId && this.locked) {
                    this.clientWindowId = windowId;
                    this.locked = false;
                    System.out.println("Unlocked and set windowId to " + this.clientWindowId);
                }
            }
        }
    }
}

