/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enderface;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.enderface.PacketLockClientContainer;
import crazypants.enderio.enderface.PacketOpenServerGUI;
import crazypants.enderio.enderface.TileEnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderIO
extends BlockEio
implements IResourceTooltipProvider {
    @SideOnly(value=Side.CLIENT)
    IIcon frameIcon;
    @SideOnly(value=Side.CLIENT)
    IIcon selectedOverlayIcon;
    @SideOnly(value=Side.CLIENT)
    IIcon highlightOverlayIcon;
    static int pass;

    public static BlockEnderIO create() {
        PacketHandler.INSTANCE.registerMessage(PacketOpenServerGUI.class, PacketOpenServerGUI.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketLockClientContainer.Handler.class, PacketLockClientContainer.class, PacketHandler.nextID(), Side.CLIENT);
        BlockEnderIO result = new BlockEnderIO();
        result.init();
        return result;
    }

    private BlockEnderIO() {
        super(ModObject.blockEnderIo.unlocalisedName, TileEnderIO.class);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderBlockPass() {
        return 1;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEnderIO) {
            TileEnderIO eio = (TileEnderIO)te;
            eio.initUiPitch = -player.rotationPitch;
            eio.initUiYaw = -player.rotationYaw + 180.0f;
            eio.lastUiPitch = eio.initUiPitch;
            eio.lastUiYaw = eio.initUiYaw;
            if (player instanceof EntityPlayer) {
                eio.setPlacedBy((EntityPlayer)player);
            }
            world.markBlockForUpdate(x, y, z);
        }
    }

    public boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof ITravelAccessable) {
            ITravelAccessable ta = (ITravelAccessable)te;
            if (ta.canUiBeAccessed(entityPlayer)) {
                entityPlayer.openGui((Object)EnderIO.instance, 18, world, x, y, z);
            } else {
                BlockTravelAnchor.sendPrivateChatMessage(entityPlayer, ta.getPlacedBy());
            }
            return true;
        }
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return -1;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 13;
    }

    public int getLightOpacity() {
        return 100;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        super.registerBlockIcons(iIconRegister);
        this.frameIcon = iIconRegister.registerIcon("enderio:enderIOFrame");
        this.highlightOverlayIcon = iIconRegister.registerIcon("enderio:enderIOHighlight");
        this.selectedOverlayIcon = iIconRegister.registerIcon("enderio:enderIOSelected");
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.getUnlocalizedName();
    }
}

