/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.IBlockAccessWrapper;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.BlockConduitBundle;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.facade.BlockConduitFacade;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ConduitBundleRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    public ConduitBundleRenderer(float conduitScale) {
    }

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float partialTick) {
        IConduitBundle bundle = (IConduitBundle)te;
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        if (bundle.hasFacade() && bundle.getFacadeId().isOpaqueCube() && !ConduitUtil.isFacadeHidden(bundle, (EntityPlayer)player)) {
            return;
        }
        float brightness = -1.0f;
        for (IConduit con : bundle.getConduits()) {
            ConduitRenderer renderer;
            if (!ConduitUtil.renderConduit((EntityPlayer)player, con) || !(renderer = EnderIO.proxy.getRendererForConduit(con)).isDynamic()) continue;
            if (brightness == -1.0f) {
                BlockCoord loc = bundle.getLocation();
                brightness = bundle.getEntity().getWorldObj().getLightBrightnessForSkyBlocks(loc.x, loc.y, loc.z, 0);
                RenderUtil.bindBlockTexture();
                GL11.glPushAttrib((int)8192);
                GL11.glPushAttrib((int)64);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glShadeModel((int)7425);
                GL11.glPushMatrix();
                GL11.glTranslated((double)x, (double)y, (double)z);
                Tessellator.instance.startDrawingQuads();
            }
            renderer.renderDynamicEntity(this, bundle, con, x, y, z, partialTick, brightness);
        }
        if (brightness != -1.0f) {
            Tessellator.instance.draw();
            GL11.glShadeModel((int)7424);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            GL11.glPopAttrib();
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks rb) {
        EntityClientPlayerMP player;
        IConduitBundle bundle;
        boolean renderedFacade;
        boolean renderConduit;
        int pass = MinecraftForgeClient.getRenderPass();
        int n = pass = pass >= 0 ? pass : ForgeHooksClient.getWorldRenderPass();
        if (pass == 1) {
            Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
            Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
            Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
            Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        }
        boolean bl = renderConduit = !(renderedFacade = this.renderFacade(x, y, z, pass, rb, bundle = (IConduitBundle)world.getTileEntity(x, y, z), player = Minecraft.getMinecraft().thePlayer)) || ConduitUtil.isFacadeHidden(bundle, (EntityPlayer)player);
        if (renderConduit && (pass == 0 || rb.overrideBlockTexture != null)) {
            BlockCoord loc = bundle.getLocation();
            float brightness = !Config.updateLightingWhenHidingFacades && bundle.hasFacade() && ConduitUtil.isFacadeHidden(bundle, (EntityPlayer)player) ? 1.572888E7f : (float)bundle.getEntity().getWorldObj().getLightBrightnessForSkyBlocks(loc.x, loc.y, loc.z, 0);
            this.renderConduits(bundle, x, y, z, 0.0f, brightness, rb);
            return true;
        }
        return renderedFacade || bundle.hasFacade() && !bundle.getFacadeId().isOpaqueCube();
    }

    private boolean renderFacade(int x, int y, int z, int pass, RenderBlocks rb, IConduitBundle bundle, EntityClientPlayerMP player) {
        boolean res = false;
        if (bundle.hasFacade()) {
            res = true;
            Block facadeId = bundle.getFacadeId();
            if (ConduitUtil.isFacadeHidden(bundle, (EntityPlayer)player)) {
                Tessellator.instance.setColorOpaque_F(1.0f, 1.0f, 1.0f);
                bundle.setFacadeId(null, false);
                bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.WIRE_FRAME);
                BlockConduitFacade facb = EnderIO.blockConduitFacade;
                facb.setBlockOverride(bundle);
                facb.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (!rb.hasOverrideBlockTexture()) {
                    rb.setRenderBoundsFromBlock((Block)facb);
                    rb.renderStandardBlock((Block)facb, x, y, z);
                }
                facb.setBlockOverride(null);
                bundle.setFacadeId(facadeId, false);
            } else if (facadeId != null) {
                bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.FULL);
                boolean isFacadeOpaque = facadeId.isOpaqueCube();
                if (isFacadeOpaque && pass == 0 || rb.hasOverrideBlockTexture() || !isFacadeOpaque && pass == 1) {
                    IBlockAccess origBa = rb.blockAccess;
                    rb.blockAccess = new FacadeAccessWrapper(origBa);
                    try {
                        rb.renderBlockByRenderType(facadeId, x, y, z);
                    }
                    catch (Exception e) {
                        rb.setOverrideBlockTexture(IconUtil.errorTexture);
                        rb.renderStandardBlock(Blocks.stone, x, y, z);
                        rb.setOverrideBlockTexture(null);
                    }
                    rb.blockAccess = origBa;
                }
                res = isFacadeOpaque;
            }
        } else {
            bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.NONE);
        }
        return res;
    }

    public void renderConduits(IConduitBundle bundle, double x, double y, double z, float partialTick, float brightness, RenderBlocks rb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        tessellator.addTranslation((float)x, (float)y, (float)z);
        HashSet<ForgeDirection> externals = new HashSet<ForgeDirection>();
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        ArrayList<BoundingBox> wireBounds = new ArrayList<BoundingBox>();
        for (IConduit con : bundle.getConduits()) {
            if (ConduitUtil.renderConduit((EntityPlayer)player, con)) {
                ConduitRenderer renderer = EnderIO.proxy.getRendererForConduit(con);
                renderer.renderEntity(this, bundle, con, x, y, z, partialTick, brightness, rb);
                Set<ForgeDirection> extCons = con.getExternalConnections();
                Iterator iterator = extCons.iterator();
                while (iterator.hasNext()) {
                    ForgeDirection dir = (ForgeDirection)iterator.next();
                    if (con.getConnectionMode(dir) == ConnectionMode.DISABLED || con.getConnectionMode(dir) == ConnectionMode.NOT_SET) continue;
                    externals.add(dir);
                }
                continue;
            }
            if (con == null) continue;
            Collection<CollidableComponent> components = con.getCollidableComponents();
            for (CollidableComponent component : components) {
                wireBounds.add(component.bound);
            }
        }
        List<CollidableComponent> connectors = bundle.getConnectors();
        ArrayList rendered = Lists.newArrayList();
        for (CollidableComponent component : connectors) {
            if (component.conduitType != null) {
                IConduit conduit = bundle.getConduit(component.conduitType);
                if (conduit == null) continue;
                if (ConduitUtil.renderConduit((EntityPlayer)player, component.conduitType)) {
                    if (rb.hasOverrideBlockTexture()) {
                        List<RaytraceResult> results = EnderIO.blockConduitBundle.doRayTraceAll(bundle.getWorld(), MathHelper.floor_double((double)x), MathHelper.floor_double((double)y), MathHelper.floor_double((double)z), EnderIO.proxy.getClientPlayer());
                        for (RaytraceResult r : results) {
                            if (r.component.conduitType != component.conduitType || rendered.contains(r.component)) continue;
                            rendered.add(r.component);
                            CubeRenderer.render((BoundingBox)component.bound, (IIcon)rb.overrideBlockTexture, (boolean)true);
                        }
                        continue;
                    }
                    tessellator.setBrightness((int)brightness);
                    CubeRenderer.render((BoundingBox)component.bound, (IIcon)conduit.getTextureForState(component), (boolean)true);
                    continue;
                }
                wireBounds.add(component.bound);
                continue;
            }
            if (ConduitUtil.getDisplayMode((EntityPlayer)player) != ConduitDisplayMode.ALL || rb.hasOverrideBlockTexture()) continue;
            IIcon tex = EnderIO.blockConduitBundle.getConnectorIcon(component.data);
            CubeRenderer.render((BoundingBox)component.bound, (IIcon)tex);
        }
        for (BoundingBox wireBound : wireBounds) {
            Tessellator.instance.setColorRGBA_F(1.0f, 1.0f, 1.0f, 0.25f);
            CubeRenderer.render((BoundingBox)wireBound, (IIcon)EnderIO.blockConduitFacade.getIcon(0, 0));
        }
        Tessellator.instance.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        if (rb.overrideBlockTexture == null) {
            for (ForgeDirection dir : externals) {
                this.renderExternalConnection(dir);
            }
        }
        tessellator.addTranslation(-((float)x), -((float)y), -((float)z));
    }

    private void renderExternalConnection(ForgeDirection dir) {
        BoundingBox[] bbs;
        IIcon tex = EnderIO.blockConduitBundle.getConnectorIcon((Object)ConduitConnectorType.EXTERNAL);
        for (BoundingBox bb : bbs = ConduitGeometryUtil.instance.getExternalConnectorBoundingBoxes(dir)) {
            CubeRenderer.render((BoundingBox)bb, (IIcon)tex, (boolean)true);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public int getRenderId() {
        return BlockConduitBundle.rendererId;
    }

    public static class FacadeAccessWrapper
    extends IBlockAccessWrapper {
        public FacadeAccessWrapper(IBlockAccess ba) {
            super(ba);
        }

        public Block getBlock(int x, int y, int z) {
            TileConduitBundle tcb;
            Block fac;
            TileEntity te;
            Block res = super.getBlock(x, y, z);
            if (res == EnderIO.blockConduitBundle && (te = this.getTileEntity(x, y, z)) instanceof TileConduitBundle && (fac = (tcb = (TileConduitBundle)te).getFacadeId()) != null) {
                res = fac;
            }
            return res;
        }

        @SideOnly(value=Side.CLIENT)
        public int getLightBrightnessForSkyBlocks(int var1, int var2, int var3, int var4) {
            return this.wrapped.getLightBrightnessForSkyBlocks(var1, var2, var3, var4);
        }

        public int getBlockMetadata(int x, int y, int z) {
            TileConduitBundle tcb;
            Block fac;
            TileEntity te;
            Block block = super.getBlock(x, y, z);
            if (block == EnderIO.blockConduitBundle && (te = this.getTileEntity(x, y, z)) instanceof TileConduitBundle && (fac = (tcb = (TileConduitBundle)te).getFacadeId()) != null) {
                return tcb.getFacadeMetadata();
            }
            return super.getBlockMetadata(x, y, z);
        }
    }
}

