/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneSwitchBounds;
import crazypants.enderio.conduit.redstone.Signal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneSwitch
extends RedstoneConduit {
    static final String SWITCH_TAG = "switch";
    public static final String SWITHC_ICON_OFF_KEY = "enderio:redstoneConduitSwitchOff";
    public static final String SWITCH_ICON_ON_KEY = "enderio:redstoneConduitSwitchOn";
    private boolean isOn;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                RedstoneConduit.ICONS.put(RedstoneSwitch.SWITHC_ICON_OFF_KEY, register.registerIcon(RedstoneSwitch.SWITHC_ICON_OFF_KEY));
                RedstoneConduit.ICONS.put(RedstoneSwitch.SWITCH_ICON_ON_KEY, register.registerIcon(RedstoneSwitch.SWITCH_ICON_ON_KEY));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemRedstoneConduit, 1, 1);
    }

    @Override
    public int isProvidingStrongPower(ForgeDirection toDirection) {
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        return this.isOn ? 15 : 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setBoolean("switchOn", this.isOn);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.isOn = nbtRoot.getBoolean("switchOn");
    }

    IIcon getSwitchIcon() {
        return this.isOn ? (IIcon)ICONS.get(SWITCH_ICON_ON_KEY) : (IIcon)ICONS.get(SWITHC_ICON_OFF_KEY);
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (SWITCH_TAG.equals(component.data)) {
            return this.isOn ? (IIcon)ICONS.get(SWITCH_ICON_ON_KEY) : (IIcon)ICONS.get(SWITHC_ICON_OFF_KEY);
        }
        return super.getTextureForState(component);
    }

    @Override
    public List<CollidableComponent> getCollidableComponents() {
        BoundingBox[] aabb;
        if (this.collidables != null && !this.collidablesDirty) {
            return this.collidables;
        }
        Offset o = this.getBundle().getOffset(this.getBaseConduitType(), ForgeDirection.UNKNOWN);
        Vector3d trans = ConduitGeometryUtil.instance.getTranslation(ForgeDirection.UNKNOWN, o);
        Collection result = super.getCollidableComponents();
        for (BoundingBox bb : aabb = RedstoneSwitchBounds.getInstance().getAABB()) {
            result.add(new CollidableComponent(IRedstoneConduit.class, bb.translate(trans), ForgeDirection.UNKNOWN, SWITCH_TAG));
        }
        return result;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (res != null && res.component != null && res.component.data != null && res.component.data.equals(SWITCH_TAG)) {
            this.toggleSwitch();
            return true;
        }
        return false;
    }

    private void toggleSwitch() {
        boolean bl = this.isOn = !this.isOn;
        if (this.network == null) {
            return;
        }
        TileEntity te = this.bundle.getEntity();
        Signal signal = new Signal(te.xCoord, te.yCoord, te.zCoord, ForgeDirection.UNKNOWN, 15, DyeColor.RED);
        if (this.isOn) {
            this.network.addSignal(signal);
        } else {
            this.network.removeSignal(signal);
        }
    }

    @Override
    public Set<Signal> getNetworkInputs() {
        Set<Signal> res = super.getNetworkInputs();
        if (this.isOn) {
            BlockCoord loc = this.getLocation();
            Signal signal = new Signal(loc.x, loc.y, loc.z, ForgeDirection.UNKNOWN, 15, DyeColor.RED);
            res.add(signal);
        }
        return res;
    }
}

