/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.common.util.FluidUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilter {
    private final Fluid[] fluids = new Fluid[5];
    private boolean isBlacklist;

    public boolean isEmpty() {
        for (Fluid f : this.fluids) {
            if (f == null) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.fluids.length;
    }

    public Fluid getFluidAt(int index) {
        return this.fluids[index];
    }

    public boolean setFluid(int index, Fluid fluid) {
        this.fluids[index] = fluid;
        return true;
    }

    public boolean setFluid(int index, FluidStack fluid) {
        return this.setFluid(index, fluid.getFluid());
    }

    public boolean setFluid(int index, ItemStack stack) {
        if (stack == null) {
            return this.setFluid(index, (Fluid)null);
        }
        FluidStack f = FluidUtil.getFluidFromItem((ItemStack)stack);
        if (f == null || f.getFluid() == null) {
            return false;
        }
        return this.setFluid(index, f);
    }

    public boolean removeFluid(int index) {
        if (index < 0 || index >= this.fluids.length) {
            return false;
        }
        this.fluids[index] = null;
        return true;
    }

    protected void setFluid(int index, String fluidName) {
        Fluid f;
        this.fluids[index] = f = FluidRegistry.getFluid((String)fluidName);
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    public boolean isDefault() {
        return !this.isBlacklist && this.isEmpty();
    }

    public void writeToNBT(NBTTagCompound root) {
        root.setBoolean("isBlacklist", this.isBlacklist);
        if (this.isEmpty()) {
            root.removeTag("fluidFilter");
            return;
        }
        NBTTagList fluidList = new NBTTagList();
        int index = 0;
        for (Fluid f : this.fluids) {
            if (f != null) {
                NBTTagCompound fRoot = new NBTTagCompound();
                fRoot.setInteger("index", index);
                fRoot.setString("fluidName", f.getName());
                fluidList.appendTag((NBTBase)fRoot);
            }
            ++index;
        }
        root.setTag("fluidFilter", (NBTBase)fluidList);
    }

    public void readFromNBT(NBTTagCompound root) {
        this.isBlacklist = root.getBoolean("isBlacklist");
        if (!root.hasKey("fluidFilter")) {
            this.clear();
            return;
        }
        NBTTagList fluidList = (NBTTagList)root.getTag("fluidFilter");
        for (int i = 0; i < fluidList.tagCount(); ++i) {
            NBTTagCompound fRoot = fluidList.getCompoundTagAt(i);
            this.setFluid(fRoot.getInteger("index"), fRoot.getString("fluidName"));
        }
    }

    private void clear() {
        for (int i = 0; i < this.fluids.length; ++i) {
            this.fluids[i] = null;
        }
    }

    public boolean matchesFilter(FluidStack drained) {
        if (drained == null || drained.getFluid() == null) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        for (Fluid f : this.fluids) {
            if (f == null || f.getID() != drained.getFluid().getID()) continue;
            return !this.isBlacklist;
        }
        return this.isBlacklist;
    }
}

