/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.reservoir.TileReservoir;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class AbstractLiquidConduit
extends AbstractConduit
implements ILiquidConduit {
    protected final EnumMap<ForgeDirection, RedstoneControlMode> extractionModes = new EnumMap(ForgeDirection.class);
    protected final EnumMap<ForgeDirection, DyeColor> extractionColors = new EnumMap(ForgeDirection.class);
    protected final Map<ForgeDirection, Integer> externalRedstoneSignals = new HashMap<ForgeDirection, Integer>();
    protected boolean redstoneStateDirty = true;

    public static IFluidHandler getExternalFluidHandler(IBlockAccess world, BlockCoord bc) {
        IFluidHandler con = FluidUtil.getFluidHandler((IBlockAccess)world, (BlockCoord)bc);
        return con != null && !(con instanceof IConduitBundle) ? con : null;
    }

    public IFluidHandler getExternalHandler(ForgeDirection direction) {
        IFluidHandler con = AbstractLiquidConduit.getExternalFluidHandler((IBlockAccess)this.getBundle().getWorld(), this.getLocation().getLocation(direction));
        return con != null && !(con instanceof IConduitBundle) ? con : null;
    }

    public IFluidHandler getTankContainer(BlockCoord bc) {
        return FluidUtil.getFluidHandler((IBlockAccess)this.getBundle().getWorld(), (BlockCoord)bc);
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction, boolean ignoreDisabled) {
        IFluidHandler h = this.getExternalHandler(direction);
        return h != null;
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    @Override
    public boolean onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
        return super.onNeighborBlockChange(blockId);
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, ForgeDirection dir) {
        this.extractionModes.put(dir, mode);
        this.redstoneStateDirty = true;
    }

    @Override
    public RedstoneControlMode getExtractionRedstoneMode(ForgeDirection dir) {
        RedstoneControlMode res = this.extractionModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.ON;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(ForgeDirection dir, DyeColor col) {
        this.extractionColors.put(dir, col);
    }

    @Override
    public DyeColor getExtractionSignalColor(ForgeDirection dir) {
        DyeColor result = this.extractionColors.get(dir);
        if (result == null) {
            return DyeColor.RED;
        }
        return result;
    }

    @Override
    public boolean canOutputToDir(ForgeDirection dir) {
        if (!this.canInputToDir(dir)) {
            return false;
        }
        if (this.conduitConnections.contains(dir)) {
            return true;
        }
        if (!this.externalConnections.contains(dir)) {
            return false;
        }
        IFluidHandler ext = this.getExternalHandler(dir);
        if (ext instanceof TileReservoir) {
            TileReservoir tr = (TileReservoir)ext;
            return !tr.isMultiblock() || !tr.isAutoEject();
        }
        return true;
    }

    protected boolean autoExtractForDir(ForgeDirection dir) {
        if (!this.canExtractFromDir(dir)) {
            return false;
        }
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        if (mode == RedstoneControlMode.IGNORE) {
            return true;
        }
        if (mode == RedstoneControlMode.NEVER) {
            return false;
        }
        if (this.redstoneStateDirty) {
            this.externalRedstoneSignals.clear();
            this.redstoneStateDirty = false;
        }
        DyeColor col = this.getExtractionSignalColor(dir);
        int signal = ConduitUtil.getInternalSignalForColor(this.getBundle(), col);
        boolean res = mode == RedstoneControlMode.OFF ? RedstoneControlMode.isConditionMet(mode, signal) && (col != DyeColor.RED || this.isConditionMetByExternalSignal(dir, mode, col)) : RedstoneControlMode.isConditionMet(mode, signal) || col == DyeColor.RED && this.isConditionMetByExternalSignal(dir, mode, col);
        return res;
    }

    private boolean isConditionMetByExternalSignal(ForgeDirection dir, RedstoneControlMode mode, DyeColor col) {
        int externalSignal = 0;
        if (col == DyeColor.RED) {
            Integer val = this.externalRedstoneSignals.get(dir);
            if (val == null) {
                TileEntity te = this.getBundle().getEntity();
                externalSignal = te.getWorldObj().getStrongestIndirectPower(te.xCoord, te.yCoord, te.zCoord);
                this.externalRedstoneSignals.put(dir, externalSignal);
            } else {
                externalSignal = val;
            }
        }
        return RedstoneControlMode.isConditionMet(mode, externalSignal);
    }

    @Override
    public boolean canExtractFromDir(ForgeDirection dir) {
        return this.getConnectionMode(dir).acceptsInput();
    }

    @Override
    public boolean canInputToDir(ForgeDirection dir) {
        return this.getConnectionMode(dir).acceptsOutput() && !this.autoExtractForDir(dir);
    }

    protected boolean hasExtractableMode() {
        return this.hasConnectionMode(ConnectionMode.INPUT) || this.hasConnectionMode(ConnectionMode.IN_OUT);
    }

    @Override
    protected void readTypeSettings(ForgeDirection dir, NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, DyeColor.values()[dataRoot.getShort("extractionSignalColor")]);
        this.setExtractionRedstoneMode(RedstoneControlMode.values()[dataRoot.getShort("extractionRedstoneMode")], dir);
    }

    @Override
    protected void writeTypeSettingsToNbt(ForgeDirection dir, NBTTagCompound dataRoot) {
        dataRoot.setShort("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.setShort("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        short ord;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<ForgeDirection, RedstoneControlMode> entry : this.extractionModes.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)entry.getValue().ordinal();
            nbtRoot.setShort("extRM." + entry.getKey().name(), ord);
        }
        for (Map.Entry<ForgeDirection, RedstoneControlMode> entry : this.extractionColors.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.setShort("extSC." + entry.getKey().name(), ord);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            short ord;
            String key = "extRM." + dir.name();
            if (nbtRoot.hasKey(key) && (ord = nbtRoot.getShort(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.extractionModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (!nbtRoot.hasKey(key = "extSC." + dir.name()) || (ord = nbtRoot.getShort(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.extractionColors.put(dir, DyeColor.values()[ord]);
        }
    }
}

