/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.IItemFilterUpgrade;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.RecipeSorter;

public class ClearFilterRecipe
implements IRecipe {
    private ItemStack output;

    public boolean matches(InventoryCrafting inv, World world) {
        int count = 0;
        ItemStack input = null;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack checkStack = inv.getStackInSlot(i);
            if (checkStack != null && checkStack.getItem() instanceof IItemFilterUpgrade) {
                ++count;
            }
            input = count == 1 && checkStack != null ? checkStack : input;
        }
        if (count == 1 && FilterRegister.isFilterSet(input)) {
            ItemStack out = input.copy();
            out.stackSize = 1;
            out.stackTagCompound = null;
            this.output = out;
        } else {
            this.output = null;
        }
        return count == 1 && this.output != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.output.copy();
    }

    public int getRecipeSize() {
        return 1;
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (this.output != null && ItemStack.areItemStacksEqual((ItemStack)this.output, (ItemStack)event.itemStack)) {
            event.toolTip.add(EnumChatFormatting.RED.toString() + EnumChatFormatting.ITALIC + EnderIO.lang.localize("itemConduitFilterUpgrade.clearConfigWarning"));
        }
    }

    static {
        RecipeSorter.register((String)"EnderIO:clearFilter", ClearFilterRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }
}

