/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.PacketExistingItemFilterSnapshot;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.ExistingItemFilter;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.network.PacketHandler;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ExistingItemFilterGui
implements IItemFilterGui {
    private static final int ID_NBT = GuiExternalConnection.nextButtonId();
    private static final int ID_META = GuiExternalConnection.nextButtonId();
    private static final int ID_ORE_DICT = GuiExternalConnection.nextButtonId();
    private static final int ID_STICKY = GuiExternalConnection.nextButtonId();
    private static final int ID_SNAPSHOT = GuiExternalConnection.nextButtonId();
    private static final int ID_CLEAR = GuiExternalConnection.nextButtonId();
    private static final int ID_SHOW = GuiExternalConnection.nextButtonId();
    private static final int ID_MERGE = GuiExternalConnection.nextButtonId();
    private IItemConduit itemConduit;
    private GuiExternalConnection gui;
    private ToggleButton useMetaB;
    private ToggleButton useNbtB;
    private ToggleButton useOreDictB;
    private ToggleButton stickyB;
    private GuiButton snapshotB;
    private GuiButton clearB;
    private GuiButton showB;
    private GuiButton mergeB;
    private SnapshotOverlay snapshotOverlay;
    boolean isInput;
    private ExistingItemFilter filter;

    public ExistingItemFilterGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        int butLeft;
        this.gui = gui;
        this.itemConduit = itemConduit;
        this.isInput = isInput;
        this.filter = isInput ? (ExistingItemFilter)itemConduit.getInputFilter(gui.getDir()) : (ExistingItemFilter)itemConduit.getOutputFilter(gui.getDir());
        int x = butLeft = 37;
        int y = 68;
        this.useMetaB = new ToggleButton((IGuiScreen)gui, ID_META, x, y, (IWidgetIcon)IconEIO.FILTER_META_OFF, (IWidgetIcon)IconEIO.FILTER_META);
        this.useMetaB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.matchMetaData")});
        this.useMetaB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.ignoreMetaData")});
        this.useMetaB.setPaintSelectedBorder(false);
        this.stickyB = new ToggleButton((IGuiScreen)gui, ID_STICKY, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        String[] lines = EnderIO.lang.localizeList("gui.conduit.item.stickyEnabled");
        this.stickyB.setSelectedToolTip(lines);
        this.stickyB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.stickyDisbaled")});
        this.stickyB.setPaintSelectedBorder(false);
        x = butLeft;
        this.useNbtB = new ToggleButton((IGuiScreen)gui, ID_NBT, x += 20, y += 20, (IWidgetIcon)IconEIO.FILTER_NBT_OFF, (IWidgetIcon)IconEIO.FILTER_NBT);
        this.useNbtB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.matchNBT")});
        this.useNbtB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.ignoreNBT")});
        this.useNbtB.setPaintSelectedBorder(false);
        x = butLeft;
        this.useOreDictB = new ToggleButton((IGuiScreen)gui, ID_ORE_DICT, x, y, (IWidgetIcon)IconEIO.FILTER_ORE_DICT_OFF, (IWidgetIcon)IconEIO.FILTER_ORE_DICT);
        this.useOreDictB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.oreDicEnabled")});
        this.useOreDictB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.oreDicDisabled")});
        this.useOreDictB.setPaintSelectedBorder(false);
        this.snapshotB = new GuiButton(ID_SNAPSHOT, 0, 0, 60, 20, EnderIO.lang.localize("gui.conduit.button.snap"));
        this.mergeB = new GuiButton(ID_MERGE, 0, 0, 40, 20, EnderIO.lang.localize("gui.conduit.button.merge"));
        this.clearB = new GuiButton(ID_CLEAR, 0, 0, 60, 20, EnderIO.lang.localize("gui.conduit.button.clear"));
        this.showB = new GuiButton(ID_SHOW, 0, 0, 40, 20, EnderIO.lang.localize("gui.conduit.button.show"));
        this.snapshotOverlay = new SnapshotOverlay();
        gui.addOverlay(this.snapshotOverlay);
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void updateButtons() {
        ExistingItemFilter activeFilter = this.filter;
        this.useNbtB.onGuiInit();
        this.useNbtB.setSelected(activeFilter.isMatchNBT());
        this.useOreDictB.onGuiInit();
        this.useOreDictB.setSelected(activeFilter.isUseOreDict());
        if (!this.isInput) {
            this.stickyB.onGuiInit();
            this.stickyB.setSelected(activeFilter.isSticky());
        }
        this.useMetaB.onGuiInit();
        this.useMetaB.setSelected(activeFilter.isMatchMeta());
        int x0 = this.gui.getGuiLeft() + 80;
        int y0 = this.gui.getGuiTop() + 65;
        int x1 = x0 + 65;
        int y1 = y0 + 22;
        this.snapshotB.xPosition = x0;
        this.snapshotB.yPosition = y0;
        this.mergeB.xPosition = x1;
        this.mergeB.yPosition = y0;
        this.clearB.xPosition = x0;
        this.clearB.yPosition = y1;
        this.showB.xPosition = x1;
        this.showB.yPosition = y1;
        this.showB.enabled = this.clearB.enabled = this.filter.getSnapshot() != null;
        this.mergeB.enabled = this.filter.getSnapshot() != null;
        this.gui.addButton(this.snapshotB);
        this.gui.addButton(this.clearB);
        this.gui.addButton(this.showB);
        this.gui.addButton(this.mergeB);
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton.id == ID_META) {
            this.filter.setMatchMeta(this.useMetaB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.id == ID_NBT) {
            this.filter.setMatchNBT(this.useNbtB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.id == ID_STICKY) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.id == ID_ORE_DICT) {
            this.filter.setUseOreDict(this.useOreDictB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.id == ID_SNAPSHOT) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.SET);
        } else if (guiButton.id == ID_CLEAR) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.CLEAR);
        } else if (guiButton.id == ID_MERGE) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.MERGE);
        } else if (guiButton.id == ID_SHOW) {
            this.showSnapshotOverlay();
        }
    }

    private void showSnapshotOverlay() {
        this.snapshotOverlay.setVisible(true);
    }

    private void sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode opcode) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExistingItemFilterSnapshot(this.itemConduit, this.gui.getDir(), this.isInput, opcode));
    }

    private void sendFilterChange() {
        this.updateButtons();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
    }

    @Override
    public void deactivate() {
        this.useNbtB.detach();
        this.useMetaB.detach();
        this.useOreDictB.detach();
        this.stickyB.detach();
        this.gui.removeButton(this.snapshotB);
        this.gui.removeButton(this.clearB);
        this.gui.removeButton(this.showB);
        this.gui.removeButton(this.mergeB);
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
    }

    class SnapshotOverlay
    implements IGuiOverlay {
        boolean visible;

        SnapshotOverlay() {
        }

        public void init(IGuiScreen screen) {
        }

        public Rectangle getBounds() {
            return new Rectangle(0, 0, ((ExistingItemFilterGui)ExistingItemFilterGui.this).gui.width, ((ExistingItemFilterGui)ExistingItemFilterGui.this).gui.height);
        }

        public void draw(int mouseX, int mouseY, float partialTick) {
            RenderHelper.enableGUIStandardItemLighting();
            GL11.glEnable((int)3042);
            RenderUtil.renderQuad2D((double)4.0, (double)4.0, (double)0.0, (double)(ExistingItemFilterGui.this.gui.getXSize() - 9), (double)(ExistingItemFilterGui.this.gui.getYSize() - 8), (Vector4f)new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            RenderUtil.renderQuad2D((double)6.0, (double)6.0, (double)0.0, (double)(ExistingItemFilterGui.this.gui.getXSize() - 13), (double)(ExistingItemFilterGui.this.gui.getYSize() - 12), (Vector4f)new Vector4f(0.6, 0.6, 0.6, 1.0));
            Minecraft mc = Minecraft.getMinecraft();
            RenderItem itemRenderer = new RenderItem();
            GL11.glEnable((int)2929);
            List<ItemStack> snapshot = ExistingItemFilterGui.this.filter.getSnapshot();
            int x = 15;
            int y = 10;
            int count = 0;
            for (ItemStack st : snapshot) {
                if (st != null) {
                    itemRenderer.renderItemAndEffectIntoGUI(mc.fontRenderer, mc.getTextureManager(), st, x, y);
                }
                x += 20;
                if (++count % 9 != 0) continue;
                x = 15;
                y += 20;
            }
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean handleMouseInput(int x, int y, int b) {
            return true;
        }

        public boolean isMouseInBounds(int mouseX, int mouseY) {
            return this.getBounds().contains(mouseX, mouseY);
        }
    }
}

