/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gui.PacketOpenConduitUI;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiExternalConnectionSelector
extends GuiScreen {
    Set<ForgeDirection> cons;
    IConduitBundle cb;

    public GuiExternalConnectionSelector(IConduitBundle cb) {
        this.cb = cb;
        this.cons = new HashSet<ForgeDirection>();
        for (IConduit con : cb.getConduits()) {
            if (con instanceof IInsulatedRedstoneConduit) {
                Set<ForgeDirection> conCons = con.getConduitConnections();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (conCons.contains(dir)) continue;
                    this.cons.add(dir);
                }
                continue;
            }
            this.cons.addAll(con.getExternalConnections());
        }
    }

    protected void actionPerformed(GuiButton b) {
        ForgeDirection dir = ForgeDirection.values()[b.id];
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        BlockCoord loc = this.cb.getLocation();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenConduitUI(this.cb.getEntity(), dir));
        player.openGui((Object)EnderIO.instance, 9 + dir.ordinal(), player.worldObj, loc.x, loc.y, loc.z);
    }

    public void initGui() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Point p = this.getOffsetForDir(dir);
            GuiButton b = new GuiButton(dir.ordinal(), p.x, p.y, 60, 20, dir.toString());
            this.buttonList.add(b);
            if (this.cons.contains(dir)) continue;
            b.enabled = false;
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        super.drawScreen(par1, par2, par3);
        int butHeight = 20;
        String txt = "Select Connection to Adjust";
        int x = this.width / 2 - Minecraft.getMinecraft().fontRenderer.getStringWidth(txt) / 2;
        int y = this.height / 2 - butHeight * 3 - 5;
        Tessellator.instance.startDrawingQuads();
        this.drawString(Minecraft.getMinecraft().fontRenderer, txt, x, y, ColorUtil.getARGB((Color)Color.white));
        Tessellator.instance.draw();
    }

    private Point getOffsetForDir(ForgeDirection dir) {
        int mx = this.width / 2;
        int my = this.height / 2;
        int butWidth = 60;
        int butHeight = 20;
        int x = mx - butWidth / 2 + dir.offsetX * butWidth;
        int y = my - butHeight / 2 + dir.offsetZ * butHeight * 2;
        return new Point(x += Math.abs(dir.offsetY) * (5 + butWidth * 2), y -= dir.offsetY * butHeight * 2);
    }
}

