/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gui.FilterChangeListener;
import crazypants.enderio.conduit.gui.PacketSlotVisibility;
import crazypants.enderio.conduit.gui.item.InventoryUpgrades;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.SpeedUpgrade;
import crazypants.enderio.network.PacketHandler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ExternalConnectionContainer
extends ContainerEnder<InventoryUpgrades> {
    private final IItemConduit itemConduit;
    private int speedUpgradeSlotLimit = 15;
    private static final int outputFilterUpgradeSlot = 36;
    private static final int inputFilterUpgradeSlot = 37;
    private static final int speedUpgradeSlot = 38;
    private static final int functionUpgradeSlot = 39;
    private Slot slotSpeedUpgrades;
    private Slot slotFunctionUpgrades;
    private Slot slotInputFilterUpgrades;
    private Slot slotOutputFilterUpgrades;
    private final List<Point> slotLocations = new ArrayList<Point>();
    final List<FilterChangeListener> filterListeners = new ArrayList<FilterChangeListener>();

    public ExternalConnectionContainer(InventoryPlayer playerInv, IConduitBundle bundle, ForgeDirection dir) {
        super(playerInv, (IInventory)new InventoryUpgrades(bundle.getConduit(IItemConduit.class), dir));
        this.itemConduit = bundle.getConduit(IItemConduit.class);
        this.slotLocations.addAll(this.playerSlotLocations.values());
        if (this.itemConduit != null) {
            int x = 10;
            int y = 47;
            this.slotOutputFilterUpgrades = this.addSlotToContainer(new FilterSlot(this.getInv(), 3, x, y));
            this.slotLocations.add(new Point(x, y));
            x = 10;
            y = 47;
            this.slotInputFilterUpgrades = this.addSlotToContainer(new FilterSlot(this.getInv(), 2, x, y));
            this.slotLocations.add(new Point(x, y));
            x = 28;
            y = 47;
            this.slotSpeedUpgrades = this.addSlotToContainer(new Slot(this.getInv(), 0, x, y){

                public boolean isItemValid(ItemStack par1ItemStack) {
                    return ((InventoryUpgrades)ExternalConnectionContainer.this.getInv()).isItemValidForSlot(0, par1ItemStack);
                }

                public int getSlotStackLimit() {
                    return ExternalConnectionContainer.this.speedUpgradeSlotLimit;
                }
            });
            this.slotLocations.add(new Point(x, y));
            x = 10;
            y = 65;
            this.slotFunctionUpgrades = this.addSlotToContainer(new Slot(this.getInv(), 1, x, y){

                public boolean isItemValid(ItemStack par1ItemStack) {
                    return ((InventoryUpgrades)ExternalConnectionContainer.this.getInv()).isItemValidForSlot(1, par1ItemStack);
                }

                public int getSlotStackLimit() {
                    return 1;
                }
            });
            this.slotLocations.add(new Point(x, y));
        }
    }

    public Point getPlayerInventoryOffset() {
        return new Point(23, 113);
    }

    public void addFilterListener(FilterChangeListener list) {
        this.filterListeners.add(list);
    }

    protected void filterChanged() {
        for (FilterChangeListener list : this.filterListeners) {
            list.onFilterChanged();
        }
    }

    public boolean hasSpeedUpgrades() {
        return this.slotSpeedUpgrades != null && this.slotSpeedUpgrades.getHasStack();
    }

    public boolean hasFunctionUpgrades() {
        return this.slotFunctionUpgrades != null && this.slotFunctionUpgrades.getHasStack();
    }

    public boolean hasFilterUpgrades(boolean input) {
        Slot slot = input ? this.slotInputFilterUpgrades : this.slotOutputFilterUpgrades;
        return slot != null && slot.getHasStack();
    }

    public void setInoutSlotsVisible(boolean inputVisible, boolean outputVisible) {
        if (this.itemConduit == null) {
            return;
        }
        this.setSlotsVisible(inputVisible, 37, 38);
        this.setSlotsVisible(inputVisible, 38, 39);
        this.setSlotsVisible(outputVisible, 36, 37);
        this.setSlotsVisible(inputVisible || outputVisible, 39, 40);
        World world = this.itemConduit.getBundle().getWorld();
        if (world.isRemote) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSlotVisibility(inputVisible, outputVisible));
        }
    }

    public void setInventorySlotsVisible(boolean visible) {
        this.setSlotsVisible(visible, 0, 36);
    }

    private void setSlotsVisible(boolean visible, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            Slot s = (Slot)this.inventorySlots.get(i);
            if (visible) {
                s.xDisplayPosition = this.slotLocations.get((int)i).x;
                s.yDisplayPosition = this.slotLocations.get((int)i).y;
                continue;
            }
            s.xDisplayPosition = -3000;
            s.yDisplayPosition = -3000;
        }
    }

    public ItemStack slotClick(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        ItemStack st = par4EntityPlayer.inventory.getItemStack();
        this.setSpeedUpgradeSlotLimit(st);
        try {
            return super.slotClick(par1, par2, par3, par4EntityPlayer);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setSpeedUpgradeSlotLimit(ItemStack st) {
        if (st != null && st.getItem() == EnderIO.itemExtractSpeedUpgrade) {
            SpeedUpgrade speedUpgrade = EnderIO.itemExtractSpeedUpgrade.getSpeedUpgrade(st);
            this.speedUpgradeSlotLimit = speedUpgrade.maxStackSize;
        }
    }

    private boolean mergeItemStackSpecial(ItemStack origStack, Slot targetSlot) {
        if (!targetSlot.isItemValid(origStack)) {
            return false;
        }
        this.setSpeedUpgradeSlotLimit(origStack);
        ItemStack curStack = targetSlot.getStack();
        int maxStackSize = Math.min(origStack.getMaxStackSize(), targetSlot.getSlotStackLimit());
        if (curStack == null) {
            curStack = origStack.copy();
            curStack.stackSize = Math.min(origStack.stackSize, maxStackSize);
            origStack.stackSize -= curStack.stackSize;
            targetSlot.putStack(curStack);
            targetSlot.onSlotChanged();
            return true;
        }
        if (ItemUtil.areStackMergable((ItemStack)curStack, (ItemStack)origStack)) {
            int mergedSize = curStack.stackSize + origStack.stackSize;
            if (mergedSize <= maxStackSize) {
                origStack.stackSize = 0;
                curStack.stackSize = mergedSize;
                targetSlot.onSlotChanged();
                return true;
            }
            if (curStack.stackSize < maxStackSize) {
                origStack.stackSize -= maxStackSize - curStack.stackSize;
                curStack.stackSize = maxStackSize;
                targetSlot.onSlotChanged();
                return true;
            }
        }
        return false;
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack copystack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack origStack = slot.getStack();
            copystack = origStack.copy();
            boolean merged = false;
            if (slotIndex < 36) {
                for (int targetSlotIdx = 36; targetSlotIdx <= 39; ++targetSlotIdx) {
                    Slot targetSlot = (Slot)this.inventorySlots.get(targetSlotIdx);
                    if (targetSlot.xDisplayPosition < 0 || !this.mergeItemStackSpecial(origStack, targetSlot)) continue;
                    merged = true;
                    break;
                }
            } else {
                merged = this.mergeItemStack(origStack, 0, 36, false);
            }
            if (!merged) {
                return null;
            }
            slot.onSlotChange(origStack, copystack);
            if (origStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
            if (origStack.stackSize == copystack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(entityPlayer, origStack);
        }
        return copystack;
    }

    private class FilterSlot
    extends Slot {
        public FilterSlot(IInventory par1iInventory, int par2, int par3, int par4) {
            super(par1iInventory, par2, par3, par4);
        }

        public int getSlotStackLimit() {
            return 1;
        }

        public void onSlotChanged() {
            ExternalConnectionContainer.this.filterChanged();
        }

        public boolean isItemValid(ItemStack par1ItemStack) {
            return this.inventory.isItemValidForSlot(this.getSlotIndex(), par1ItemStack);
        }
    }
}

