/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gas;

import cpw.mods.fml.common.Optional;
import crazypants.enderio.conduit.gas.GasUtil;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import net.minecraft.nbt.NBTTagCompound;

public class ConduitGasTank
extends GasTank {
    private int capacity;

    ConduitGasTank(int capacity) {
        super(capacity);
        this.capacity = capacity;
    }

    public float getFilledRatio() {
        if (this.getStored() <= 0) {
            return 0.0f;
        }
        if (this.getMaxGas() <= 0) {
            return -1.0f;
        }
        float res = (float)this.getStored() / (float)this.getMaxGas();
        return res;
    }

    public boolean isFull() {
        return this.getStored() >= this.getMaxGas();
    }

    public void setAmount(int amount) {
        if (this.stored != null) {
            this.stored.amount = amount;
        }
    }

    public int getAvailableSpace() {
        return this.getMaxGas() - this.getStored();
    }

    public void addAmount(int amount) {
        this.setAmount(this.getStored() + amount);
    }

    public int getMaxGas() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.getStored() > capacity) {
            this.setAmount(capacity);
        }
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public int receive(GasStack resource, boolean doReceive) {
        if (resource == null || resource.getGas().getID() < 0) {
            return 0;
        }
        if (this.stored == null || this.stored.getGas().getID() < 0) {
            if (resource.amount <= this.capacity) {
                if (doReceive) {
                    this.setGas(resource.copy());
                }
                return resource.amount;
            }
            if (doReceive) {
                this.stored = resource.copy();
                this.stored.amount = this.capacity;
            }
            return this.capacity;
        }
        if (!this.stored.isGasEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.stored.amount;
        if (resource.amount <= space) {
            if (doReceive) {
                this.addAmount(resource.amount);
            }
            return resource.amount;
        }
        if (doReceive) {
            this.stored.amount = this.capacity;
        }
        return space;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public GasStack draw(int maxDrain, boolean doDraw) {
        if (this.stored == null || this.stored.getGas().getID() < 0) {
            return null;
        }
        if (this.stored.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.stored.amount < used) {
            used = this.stored.amount;
        }
        if (doDraw) {
            this.addAmount(-used);
        }
        GasStack drained = new GasStack(this.stored.getGas().getID(), used);
        if (this.stored.amount < 0) {
            this.stored.amount = 0;
        }
        return drained;
    }

    public String getGasName() {
        return this.stored != null ? this.stored.getGas().getLocalizedName() : null;
    }

    public boolean containsValidGas() {
        return GasUtil.isGasValid(this.stored);
    }

    public NBTTagCompound write(NBTTagCompound nbt) {
        if (this.containsValidGas()) {
            this.stored.write(nbt);
        } else {
            nbt.setBoolean("emptyGasTank", true);
        }
        return nbt;
    }

    public void read(NBTTagCompound nbt) {
        GasStack gas;
        if (!nbt.hasKey("emptyGasTank") && (gas = GasStack.readFromNBT((NBTTagCompound)nbt)) != null) {
            this.setGas(gas);
        }
    }

    public boolean isEmpty() {
        return this.stored == null || this.stored.amount == 0;
    }
}

