/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.facade;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.machine.painter.IPaintedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConduitFacade
extends BlockEio
implements IPaintedBlock {
    private Block blockOverride;

    public static BlockConduitFacade create() {
        BlockConduitFacade result = new BlockConduitFacade();
        result.init();
        return result;
    }

    private BlockConduitFacade() {
        super(ModObject.blockConduitFacade.unlocalisedName, null, new Material(MapColor.stoneColor));
        this.setStepSound(Block.soundTypeStone);
        this.setCreativeTab(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.blockIcon = IIconRegister2.registerIcon("enderio:conduitFacade");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess ba, int x, int y, int z, int side) {
        TileEntity te = ba.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return this.blockIcon;
        }
        IConduitBundle cb = (IConduitBundle)te;
        Block block = cb.getFacadeId();
        if (block != null) {
            int meta = cb.getFacadeMetadata();
            return block.getIcon(side, meta);
        }
        return this.blockIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        if (this.blockOverride != null) {
            return this.blockOverride.getIcon(par1, par2);
        }
        return this.blockIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        if (this.blockOverride != null) {
            return this.blockOverride.getBlockColor();
        }
        return super.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (this.blockOverride != null) {
            try {
                return this.blockOverride.colorMultiplier(par1IBlockAccess, par2, par3, par4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.colorMultiplier(par1IBlockAccess, par2, par3, par4);
    }

    public Block getIconOverrideBlock() {
        return this.blockOverride;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int par1) {
        if (this.blockOverride != null) {
            return this.blockOverride.getRenderColor(par1);
        }
        return super.getRenderColor(par1);
    }

    public void setBlockOverride(IConduitBundle cb) {
        if (cb == null) {
            this.blockOverride = null;
            return;
        }
        Block block = cb.getFacadeId();
        int meta = cb.getFacadeMetadata();
        if (block == null || block == this) {
            return;
        }
        this.blockOverride = block;
    }

    public int getDamageValue(World par1World, int x, int y, int z) {
        Mimic m = this.getMimic((IBlockAccess)par1World, x, y, z);
        if (m != null) {
            return m.meta;
        }
        return 0;
    }

    private Mimic getMimic(IBlockAccess ba, int x, int y, int z) {
        TileEntity te = ba.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle cb = (IConduitBundle)te;
        Block id = cb.getFacadeId();
        int meta = cb.getFacadeMetadata();
        if (id == null) {
            return null;
        }
        return new Mimic(id, meta);
    }

    class Mimic {
        int meta;
        Block block;

        private Mimic(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }
    }
}

