/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import com.enderio.core.client.render.BoundingBox;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.MicroblocksUtil;
import crazypants.enderio.conduit.facade.ItemConduitFacade;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.geom.Offsets;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.me.IMEConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mods.immibis.microblocks.api.EnumPartClass;
import mods.immibis.microblocks.api.EnumPosition;
import mods.immibis.microblocks.api.IMicroblockCoverSystem;
import mods.immibis.microblocks.api.IMicroblockSupporterTile;
import mods.immibis.microblocks.api.IMicroblockSystem;
import mods.immibis.microblocks.api.MicroblockAPIUtils;
import mods.immibis.microblocks.api.Part;
import mods.immibis.microblocks.api.PartType;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileConduitBundle
extends TileEntityEio
implements IConduitBundle {
    public static final short NBT_VERSION = 1;
    private final List<IConduit> conduits = new ArrayList<IConduit>();
    private Block facadeId = null;
    private int facadeMeta = 0;
    private ItemConduitFacade.FacadeType facadeType = ItemConduitFacade.FacadeType.BASIC;
    private boolean facadeChanged;
    private final List<CollidableComponent> cachedCollidables = new ArrayList<CollidableComponent>();
    private final List<CollidableComponent> cachedConnectors = new ArrayList<CollidableComponent>();
    private boolean conduitsDirty = true;
    private boolean collidablesDirty = true;
    private boolean connectorsDirty = true;
    private boolean clientUpdated = false;
    private int lightOpacity = -1;
    @SideOnly(value=Side.CLIENT)
    private IConduitBundle.FacadeRenderState facadeRenderAs;
    private ConduitDisplayMode lastMode = ConduitDisplayMode.ALL;
    Object covers;
    private Object node;

    public TileConduitBundle() {
        this.blockType = EnderIO.blockConduitBundle;
        this.initMicroblocks();
    }

    @Override
    public void dirty() {
        this.conduitsDirty = true;
        this.collidablesDirty = true;
    }

    public boolean shouldRenderInPass(int arg0) {
        if (this.facadeId != null && this.facadeId.isOpaqueCube() && !ConduitUtil.isFacadeHidden(this, EnderIO.proxy.getClientPlayer())) {
            return false;
        }
        return super.shouldRenderInPass(arg0);
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        NBTTagList conduitTags = new NBTTagList();
        for (IConduit conduit : this.conduits) {
            NBTTagCompound conduitRoot = new NBTTagCompound();
            ConduitUtil.writeToNBT(conduit, conduitRoot);
            conduitTags.appendTag((NBTBase)conduitRoot);
        }
        nbtRoot.setTag("conduits", (NBTBase)conduitTags);
        if (this.facadeId != null) {
            nbtRoot.setString("facadeId", Block.blockRegistry.getNameForObject((Object)this.facadeId));
            nbtRoot.setString("facadeType", this.facadeType.name());
        } else {
            nbtRoot.setString("facadeId", "null");
        }
        nbtRoot.setInteger("facadeMeta", this.facadeMeta);
        nbtRoot.setShort("nbtVersion", (short)1);
        if (MicroblocksUtil.supportMicroblocks()) {
            this.writeMicroblocksToNBT(nbtRoot);
        }
    }

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        String fs;
        short nbtVersion = nbtRoot.getShort("nbtVersion");
        this.conduits.clear();
        this.cachedCollidables.clear();
        NBTTagList conduitTags = (NBTTagList)nbtRoot.getTag("conduits");
        if (conduitTags != null) {
            for (int i = 0; i < conduitTags.tagCount(); ++i) {
                NBTTagCompound conduitTag = conduitTags.getCompoundTagAt(i);
                IConduit conduit = ConduitUtil.readConduitFromNBT(conduitTag, nbtVersion);
                if (conduit == null) continue;
                conduit.setBundle(this);
                this.conduits.add(conduit);
            }
        }
        if ((fs = nbtRoot.getString("facadeId")) == null || "null".equals(fs)) {
            this.facadeId = null;
            this.facadeType = ItemConduitFacade.FacadeType.BASIC;
        } else {
            this.facadeId = Block.getBlockFromName((String)fs);
            if (nbtRoot.hasKey("facadeType")) {
                this.facadeType = ItemConduitFacade.FacadeType.valueOf(nbtRoot.getString("facadeType"));
            }
        }
        this.facadeMeta = nbtRoot.getInteger("facadeMeta");
        if (this.worldObj != null && this.worldObj.isRemote) {
            this.clientUpdated = true;
        }
        if (MicroblocksUtil.supportMicroblocks()) {
            this.readMicroblocksFromNBT(nbtRoot);
        }
    }

    @Override
    public boolean hasFacade() {
        return this.facadeId != null;
    }

    @Override
    public void setFacadeId(Block blockID, boolean triggerUpdate) {
        this.facadeId = blockID;
        if (triggerUpdate) {
            this.facadeChanged = true;
        }
    }

    @Override
    public void setFacadeId(Block blockID) {
        this.setFacadeId(blockID, true);
    }

    @Override
    public Block getFacadeId() {
        return this.facadeId;
    }

    @Override
    public void setFacadeMetadata(int meta) {
        this.facadeMeta = meta;
    }

    @Override
    public void setFacadeType(ItemConduitFacade.FacadeType type) {
        this.facadeType = type;
    }

    @Override
    public int getFacadeMetadata() {
        return this.facadeMeta;
    }

    @Override
    public ItemConduitFacade.FacadeType getFacadeType() {
        return this.facadeType;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IConduitBundle.FacadeRenderState getFacadeRenderedAs() {
        if (this.facadeRenderAs == null) {
            this.facadeRenderAs = IConduitBundle.FacadeRenderState.NONE;
        }
        return this.facadeRenderAs;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setFacadeRenderAs(IConduitBundle.FacadeRenderState state) {
        this.facadeRenderAs = state;
    }

    @Override
    public int getLightOpacity() {
        if (this.worldObj != null && !this.worldObj.isRemote || this.lightOpacity == -1) {
            return this.hasFacade() ? this.facadeId.getLightOpacity() : 0;
        }
        return this.lightOpacity;
    }

    @Override
    public void setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
    }

    public void onChunkUnload() {
        for (IConduit conduit : this.conduits) {
            conduit.onChunkUnload(this.worldObj);
        }
    }

    public void doUpdate() {
        for (IConduit conduit : this.conduits) {
            conduit.updateEntity(this.worldObj);
        }
        if (this.conduitsDirty) {
            this.doConduitsDirty();
        }
        if (this.facadeChanged) {
            this.doFacadeChanged();
        }
        if (this.worldObj.isRemote) {
            this.updateEntityClient();
        }
    }

    private void doConduitsDirty() {
        if (!this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
        this.conduitsDirty = false;
    }

    private void doFacadeChanged() {
        ConduitUtil.forceSkylightRecalculation(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.func_147451_t(this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, (Block)EnderIO.blockConduitBundle);
        this.facadeChanged = false;
    }

    private void updateEntityClient() {
        boolean markForUpdate = false;
        if (this.clientUpdated) {
            markForUpdate = true;
            this.clientUpdated = false;
        }
        IConduitBundle.FacadeRenderState curRS = this.getFacadeRenderedAs();
        IConduitBundle.FacadeRenderState rs = ConduitUtil.getRequiredFacadeRenderState(this, EnderIO.proxy.getClientPlayer());
        if (Config.updateLightingWhenHidingFacades) {
            int shouldBeLO;
            int curLO = this.getLightOpacity();
            int n = shouldBeLO = rs == IConduitBundle.FacadeRenderState.FULL ? 255 : 0;
            if (curLO != shouldBeLO) {
                this.setLightOpacity(shouldBeLO);
                this.worldObj.func_147451_t(this.xCoord, this.yCoord, this.zCoord);
            }
        }
        if (curRS != rs) {
            this.setFacadeRenderAs(rs);
            if (!ConduitUtil.forceSkylightRecalculation(this.worldObj, this.xCoord, this.yCoord, this.zCoord)) {
                markForUpdate = true;
            }
        } else {
            ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(EnderIO.proxy.getClientPlayer().getCurrentEquippedItem());
            if (curMode != this.lastMode) {
                markForUpdate = true;
                this.lastMode = curMode;
            }
        }
        if (markForUpdate) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        boolean needsUpdate = false;
        for (IConduit conduit : this.conduits) {
            needsUpdate |= conduit.onNeighborBlockChange(blockId);
        }
        if (needsUpdate) {
            this.dirty();
        }
    }

    @Override
    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        boolean needsUpdate = false;
        for (IConduit conduit : this.conduits) {
            needsUpdate |= conduit.onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        }
        if (needsUpdate) {
            this.dirty();
        }
    }

    public TileConduitBundle getEntity() {
        return this;
    }

    @Override
    public boolean hasType(Class<? extends IConduit> type) {
        return this.getConduit(type) != null;
    }

    @Override
    public <T extends IConduit> T getConduit(Class<T> type) {
        if (type == null) {
            return null;
        }
        for (IConduit conduit : this.conduits) {
            if (!type.isInstance(conduit)) continue;
            return (T)conduit;
        }
        return null;
    }

    @Override
    public void addConduit(IConduit conduit) {
        if (this.worldObj.isRemote) {
            return;
        }
        this.conduits.add(conduit);
        conduit.setBundle(this);
        conduit.onAddedToBundle();
        this.dirty();
    }

    @Override
    public void removeConduit(IConduit conduit) {
        if (conduit != null) {
            this.removeConduit(conduit, true);
        }
    }

    public void removeConduit(IConduit conduit, boolean notify) {
        if (this.worldObj.isRemote) {
            return;
        }
        conduit.onRemovedFromBundle();
        this.conduits.remove(conduit);
        conduit.setBundle(null);
        if (notify) {
            this.dirty();
        }
    }

    @Override
    public void onBlockRemoved() {
        if (this.worldObj.isRemote) {
            return;
        }
        ArrayList<IConduit> copy = new ArrayList<IConduit>(this.conduits);
        for (IConduit con : copy) {
            this.removeConduit(con, false);
        }
        this.dirty();
    }

    @Override
    public Collection<IConduit> getConduits() {
        return this.conduits;
    }

    @Override
    public Set<ForgeDirection> getConnections(Class<? extends IConduit> type) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.getConduitConnections();
        }
        return null;
    }

    @Override
    public boolean containsConnection(Class<? extends IConduit> type, ForgeDirection dir) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.containsConduitConnection(dir);
        }
        return false;
    }

    @Override
    public boolean containsConnection(ForgeDirection dir) {
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ForgeDirection> getAllConnections() {
        EnumSet<ForgeDirection> result = EnumSet.noneOf(ForgeDirection.class);
        for (IConduit con : this.conduits) {
            result.addAll(con.getConduitConnections());
        }
        return result;
    }

    @Override
    public Offset getOffset(Class<? extends IConduit> type, ForgeDirection dir) {
        if (this.getConnectionCount(dir) < 2) {
            return Offset.NONE;
        }
        return Offsets.get(type, dir);
    }

    @Override
    public List<CollidableComponent> getCollidableComponents() {
        for (IConduit con : this.conduits) {
            this.collidablesDirty = this.collidablesDirty || con.haveCollidablesChangedSinceLastCall();
        }
        if (this.collidablesDirty) {
            this.connectorsDirty = true;
        }
        if (!this.collidablesDirty && !this.cachedCollidables.isEmpty()) {
            return this.cachedCollidables;
        }
        this.cachedCollidables.clear();
        for (IConduit conduit : this.conduits) {
            this.cachedCollidables.addAll(conduit.getCollidableComponents());
        }
        this.addConnectors(this.cachedCollidables);
        this.collidablesDirty = false;
        return this.cachedCollidables;
    }

    @Override
    public List<CollidableComponent> getConnectors() {
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        this.addConnectors(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void addConnectors(List<CollidableComponent> result) {
        void var5_15;
        void var6_29;
        Object cc;
        if (this.conduits.isEmpty()) {
            return;
        }
        for (IConduit iConduit : this.conduits) {
            boolean b = iConduit.haveCollidablesChangedSinceLastCall();
            this.collidablesDirty = this.collidablesDirty || b;
            this.connectorsDirty = this.connectorsDirty || b;
        }
        if (!this.connectorsDirty && !this.cachedConnectors.isEmpty()) {
            result.addAll(this.cachedConnectors);
            return;
        }
        this.cachedConnectors.clear();
        ArrayList<CollidableComponent> coreBounds = new ArrayList<CollidableComponent>();
        for (IConduit con : this.conduits) {
            this.addConduitCores(coreBounds, con);
        }
        this.cachedConnectors.addAll(coreBounds);
        result.addAll(coreBounds);
        ArrayList<CollidableComponent> arrayList = new ArrayList<CollidableComponent>();
        for (IConduit iConduit : this.conduits) {
            arrayList.addAll(iConduit.getCollidableComponents());
            this.addConduitCores(arrayList, iConduit);
        }
        HashSet<Class<? extends IConduit>> collidingTypes = new HashSet<Class<? extends IConduit>>();
        for (CollidableComponent collidableComponent : arrayList) {
            for (CollidableComponent collidableComponent2 : arrayList) {
                if ("ColorController".equals(collidableComponent2.data) || "ColorController".equals(collidableComponent.data) || collidableComponent == collidableComponent2 || !collidableComponent.bound.intersects(collidableComponent2.bound)) continue;
                collidingTypes.add(collidableComponent.conduitType);
            }
        }
        if (!collidingTypes.isEmpty()) {
            void var6_20;
            ArrayList<CollidableComponent> arrayList2 = new ArrayList<CollidableComponent>();
            for (Class clazz : collidingTypes) {
                Object t = this.getConduit(clazz);
                if (t == null) continue;
                this.addConduitCores((List<CollidableComponent>)arrayList2, (IConduit)t);
            }
            Object var6_19 = null;
            for (CollidableComponent collidableComponent : arrayList2) {
                if (var6_20 == null) {
                    BoundingBox boundingBox = collidableComponent.bound;
                    continue;
                }
                BoundingBox boundingBox = var6_20.expandBy(collidableComponent.bound);
            }
            if (var6_20 != null) {
                BoundingBox boundingBox = var6_20.scale(1.05, 1.05, 1.05);
                CollidableComponent collidableComponent = new CollidableComponent(null, boundingBox, ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.INTERNAL);
                result.add(collidableComponent);
                this.cachedConnectors.add(collidableComponent);
            }
        }
        for (IConduit iConduit : this.conduits) {
            void var8_51;
            if (!iConduit.hasConnections()) continue;
            ArrayList<CollidableComponent> arrayList3 = new ArrayList<CollidableComponent>();
            this.addConduitCores(arrayList3, iConduit);
            if (arrayList3.size() <= 1) continue;
            BoundingBox boundingBox = ((CollidableComponent)arrayList3.get((int)0)).bound;
            float area = boundingBox.getArea();
            for (CollidableComponent cc3 : arrayList3) {
                BoundingBox boundingBox2 = var8_51.expandBy(cc3.bound);
            }
            if (!(var8_51.getArea() > area * 1.5f)) continue;
            BoundingBox boundingBox3 = var8_51.scale(1.05, 1.05, 1.05);
            cc = new CollidableComponent(null, boundingBox3, ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.INTERNAL);
            result.add((CollidableComponent)cc);
            this.cachedConnectors.add((CollidableComponent)cc);
        }
        Object var5_14 = null;
        boolean bl = false;
        while (var6_29 < result.size()) {
            CollidableComponent collidableComponent = result.get((int)var6_29);
            if (collidableComponent.conduitType == null && collidableComponent.data == ConduitConnectorType.INTERNAL) {
                BoundingBox boundingBox = var5_15 == null ? collidableComponent.bound : var5_15.expandBy(collidableComponent.bound);
                result.remove((int)var6_29);
                --var6_29;
                this.cachedConnectors.remove(collidableComponent);
            }
            ++var6_29;
        }
        if (var5_15 != null) {
            CollidableComponent collidableComponent = new CollidableComponent(null, (BoundingBox)var5_15, ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.INTERNAL);
            result.add(collidableComponent);
            this.cachedConnectors.add(collidableComponent);
        }
        EnumSet<ForgeDirection> enumSet = EnumSet.noneOf(ForgeDirection.class);
        for (IConduit iConduit : this.conduits) {
            Set<ForgeDirection> extCons = iConduit.getExternalConnections();
            if (extCons == null) continue;
            for (ForgeDirection dir : extCons) {
                if (iConduit.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
                enumSet.add(dir);
            }
        }
        for (ForgeDirection forgeDirection : enumSet) {
            BoundingBox bb = ConduitGeometryUtil.instance.getExternalConnectorBoundingBox(forgeDirection);
            cc = new CollidableComponent(null, bb, forgeDirection, (Object)ConduitConnectorType.EXTERNAL);
            result.add((CollidableComponent)cc);
            this.cachedConnectors.add((CollidableComponent)cc);
        }
        this.connectorsDirty = false;
    }

    private void addConduitCores(List<CollidableComponent> result, IConduit con) {
        CollidableCache cc = CollidableCache.instance;
        Class<? extends IConduit> type = con.getCollidableType();
        if (con.hasConnections()) {
            for (ForgeDirection dir : con.getExternalConnections()) {
                result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), ForgeDirection.UNKNOWN, false), con));
            }
            for (ForgeDirection dir : con.getConduitConnections()) {
                result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), ForgeDirection.UNKNOWN, false), con));
            }
        } else {
            result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), ForgeDirection.UNKNOWN), ForgeDirection.UNKNOWN, false), con));
        }
    }

    private int getConnectionCount(ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return this.conduits.size();
        }
        int result = 0;
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir) && !con.containsExternalConnection(dir)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.canConnectEnergy(from);
        }
        return false;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyRecieved(dir);
        }
        return 0;
    }

    @Override
    public int getEnergyStored() {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored() {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public void setEnergyStored(int stored) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            pc.setEnergyStored(stored);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(from, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.getTankInfo(from);
        }
        return null;
    }

    @Override
    public ItemStack insertItem(ForgeDirection from, ItemStack item) {
        IItemConduit ic = this.getConduit(IItemConduit.class);
        if (ic != null) {
            return ic.insertItem(from, item);
        }
        return item;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.receiveGas(side, stack, doTransfer);
        }
        return 0;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.drawGas(side, amount, doTransfer);
        }
        return null;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.canReceiveGas(side, type);
        }
        return false;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        IGasConduit gc = this.getConduit(IGasConduit.class);
        if (gc != null) {
            return gc.canDrawGas(side, type);
        }
        return false;
    }

    @Override
    public World getWorld() {
        return this.getWorldObj();
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(ForgeDirection dir) {
        if (dir == null || dir == ForgeDirection.UNKNOWN) {
            return (IGridNode)this.node;
        }
        IMEConduit cond = this.getConduit(IMEConduit.class);
        if (cond != null) {
            if (cond.getConnectionMode(dir.getOpposite()) == ConnectionMode.IN_OUT) {
                return (IGridNode)this.node;
            }
            return null;
        }
        return (IGridNode)this.node;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void setGridNode(Object node) {
        this.node = (IGridNode)node;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection dir) {
        IMEConduit cond = this.getConduit(IMEConduit.class);
        if (cond == null) {
            return AECableType.NONE;
        }
        return cond.isConnectedTo(dir) ? AECableType.SMART : AECableType.NONE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    private void initMicroblocks() {
        if (MicroblocksUtil.supportMicroblocks()) {
            this.createCovers();
        }
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    private void createCovers() {
        IMicroblockSystem ims = MicroblockAPIUtils.getMicroblockSystem();
        if (ims != null) {
            this.covers = ims.createMicroblockCoverSystem((IMicroblockSupporterTile)this);
        }
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    public boolean isPlacementBlocked(PartType<?> part, EnumPosition pos) {
        EnumPartClass type = part.getPartClass();
        if (type == EnumPartClass.Strip) {
            if (pos == EnumPosition.PostX || pos == EnumPosition.PostY || pos == EnumPosition.PostZ) {
                return true;
            }
        } else {
            if (part.getSize() < 0.25) {
                return false;
            }
            if (type == EnumPartClass.Panel) {
                List<CollidableComponent> boxes = this.getCollidableComponents();
                BoundingBox bb = new BoundingBox(Part.getBoundingBoxFromPool((EnumPosition)pos, (double)part.getSize()));
                for (CollidableComponent c : boxes) {
                    if (c.dir != ForgeDirection.UNKNOWN || !c.bound.intersects(bb)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    public IMicroblockCoverSystem getCoverSystem() {
        return (IMicroblockCoverSystem)this.covers;
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    private void writeMicroblocksToNBT(NBTTagCompound tag) {
        if (this.covers != null) {
            ((IMicroblockCoverSystem)this.covers).writeToNBT(tag);
        }
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    private void readMicroblocksFromNBT(NBTTagCompound tag) {
        if (this.covers != null) {
            ((IMicroblockCoverSystem)this.covers).readFromNBT(tag);
        }
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    public Packet getDescriptionPacket() {
        if (this.covers == null) {
            return super.getDescriptionPacket();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.setByteArray("C", ((IMicroblockCoverSystem)this.covers).writeDescriptionBytes());
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.covers != null) {
            ((IMicroblockCoverSystem)this.covers).readDescriptionBytes(pkt.func_148857_g().getByteArray("C"), 0);
        }
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    public void onMicroblocksChanged() {
        EnumSet<ForgeDirection> needUpdates = EnumSet.allOf(ForgeDirection.class);
        needUpdates.remove(ForgeDirection.UNKNOWN);
        for (Part p : this.getCoverSystem().getAllParts()) {
            if (p.type.getPartClass() != EnumPartClass.Panel) continue;
            ForgeDirection dir = MicroblocksUtil.posToDir(p.pos);
            this.updateConnections(dir, true);
            needUpdates.remove(dir);
        }
        for (ForgeDirection dir : needUpdates) {
            this.updateConnections(dir, false);
        }
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        this.updateBlock();
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    private void updateConnections(ForgeDirection dir, boolean remove) {
        TileEntity neighbor = this.getLocation().getLocation(dir).getTileEntity((IBlockAccess)this.worldObj);
        IConduitBundle neighborBundle = (IConduitBundle)(neighbor instanceof IConduitBundle ? neighbor : null);
        for (IConduit c : this.getConduits()) {
            if (remove) {
                this.removeConnection(dir, c);
            } else if (neighborBundle != null) {
                this.addConnection(dir, c, neighborBundle.getConduit(c.getBaseConduitType()));
            }
            c.connectionsChanged();
        }
        dir = dir.getOpposite();
        if (neighbor instanceof IConduitBundle) {
            for (IConduit c : ((TileConduitBundle)neighbor).getConduits()) {
                if (remove) {
                    this.removeConnection(dir, c);
                } else if (neighborBundle != null) {
                    this.addConnection(dir, c, this.getConduit(c.getBaseConduitType()));
                }
                c.connectionsChanged();
            }
        }
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    private void removeConnection(ForgeDirection dir, IConduit c) {
        if (c.getConduitConnections().contains(dir)) {
            c.conduitConnectionRemoved(dir);
        }
    }

    @Optional.Method(modid="ImmibisMicroblocks")
    private void addConnection(ForgeDirection dir, IConduit c, IConduit connectingTo) {
        if (connectingTo != null && !c.getConduitConnections().contains(dir) && connectingTo.canConnectToConduit(dir, c)) {
            c.conduitConnectionAdded(dir);
        }
    }
}

