/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.MicroblocksUtil;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.facade.ItemConduitFacade;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.gui.ExternalConnectionContainer;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.GuiExternalConnectionSelector;
import crazypants.enderio.conduit.gui.PacketFluidFilter;
import crazypants.enderio.conduit.gui.PacketOpenConduitUI;
import crazypants.enderio.conduit.gui.PacketSlotVisibility;
import crazypants.enderio.conduit.gui.item.PacketExistingItemFilterSnapshot;
import crazypants.enderio.conduit.gui.item.PacketModItemFilter;
import crazypants.enderio.conduit.liquid.PacketFluidLevel;
import crazypants.enderio.conduit.packet.PacketConnectionMode;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitOutputStrength;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitSignalColor;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.item.IRotatableFacade;
import crazypants.enderio.item.ItemConduitProbe;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.IFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mods.immibis.core.api.multipart.IMultipartRenderingBlockMarker;
import mods.immibis.core.api.multipart.IMultipartSystem;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;

@Optional.InterfaceList(value={@Optional.Interface(iface="powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode", modid="MineFactoryReloaded"), @Optional.Interface(iface="mods.immibis.core.api.multipart.IMultipartRenderingBlockMarker", modid="ImmibisMicroblocks")})
public class BlockConduitBundle
extends BlockEio
implements IGuiHandler,
IFacade,
IRotatableFacade,
IRedNetOmniNode,
IMultipartRenderingBlockMarker {
    private static final String KEY_CONNECTOR_ICON = "enderIO:conduitConnector";
    private static final String KEY_CONNECTOR_ICON_EXTERNAL = "enderIO:conduitConnectorExternal";
    public static int rendererId = -1;
    private IIcon connectorIcon;
    private IIcon connectorIconExternal;
    private IIcon lastRemovedComponetIcon = null;
    private final Random rand = new Random();

    public static BlockConduitBundle create() {
        MinecraftForge.EVENT_BUS.register((Object)ConduitNetworkTickHandler.instance);
        FMLCommonHandler.instance().bus().register((Object)ConduitNetworkTickHandler.instance);
        PacketHandler.INSTANCE.registerMessage(PacketFluidLevel.class, PacketFluidLevel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketExtractMode.class, PacketExtractMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketConnectionMode.class, PacketConnectionMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketItemConduitFilter.class, PacketItemConduitFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketExistingItemFilterSnapshot.class, PacketExistingItemFilterSnapshot.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketModItemFilter.class, PacketModItemFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketFluidFilter.class, PacketFluidFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitSignalColor.class, PacketRedstoneConduitSignalColor.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitOutputStrength.class, PacketRedstoneConduitOutputStrength.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenConduitUI.class, PacketOpenConduitUI.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSlotVisibility.class, PacketSlotVisibility.class, PacketHandler.nextID(), Side.SERVER);
        BlockConduitBundle result = new BlockConduitBundle();
        result.init();
        MinecraftForge.EVENT_BUS.register((Object)result);
        return result;
    }

    protected BlockConduitBundle() {
        super(ModObject.blockConduitBundle.unlocalisedName, TileConduitBundle.class);
        this.setBlockBounds(0.334f, 0.334f, 0.334f, 0.667f, 0.667f, 0.667f);
        this.setHardness(1.5f);
        this.setResistance(10.0f);
        this.setCreativeTab(null);
        this.stepSound = new Block.SoundType("silence", 0.0f, 0.0f){

            public String getBreakSound() {
                return "EnderIO:" + this.soundName + ".dig";
            }

            public String getStepResourcePath() {
                return "EnderIO:" + this.soundName + ".step";
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        if (MicroblocksUtil.supportMicroblocks() && this.IM__addHitEffects(world, target, effectRenderer)) {
            return true;
        }
        IIcon tex = null;
        TileConduitBundle cb = (TileConduitBundle)world.getTileEntity(target.blockX, target.blockY, target.blockZ);
        if (ConduitUtil.isSolidFacadeRendered(cb, (EntityPlayer)Minecraft.getMinecraft().thePlayer)) {
            if (cb.getFacadeId() != null) {
                tex = cb.getFacadeId().getIcon(target.sideHit, cb.getFacadeMetadata());
            }
        } else if (target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            IConduit con = cb.getConduit(cc.conduitType);
            if (con != null) {
                tex = con.getTextureForState(cc);
            }
        }
        if (tex == null) {
            tex = this.blockIcon;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.blockX, target.blockY, target.blockZ, target.sideHit, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        if (MicroblocksUtil.supportMicroblocks() && this.IM__addDestroyEffects(world, x, y, z, meta, effectRenderer)) {
            return true;
        }
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).applyColourMultiplier(x, y, z);
                    fx.setParticleIcon(tex);
                    effectRenderer.addEffect((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.getBlockBoundsMaxX() - this.getBlockBoundsMinX() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinX();
        double d1 = (double)y + this.rand.nextDouble() * (this.getBlockBoundsMaxY() - this.getBlockBoundsMinY() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinY();
        double d2 = (double)z + this.rand.nextDouble() * (this.getBlockBoundsMaxZ() - this.getBlockBoundsMinZ() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinZ();
        if (side == 0) {
            d1 = (double)y + this.getBlockBoundsMinY() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.getBlockBoundsMaxY() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.getBlockBoundsMinZ() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.getBlockBoundsMaxZ() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.getBlockBoundsMinX() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.getBlockBoundsMaxX() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.applyColourMultiplier(x, y, z).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f);
        digFX.setParticleIcon(tex);
        effectRenderer.addEffect((EntityFX)digFX);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundSourceEvent event) {
        String path = event.sound.getPositionedSoundLocation().getResourcePath();
        if ("silence.step".equals(path)) {
            ISound snd = event.sound;
            World world = EnderIO.proxy.getClientWorld();
            BlockCoord bc = new BlockCoord((double)snd.getXPosF(), (double)snd.getYPosF(), (double)snd.getZPosF());
            TileEntity te = bc.getTileEntity((IBlockAccess)world);
            if (te != null && te instanceof TileConduitBundle && ((TileConduitBundle)te).hasFacade()) {
                Block facade = this.getFacade((IBlockAccess)world, bc.x, bc.y, bc.z, -1);
                ConduitUtil.playHitSound(facade.stepSound, world, bc.x, bc.y, bc.z);
            } else {
                ConduitUtil.playHitSound(Block.soundTypeMetal, world, bc.x, bc.y, bc.z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        String path = event.name;
        World world = event.entity.worldObj;
        if ("EnderIO:silence.step".equals(path) && world.isRemote) {
            BlockCoord bc = new BlockCoord(event.entity.posX, event.entity.posY - 2.0, event.entity.posZ);
            TileEntity te = bc.getTileEntity((IBlockAccess)world);
            if (te != null && te instanceof TileConduitBundle && ((TileConduitBundle)te).hasFacade()) {
                Block facade = this.getFacade((IBlockAccess)world, bc.x, bc.y, bc.z, -1);
                ConduitUtil.playStepSound(facade.stepSound, world, bc.x, bc.y, bc.z);
            } else {
                ConduitUtil.playStepSound(Block.soundTypeMetal, world, bc.x, bc.y, bc.z);
            }
        }
    }

    protected void init() {
        super.init();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            EnderIO.guiHandler.registerGuiHandler(9 + dir.ordinal(), this);
        }
        EnderIO.guiHandler.registerGuiHandler(16, this);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack ret = null;
        if (MicroblocksUtil.supportMicroblocks()) {
            ret = this.getMicroblockPickBlock(target, world, x, y, z, player);
        }
        if (ret == null && target != null && target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            TileConduitBundle bundle = (TileConduitBundle)world.getTileEntity(x, y, z);
            IConduit conduit = bundle.getConduit(cc.conduitType);
            if (conduit != null) {
                ret = conduit.createItem();
            } else if (cc.conduitType == null && bundle.getFacadeId() != null) {
                ret = new ItemStack((Item)EnderIO.itemConduitFacade, 1, 0);
                PainterUtil.setSourceBlock(ret, bundle.getFacadeId(), bundle.getFacadeMetadata());
            }
        }
        return ret;
    }

    public int getDamageValue(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return 0;
        }
        IConduitBundle bun = (IConduitBundle)te;
        return bun.getFacadeId() != null ? bun.getFacadeMetadata() : 0;
    }

    public int quantityDropped(Random r) {
        return 0;
    }

    public IIcon getConnectorIcon(Object data) {
        return data == ConduitConnectorType.EXTERNAL ? this.connectorIconExternal : this.connectorIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.connectorIcon = IIconRegister2.registerIcon(KEY_CONNECTOR_ICON);
        this.connectorIconExternal = IIconRegister2.registerIcon(KEY_CONNECTOR_ICON_EXTERNAL);
        this.blockIcon = this.connectorIcon;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (MicroblocksUtil.supportMicroblocks() && this.IM__isSideSolid(world, x, y, z, side)) {
            return true;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return false;
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.hasFacade();
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return rendererId;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightOpacity(world, x, y, z);
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.getLightOpacity();
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightValue(world, x, y, z);
        }
        IConduitBundle con = (IConduitBundle)te;
        if (con.getFacadeId() != null && con.getFacadeId().isOpaqueCube()) {
            return 0;
        }
        Collection<IConduit> conduits = con.getConduits();
        int result = 0;
        for (IConduit conduit : conduits) {
            result += conduit.getLightValue();
        }
        return result;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        IConduitBundle te = (IConduitBundle)world.getTileEntity(x, y, z);
        return te != null && te.getFacadeType() == ItemConduitFacade.FacadeType.HARDENED ? this.blockHardness * 10.0f : this.blockHardness;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        float resist = this.getExplosionResistance(par1Entity);
        IConduitBundle te = (IConduitBundle)world.getTileEntity(x, y, z);
        return te != null && te.getFacadeType() == ItemConduitFacade.FacadeType.HARDENED ? resist * 10.0f : resist;
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.block == this) {
            IConduitBundle te;
            ItemStack held = event.entityPlayer.getCurrentEquippedItem();
            if (held == null || held.getItem().getHarvestLevel(held, "pickaxe") == -1) {
                event.newSpeed += 2.0f;
            }
            if ((te = (IConduitBundle)event.entity.worldObj.getTileEntity(event.x, event.y, event.z)) != null && te.getFacadeType() == ItemConduitFacade.FacadeType.HARDENED) {
                event.newSpeed = !ConduitUtil.isSolidFacadeRendered(te, event.entityPlayer) ? (event.newSpeed *= 6.0f) : (event.newSpeed *= 2.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderBlockPass() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public int isProvidingStrongPower(IBlockAccess world, int x, int y, int z, int par5) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, x, y, z);
        if (con == null) {
            return 0;
        }
        return con.isProvidingStrongPower(ForgeDirection.getOrientation((int)par5));
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int par5) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, x, y, z);
        if (con == null) {
            return 0;
        }
        return con.isProvidingWeakPower(ForgeDirection.getOrientation((int)par5));
    }

    public boolean canProvidePower() {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        IConduitBundle te = (IConduitBundle)world.getTileEntity(x, y, z);
        if (te == null) {
            return true;
        }
        boolean breakBlock = true;
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        if (ConduitUtil.isSolidFacadeRendered(te, player)) {
            breakBlock = false;
            ItemStack fac = new ItemStack((Item)EnderIO.itemConduitFacade, 1, te.getFacadeType().ordinal());
            PainterUtil.setSourceBlock(fac, te.getFacadeId(), te.getFacadeMetadata());
            drop.add(fac);
            ConduitUtil.playBreakSound(te.getFacadeId().stepSound, world, x, y, z);
            te.setFacadeId(null);
            te.setFacadeMetadata(0);
            te.setFacadeType(ItemConduitFacade.FacadeType.BASIC);
        }
        if (breakBlock) {
            List<RaytraceResult> results = this.doRayTraceAll(world, x, y, z, player);
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), results);
            for (RaytraceResult rt : results) {
                if (this.breakConduit(te, drop, rt, player)) break;
            }
        }
        boolean bl = breakBlock = te.getConduits().isEmpty() && !te.hasFacade();
        if (!breakBlock) {
            world.markBlockForUpdate(x, y, z);
        }
        if (MicroblocksUtil.supportMicroblocks()) {
            this.IM__getDrops(drop, world, x, y, z, te.getEntity().getBlockMetadata(), 0);
        }
        if (!world.isRemote && !player.capabilities.isCreativeMode) {
            for (ItemStack st : drop) {
                Util.dropItems((World)world, (ItemStack)st, (int)x, (int)y, (int)z, (boolean)false);
            }
        }
        if (breakBlock) {
            world.setBlockToAir(x, y, z);
            return true;
        }
        return false;
    }

    private boolean breakConduit(IConduitBundle te, List<ItemStack> drop, RaytraceResult rt, EntityPlayer player) {
        if (rt == null || rt.component == null) {
            return false;
        }
        Class<? extends IConduit> type = rt.component.conduitType;
        if (!ConduitUtil.renderConduit(player, type)) {
            return false;
        }
        if (type == null) {
            ArrayList<IConduit> cons = new ArrayList<IConduit>(te.getConduits());
            boolean droppedUnconected = false;
            for (IConduit con : cons) {
                if (!con.getConduitConnections().isEmpty() || !con.getExternalConnections().isEmpty() || !ConduitUtil.renderConduit(player, con)) continue;
                te.removeConduit(con);
                drop.addAll(con.getDrops());
                droppedUnconected = true;
            }
            if (!droppedUnconected) {
                for (IConduit con : cons) {
                    if (!ConduitUtil.renderConduit(player, con)) continue;
                    te.removeConduit(con);
                    drop.addAll(con.getDrops());
                }
            }
        } else {
            IConduit con = te.getConduit(type);
            if (con != null) {
                te.removeConduit(con);
                drop.addAll(con.getDrops());
            }
        }
        BlockCoord bc = te.getLocation();
        ConduitUtil.playBreakSound(Block.soundTypeMetal, te.getWorld(), bc.x, bc.y, bc.z);
        return true;
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle te = (IConduitBundle)tile;
        te.onBlockRemoved();
        world.removeTileEntity(x, y, z);
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack equipped = player.getCurrentEquippedItem();
        if (!player.isSneaking() || equipped == null || equipped.getItem() != EnderIO.itemYetaWench) {
            return;
        }
        ConduitUtil.openConduitGui(world, x, y, z, player);
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        IConduitBundle bundle = (IConduitBundle)world.getTileEntity(x, y, z);
        if (bundle == null) {
            return false;
        }
        ItemStack stack = player.getCurrentEquippedItem();
        if (stack != null && stack.getItem() == EnderIO.itemConduitFacade) {
            return this.handleFacadeClick(world, x, y, z, player, side, bundle, stack);
        }
        if (ConduitUtil.isConduitEquipped(player)) {
            if (player.isSneaking()) {
                return false;
            }
            if (this.handleConduitClick(world, x, y, z, player, bundle, stack)) {
                return true;
            }
        } else if (ConduitUtil.isProbeEquipped(player) ? this.handleConduitProbeClick(world, x, y, z, player, bundle, stack) : ToolUtil.isToolEquipped(player) && player.isSneaking() && this.handleWrenchClick(world, x, y, z, player)) {
            return true;
        }
        RaytraceResult closest = this.doRayTrace(world, x, y, z, player);
        List<RaytraceResult> all = null;
        if (closest != null) {
            all = this.doRayTraceAll(world, x, y, z, player);
        }
        if (closest != null && closest.component != null && closest.component.data instanceof ConduitConnectorType) {
            Object conType = (ConduitConnectorType)((Object)closest.component.data);
            if (conType == ConduitConnectorType.INTERNAL) {
                boolean result = false;
                for (IConduit con : bundle.getConduits()) {
                    if (!ConduitUtil.renderConduit(player, con.getCollidableType()) || !con.onBlockActivated(player, this.getHitForConduitType(all, con.getCollidableType()), all)) continue;
                    bundle.getEntity().markDirty();
                    result = true;
                }
                if (result) {
                    return true;
                }
            } else {
                if (!world.isRemote) {
                    player.openGui((Object)EnderIO.instance, 9 + closest.component.dir.ordinal(), world, x, y, z);
                }
                return true;
            }
        }
        if (closest == null || closest.component == null || closest.component.conduitType == null && all == null) {
            return false;
        }
        if (all != null) {
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), all);
            for (RaytraceResult rr : all) {
                IConduit con;
                if (!ConduitUtil.renderConduit(player, rr.component.conduitType) || rr.component.data instanceof ConduitConnectorType || (con = bundle.getConduit(rr.component.conduitType)) == null || !con.onBlockActivated(player, rr, all)) continue;
                bundle.getEntity().markDirty();
                return true;
            }
        } else {
            IConduit closestConduit = bundle.getConduit(closest.component.conduitType);
            if (closestConduit != null && ConduitUtil.renderConduit(player, closestConduit) && closestConduit.onBlockActivated(player, closest, all)) {
                bundle.getEntity().markDirty();
                return true;
            }
        }
        return false;
    }

    private boolean handleWrenchClick(World world, int x, int y, int z, EntityPlayer player) {
        ITool tool = ToolUtil.getEquippedTool(player);
        if (tool != null && tool.canUse(player.getCurrentEquippedItem(), player, x, y, z)) {
            if (!world.isRemote) {
                this.removedByPlayer(world, player, x, y, z, true);
                tool.used(player.getCurrentEquippedItem(), player, x, y, z);
            }
            return true;
        }
        return false;
    }

    private boolean handleConduitProbeClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack) {
        if (stack.getItemDamage() != 1) {
            return false;
        }
        RaytraceResult rr = this.doRayTrace(world, x, y, z, player);
        if (rr == null || rr.component == null) {
            return false;
        }
        return ItemConduitProbe.copyPasteSettings(player, stack, bundle, rr.component.dir);
    }

    private boolean handleConduitClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack) {
        IConduitItem equipped = (IConduitItem)stack.getItem();
        if (!bundle.hasType(equipped.getBaseConduitType())) {
            if (!world.isRemote) {
                bundle.addConduit(equipped.createConduit(stack, player));
                ConduitUtil.playBreakSound(soundTypeMetal, world, x, y, z);
                if (!player.capabilities.isCreativeMode) {
                    --player.getCurrentEquippedItem().stackSize;
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleFacadeClick(World world, int x, int y, int z, EntityPlayer player, int side, IConduitBundle bundle, ItemStack stack) {
        if (MicroblocksUtil.supportMicroblocks() && this.hasMicroblocks(bundle)) {
            return false;
        }
        if (player.isSneaking()) {
            return false;
        }
        Block facadeID = PainterUtil.getSourceBlock(player.getCurrentEquippedItem());
        if (facadeID == null) {
            return false;
        }
        int facadeMeta = PainterUtil.getSourceBlockMetadata(player.getCurrentEquippedItem());
        facadeMeta = PainterUtil.adjustFacadeMetadata(facadeID, facadeMeta, side);
        int facadeType = player.getCurrentEquippedItem().getItemDamage();
        if (bundle.hasFacade()) {
            if (!ConduitUtil.isSolidFacadeRendered(bundle, player) || this.facadeEquals(bundle, facadeID, facadeMeta, facadeType)) {
                return false;
            }
            if (!world.isRemote && !player.capabilities.isCreativeMode) {
                ItemStack fac = new ItemStack((Item)EnderIO.itemConduitFacade, 1, bundle.getFacadeType().ordinal());
                PainterUtil.setSourceBlock(fac, bundle.getFacadeId(), bundle.getFacadeMetadata());
                Util.dropItems((World)world, (ItemStack)fac, (int)x, (int)y, (int)z, (boolean)false);
            }
        }
        bundle.setFacadeId(facadeID);
        bundle.setFacadeMetadata(facadeMeta);
        bundle.setFacadeType(ItemConduitFacade.FacadeType.values()[facadeType]);
        if (!world.isRemote) {
            ConduitUtil.playStepSound(facadeID.stepSound, world, x, y, z);
        }
        if (!player.capabilities.isCreativeMode) {
            --stack.stackSize;
        }
        world.markBlockForUpdate(x, y, z);
        bundle.getEntity().markDirty();
        return true;
    }

    private boolean facadeEquals(IConduitBundle bundle, Block facadeID, int facadeMeta, int facadeType) {
        return bundle.getFacadeId().equals(facadeID) && bundle.getFacadeMetadata() == facadeMeta && bundle.getFacadeType().ordinal() == facadeType;
    }

    @Override
    public boolean tryRotateFacade(World world, int x, int y, int z, ForgeDirection axis) {
        IConduitBundle bundle = (IConduitBundle)world.getTileEntity(x, y, z);
        if (bundle == null) {
            return false;
        }
        int oldMeta = bundle.getFacadeMetadata();
        int newMeta = PainterUtil.rotateFacadeMetadata(bundle.getFacadeId(), oldMeta, axis);
        if (newMeta == oldMeta) {
            return false;
        }
        bundle.setFacadeMetadata(newMeta);
        world.markBlockForUpdate(x, y, z);
        bundle.getEntity().markDirty();
        return true;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == 16) {
            return null;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IConduitBundle) {
            return new ExternalConnectionContainer(player.inventory, (IConduitBundle)te, ForgeDirection.values()[id - 9]);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IConduitBundle) {
            if (id == 16) {
                return new GuiExternalConnectionSelector((IConduitBundle)te);
            }
            return new GuiExternalConnection(player.inventory, (IConduitBundle)te, ForgeDirection.values()[id - 9]);
        }
        return null;
    }

    private RaytraceResult getHitForConduitType(List<RaytraceResult> all, Class<? extends IConduit> collidableType) {
        for (RaytraceResult rr : all) {
            if (rr.component == null || rr.component.conduitType != collidableType) continue;
            return rr;
        }
        return null;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block blockId) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IConduitBundle) {
            ((IConduitBundle)tile).onNeighborBlockChange(blockId);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity conduit = world.getTileEntity(x, y, z);
        if (conduit instanceof IConduitBundle) {
            ((IConduitBundle)conduit).onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        }
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        TileEntity te;
        if (MicroblocksUtil.supportMicroblocks()) {
            this.IM__addCollisionBoxesToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        }
        if (!((te = world.getTileEntity(x, y, z)) instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle con = (IConduitBundle)te;
        if (con.getFacadeId() != null) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.addCollisionBoxesToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        } else {
            List<CollidableComponent> bounds = con.getCollidableComponents();
            for (CollidableComponent bnd : bounds) {
                this.setBlockBounds(bnd.bound.minX, bnd.bound.minY, bnd.bound.minZ, bnd.bound.maxX, bnd.bound.maxY, bnd.bound.maxZ);
                super.addCollisionBoxesToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            }
            if (con.getConduits().isEmpty()) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.addCollisionBoxesToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle con = (IConduitBundle)te;
        BoundingBox minBB = new BoundingBox(1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        if (!ConduitUtil.isSolidFacadeRendered(con, EnderIO.proxy.getClientPlayer())) {
            RaytraceResult hit;
            List<RaytraceResult> results = this.doRayTraceAll(world, x, y, z, (EntityPlayer)player);
            Iterator<RaytraceResult> iter = results.iterator();
            while (iter.hasNext()) {
                CollidableComponent component = iter.next().component;
                if (component != null && (component.conduitType != null || component.data == ConduitConnectorType.EXTERNAL)) continue;
                iter.remove();
            }
            for (RaytraceResult hit2 : results) {
                IInsulatedRedstoneConduit cond = con.getConduit(IInsulatedRedstoneConduit.class);
                if (cond == null || hit2.component == null || !cond.getExternalConnections().contains(hit2.component.dir) || cond.isSpecialConnection(hit2.component.dir) || hit2.component.data != "ColorController") continue;
                minBB = hit2.component.bound;
            }
            if (!minBB.isValid() && (hit = RaytraceResult.getClosestHit(Util.getEyePosition((EntityPlayer)player), results)) != null && hit.component != null && hit.component.bound != null) {
                minBB = hit.component.bound;
                if (hit.component.conduitType == null) {
                    ForgeDirection dir = hit.component.dir.getOpposite();
                    float trans = 0.0125f;
                    minBB = minBB.translate((float)dir.offsetX * trans, (float)dir.offsetY * trans, (float)dir.offsetZ * trans);
                    float scale = 0.7f;
                    minBB = minBB.scale(1.0f + (float)Math.abs(dir.offsetX) * scale, 1.0f + (float)Math.abs(dir.offsetY) * scale, 1.0f + (float)Math.abs(dir.offsetZ) * scale);
                } else {
                    minBB = minBB.scale(1.09, 1.09, 1.09);
                }
            }
        } else {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!minBB.isValid()) {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        return AxisAlignedBB.getBoundingBox((double)((float)x + minBB.minX), (double)((float)y + minBB.minY), (double)((float)z + minBB.minZ), (double)((float)x + minBB.maxX), (double)((float)y + minBB.maxY), (double)((float)z + minBB.maxZ));
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, x, y, z, origin, direction, null);
        MovingObjectPosition ret = null;
        if (raytraceResult != null && (ret = raytraceResult.movingObjectPosition) != null) {
            ret.hitInfo = raytraceResult.component;
        }
        if (MicroblocksUtil.supportMicroblocks()) {
            return this.IM__collisionRayTrace(ret, world, x, y, z, origin, direction);
        }
        return ret;
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, x, y, z, entityPlayer);
        if (allHits == null) {
            return null;
        }
        Vec3 origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    public List<RaytraceResult> doRayTraceAll(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        double pitch = Math.toRadians(entityPlayer.rotationPitch);
        double yaw = Math.toRadians(entityPlayer.rotationYaw);
        double dirX = -Math.sin(yaw) * Math.cos(pitch);
        double dirY = -Math.sin(pitch);
        double dirZ = Math.cos(yaw) * Math.cos(pitch);
        double reachDistance = EnderIO.proxy.getReachDistanceForPlayer(entityPlayer);
        Vec3 origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        Vec3 direction = origin.addVector(dirX * reachDistance, dirY * reachDistance, dirZ * reachDistance);
        return this.doRayTraceAll(world, x, y, z, origin, direction, entityPlayer);
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, x, y, z, origin, direction, entityPlayer);
        if (allHits == null) {
            return null;
        }
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    protected List<RaytraceResult> doRayTraceAll(World world, int x, int y, int z, Vec3 origin, Vec3 direction, EntityPlayer player) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        ArrayList<RaytraceResult> hits = new ArrayList<RaytraceResult>();
        if (player == null) {
            player = EnderIO.proxy.getClientPlayer();
        }
        if (ConduitUtil.isSolidFacadeRendered(bundle, player)) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            MovingObjectPosition hitPos = super.collisionRayTrace(world, x, y, z, origin, direction);
            if (hitPos != null) {
                hits.add(new RaytraceResult(new CollidableComponent(null, BoundingBox.UNIT_CUBE, ForgeDirection.UNKNOWN, null), hitPos));
            }
        } else {
            ConduitDisplayMode mode = ConduitUtil.getDisplayMode(player);
            ArrayList<CollidableComponent> components = new ArrayList<CollidableComponent>(bundle.getCollidableComponents());
            for (CollidableComponent component : components) {
                if (component.conduitType == null && mode != ConduitDisplayMode.ALL || !ConduitUtil.renderConduit(player, component.conduitType)) continue;
                this.setBlockBounds(component.bound.minX, component.bound.minY, component.bound.minZ, component.bound.maxX, component.bound.maxY, component.bound.maxZ);
                MovingObjectPosition hitPos = super.collisionRayTrace(world, x, y, z, origin, direction);
                if (hitPos == null) continue;
                hits.add(new RaytraceResult(component, hitPos));
            }
            if (bundle.getConduits().isEmpty() && !ConduitUtil.isFacadeHidden(bundle, player)) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                MovingObjectPosition hitPos = super.collisionRayTrace(world, x, y, z, origin, direction);
                if (hitPos != null) {
                    hits.add(new RaytraceResult(null, hitPos));
                }
            }
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return hits;
    }

    @Override
    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return 0;
        }
        IConduitBundle cb = (IConduitBundle)te;
        return cb.getFacadeMetadata();
    }

    @Override
    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return this;
        }
        IConduitBundle cb = (IConduitBundle)te;
        Block res = cb.getFacadeId();
        if (res == null) {
            return this;
        }
        return res;
    }

    @Override
    public Block getVisualBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacade(world, x, y, z, side.ordinal());
    }

    @Override
    public int getVisualMeta(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacadeMetadata(world, x, y, z, side.ordinal());
    }

    @Override
    public boolean supportsVisualConnections() {
        return true;
    }

    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return;
        }
        conduit.onInputsChanged(world, x, y, z, side, inputValues);
    }

    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
    }

    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return null;
        }
        return conduit.getOutputValues(world, x, y, z, side);
    }

    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return 0;
        }
        return conduit.getOutputValue(world, x, y, z, side, subnet);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return RedNetConnectionType.None;
        }
        return conduit.canConnectToExternal(side, false) ? RedNetConnectionType.CableAll : RedNetConnectionType.None;
    }

    private static IRedstoneConduit getRedstoneConduit(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        return bundle.getConduit(IRedstoneConduit.class);
    }

    public ItemStack getMicroblockPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return IMultipartSystem.instance.hook_getPickBlock(target, world, x, y, z, player);
    }

    private boolean IM__isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return IMultipartSystem.instance.hook_isSideSolid(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean IM__addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return IMultipartSystem.instance.hook_addDestroyEffects(world, x, y, z, meta, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean IM__addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return IMultipartSystem.instance.hook_addHitEffects(worldObj, target, effectRenderer);
    }

    private MovingObjectPosition IM__collisionRayTrace(MovingObjectPosition cur, World world, int x, int y, int z, Vec3 src, Vec3 dst) {
        return IMultipartSystem.instance.hook_collisionRayTrace(cur, world, x, y, z, src, dst);
    }

    private void IM__addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        IMultipartSystem.instance.hook_addCollisionBoxesToList(world, x, y, z, mask, list, entity);
    }

    private ArrayList<ItemStack> IM__getDrops(List<ItemStack> cur, World world, int x, int y, int z, int metadata, int fortune) {
        return IMultipartSystem.instance.hook_getDrops(cur, world, x, y, z, metadata, fortune);
    }

    private boolean hasMicroblocks(IConduitBundle bundle) {
        return !bundle.getCoverSystem().getAllParts().isEmpty();
    }
}

