/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class AbstractConduitNetwork<T extends IConduit, I extends T> {
    protected final List<I> conduits = new ArrayList<I>();
    protected final Class<I> implClass;
    protected final Class<T> baseConduitClass;

    protected AbstractConduitNetwork(Class<I> implClass, Class<T> baseConduitClass) {
        this.implClass = implClass;
        this.baseConduitClass = baseConduitClass;
    }

    public void init(IConduitBundle tile, Collection<I> connections, World world) {
        if (world.isRemote) {
            throw new UnsupportedOperationException();
        }
        for (IConduit con : connections) {
            AbstractConduitNetwork<?, ?> network = con.getNetwork();
            if (network == null) continue;
            network.destroyNetwork();
        }
        this.setNetwork(world, tile);
        this.notifyNetworkOfUpdate();
    }

    public final Class<T> getBaseConduitType() {
        return this.baseConduitClass;
    }

    protected void setNetwork(World world, IConduitBundle tile) {
        T conduit = tile.getConduit(this.getBaseConduitType());
        if (conduit != null && this.implClass.isAssignableFrom(conduit.getClass()) && conduit.setNetwork(this)) {
            this.addConduit((IConduit)this.implClass.cast(conduit));
            TileEntity te = tile.getEntity();
            Collection<IConduit> connections = ConduitUtil.getConnectedConduits(world, te.xCoord, te.yCoord, te.zCoord, this.getBaseConduitType());
            for (IConduit con : connections) {
                if (con.getNetwork() == null) {
                    this.setNetwork(world, con.getBundle());
                    continue;
                }
                if (con.getNetwork() == this) continue;
                con.getNetwork().destroyNetwork();
                this.setNetwork(world, con.getBundle());
            }
        }
    }

    public void addConduit(I con) {
        if (!this.conduits.contains(con)) {
            if (this.conduits.isEmpty()) {
                ConduitNetworkTickHandler.instance.registerNetwork(this);
            }
            this.conduits.add(con);
        }
    }

    public void destroyNetwork() {
        for (IConduit con : this.conduits) {
            con.setNetwork(null);
        }
        this.conduits.clear();
        ConduitNetworkTickHandler.instance.unregisterNetwork(this);
    }

    public List<I> getConduits() {
        return this.conduits;
    }

    public void notifyNetworkOfUpdate() {
        for (IConduit con : this.conduits) {
            TileEntity te = con.getBundle().getEntity();
            te.getWorldObj().markBlockForUpdate(te.xCoord, te.yCoord, te.zCoord);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IConduit con : this.conduits) {
            sb.append(con.getLocation());
            sb.append(", ");
        }
        return "AbstractConduitNetwork [conduits=" + sb.toString() + "]";
    }

    public void doNetworkTick() {
    }
}

