/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.block;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockDarkSteelLadder
extends BlockLadder
implements IResourceTooltipProvider {
    public static BlockDarkSteelLadder create() {
        BlockDarkSteelLadder res = new BlockDarkSteelLadder();
        res.init();
        return res;
    }

    protected BlockDarkSteelLadder() {
        this.setBlockName(ModObject.blockDarkSteelLadder.unlocalisedName);
        this.setBlockTextureName(EnderIO.DOMAIN + ":" + ModObject.blockDarkSteelLadder.unlocalisedName);
        this.setStepSound(Block.soundTypeMetal);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
        this.setHardness(0.4f);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)ModObject.blockDarkSteelLadder.unlocalisedName);
    }

    public Material getMaterial() {
        return Material.iron;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        Block blockUnder;
        if (entity.onGround || entity.isCollidedVertically) {
            return;
        }
        if (entity.motionY >= 0.1) {
            entity.setPosition(entity.posX, entity.posY + (double)Config.darkSteelLadderSpeedBoost, entity.posZ);
        } else if (entity.motionY <= -0.1 && ((blockUnder = entity.worldObj.getBlock(MathHelper.floor_double((double)entity.posX), MathHelper.floor_double((double)entity.posY) - 3, MathHelper.floor_double((double)entity.posZ))) == null || blockUnder == this)) {
            entity.setPosition(entity.posX, entity.posY - (double)Config.darkSteelLadderSpeedBoost, entity.posZ);
        }
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName();
    }
}

