/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import cofh.api.transport.IItemDuct;
import com.enderio.core.EnderCore;
import com.enderio.core.api.common.util.IItemReceptor;
import com.enderio.core.common.util.Log;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtil {
    public static final List<IItemReceptor> receptors;
    private static final Random rand;

    public static Object parseStringIntoRecipeItem(String string) {
        return ItemUtil.parseStringIntoRecipeItem(string, false);
    }

    public static Object parseStringIntoRecipeItem(String string, boolean forceItemStack) {
        if ("null".equals(string)) {
            return null;
        }
        if (OreDictionary.getOres((String)string).isEmpty()) {
            ItemStack stack = null;
            String[] info = string.split(";");
            Object temp = null;
            int damage = Short.MAX_VALUE;
            temp = Item.itemRegistry.getObject(info[0]);
            if (info.length > 1) {
                damage = Integer.parseInt(info[1]);
            }
            if (temp instanceof Item) {
                stack = new ItemStack((Item)temp, 1, damage);
            } else if (temp instanceof Block) {
                stack = new ItemStack((Block)temp, 1, damage);
            } else if (temp instanceof ItemStack) {
                stack = ((ItemStack)temp).copy();
                stack.setItemDamage(damage);
            } else {
                throw new IllegalArgumentException(string + " is not a vaild string. Strings should be either an oredict name, or in the format objectname;damage (damage is optional)");
            }
            return stack;
        }
        if (forceItemStack) {
            return ((ItemStack)OreDictionary.getOres((String)string).get(0)).copy();
        }
        return string;
    }

    public static ItemStack parseStringIntoItemStack(String string) {
        int size = 1;
        int numIdx = string.indexOf(35);
        int nbtIdx = string.indexOf(36);
        NBTTagCompound tag = null;
        if (numIdx > -1) {
            String num = string.substring(numIdx + 1, nbtIdx == -1 ? string.length() : nbtIdx);
            try {
                size = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(num + " is not a valid stack size", e);
            }
            string = string.replace('#' + num, "");
            nbtIdx -= num.length() + 1;
        }
        if (nbtIdx > -1) {
            String nbt = string.substring(nbtIdx + 1);
            try {
                tag = (NBTTagCompound)JsonToNBT.func_150315_a((String)nbt);
            }
            catch (NBTException e) {
                throw new IllegalArgumentException(nbt + " is not valid NBT json.", e);
            }
            string = string.replace('$' + nbt, "");
        }
        ItemStack stack = (ItemStack)ItemUtil.parseStringIntoRecipeItem(string, true);
        stack.stackSize = MathHelper.clamp_int((int)size, (int)1, (int)stack.getMaxStackSize());
        stack.setTagCompound(tag);
        return stack;
    }

    public static String getStringForItemStack(ItemStack stack, boolean damage, boolean size) {
        if (stack == null) {
            return null;
        }
        String base = Item.itemRegistry.getNameForObject((Object)stack.getItem());
        if (damage) {
            base = base + ";" + stack.getItemDamage();
        }
        if (size) {
            base = base + "#" + stack.stackSize;
        }
        return base;
    }

    public static boolean stacksEqual(ItemStack s1, ItemStack s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!s1.isItemEqual(s2)) {
            return false;
        }
        if (s1.getTagCompound() == null && s2.getTagCompound() == null) {
            return true;
        }
        if (s1.getTagCompound() == null || s2.getTagCompound() == null) {
            return false;
        }
        return s1.getTagCompound().equals((Object)s2.getTagCompound());
    }

    public static void spawnItemInWorldWithRandomMotion(World world, ItemStack item, int x, int y, int z) {
        if (item != null) {
            ItemUtil.spawnItemInWorldWithRandomMotion(new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, item));
        }
    }

    public static void spawnItemInWorldWithRandomMotion(EntityItem entity) {
        entity.delayBeforeCanPickup = 10;
        float f = rand.nextFloat() * 0.1f - 0.05f;
        float f1 = rand.nextFloat() * 0.1f - 0.05f;
        float f2 = rand.nextFloat() * 0.1f - 0.05f;
        entity.motionX += (double)f;
        entity.motionY += (double)f1;
        entity.motionZ += (double)f2;
        entity.worldObj.spawnEntityInWorld((Entity)entity);
    }

    public static boolean itemStackMatchesOredict(ItemStack stack, String oredict) {
        int[] ids;
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)i);
            if (!name.equals(oredict)) continue;
            return true;
        }
        return false;
    }

    public static NBTTagCompound getNBTTag(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            stack.stackTagCompound = new NBTTagCompound();
        }
        return stack.stackTagCompound;
    }

    public static String getDurabilityString(ItemStack item) {
        if (item == null) {
            return null;
        }
        return EnderCore.lang.localize("tooltip.durability") + " " + (item.getMaxDamage() - item.getItemDamage()) + "/" + item.getMaxDamage();
    }

    public static NBTTagCompound getOrCreateNBT(ItemStack stack) {
        if (stack.stackTagCompound == null) {
            stack.stackTagCompound = new NBTTagCompound();
        }
        return stack.stackTagCompound;
    }

    public static int doInsertItem(Object into, ItemStack item, ForgeDirection side) {
        if (into == null || item == null) {
            return 0;
        }
        if (into instanceof ISidedInventory) {
            return ItemUtil.doInsertItemInv((IInventory)((ISidedInventory)into), item, side, true);
        }
        if (into instanceof IInventory) {
            return ItemUtil.doInsertItemInv(ItemUtil.getInventory((IInventory)into), item, side, true);
        }
        if (into instanceof IItemDuct) {
            return ItemUtil.doInsertItem((IItemDuct)into, item, side);
        }
        for (IItemReceptor rec : receptors) {
            if (!rec.canInsertIntoObject(into, side)) continue;
            return rec.doInsertItem(into, item, side);
        }
        return 0;
    }

    public static int doInsertItem(IItemDuct con, ItemStack item, ForgeDirection inventorySide) {
        int startedWith = item.stackSize;
        ItemStack remaining = con.insertItem(inventorySide, item);
        if (remaining == null) {
            return startedWith;
        }
        return startedWith - remaining.stackSize;
    }

    public static int doInsertItem(IInventory inv, int startSlot, int endSlot, ItemStack item) {
        return ItemUtil.doInsertItemInv(inv, null, invSlotter.getInstance(startSlot, endSlot), item, ForgeDirection.UNKNOWN, true);
    }

    public static int doInsertItem(IInventory inv, int startSlot, int endSlot, ItemStack item, boolean doInsert) {
        return ItemUtil.doInsertItemInv(inv, null, invSlotter.getInstance(startSlot, endSlot), item, ForgeDirection.UNKNOWN, doInsert);
    }

    private static int doInsertItemInv(IInventory inv, ItemStack item, ForgeDirection inventorySide, boolean doInsert) {
        ISlotIterator slots;
        ISidedInventory sidedInv;
        ISidedInventory iSidedInventory = sidedInv = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        if (sidedInv != null) {
            if (inventorySide == null) {
                inventorySide = ForgeDirection.UNKNOWN;
            }
            slots = sidedSlotter.getInstance(sidedInv.getAccessibleSlotsFromSide(inventorySide.ordinal()));
        } else {
            slots = invSlotter.getInstance(0, inv.getSizeInventory());
        }
        return ItemUtil.doInsertItemInv(inv, sidedInv, slots, item, inventorySide, doInsert);
    }

    private static int doInsertItemInv(IInventory inv, ISidedInventory sidedInv, ISlotIterator slots, ItemStack item, ForgeDirection inventorySide, boolean doInsert) {
        int numInserted = 0;
        int numToInsert = item.stackSize;
        int firstFreeSlot = -1;
        while (numToInsert > 0 && slots.hasNext()) {
            int slot = slots.nextSlot();
            if (sidedInv != null && !sidedInv.canInsertItem(slot, item, inventorySide.ordinal())) continue;
            ItemStack contents = inv.getStackInSlot(slot);
            if (contents != null) {
                int freeSpace;
                if (!ItemUtil.areStackMergable(contents, item) || (freeSpace = Math.min(inv.getInventoryStackLimit(), contents.getMaxStackSize()) - contents.stackSize) <= 0) continue;
                int noToInsert = Math.min(numToInsert, freeSpace);
                ItemStack toInsert = item.copy();
                toInsert.stackSize = contents.stackSize + noToInsert;
                if (sidedInv == null && !inv.isItemValidForSlot(slot, toInsert)) continue;
                numInserted += noToInsert;
                numToInsert -= noToInsert;
                if (!doInsert) continue;
                inv.setInventorySlotContents(slot, toInsert);
                continue;
            }
            if (firstFreeSlot != -1) continue;
            firstFreeSlot = slot;
        }
        if (numToInsert > 0 && firstFreeSlot != -1) {
            ItemStack toInsert = item.copy();
            toInsert.stackSize = ItemUtil.min(numToInsert, inv.getInventoryStackLimit(), toInsert.getMaxStackSize());
            if (sidedInv != null || inv.isItemValidForSlot(firstFreeSlot, toInsert)) {
                numInserted += toInsert.stackSize;
                numToInsert -= toInsert.stackSize;
                if (doInsert) {
                    inv.setInventorySlotContents(firstFreeSlot, toInsert);
                }
            }
        }
        if (numInserted > 0 && doInsert) {
            inv.markDirty();
        }
        return numInserted;
    }

    private static final int min(int i1, int i2, int i3) {
        return i1 < i2 ? (i1 < i3 ? i1 : i3) : (i2 < i3 ? i2 : i3);
    }

    public static boolean isStackFull(ItemStack contents) {
        if (contents == null) {
            return false;
        }
        return contents.stackSize >= contents.getMaxStackSize();
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest neighbour = null;
            boolean reverse = false;
            if (chest.adjacentChestXNeg != null) {
                neighbour = chest.adjacentChestXNeg;
                reverse = true;
            } else if (chest.adjacentChestXPos != null) {
                neighbour = chest.adjacentChestXPos;
            } else if (chest.adjacentChestZNeg != null) {
                neighbour = chest.adjacentChestZNeg;
                reverse = true;
            } else if (chest.adjacentChestZPos != null) {
                neighbour = chest.adjacentChestZPos;
            }
            if (neighbour != null) {
                if (reverse) {
                    return new InventoryLargeChest("", (IInventory)neighbour, inv);
                }
                return new InventoryLargeChest("", inv, (IInventory)neighbour);
            }
        }
        return inv;
    }

    public static boolean areStackMergable(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null || !s1.isStackable() || !s2.isStackable()) {
            return false;
        }
        if (!s1.isItemEqual(s2)) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)s1, (ItemStack)s2);
    }

    public static boolean areStacksEqual(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!s1.isItemEqual(s2)) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)s1, (ItemStack)s2);
    }

    static {
        block2: {
            receptors = new ArrayList<IItemReceptor>();
            rand = new Random();
            try {
                Class.forName("crazypants.util.BuildcraftUtil");
            }
            catch (Exception e) {
                if (!Loader.isModLoaded((String)"BuildCraft|Transport")) break block2;
                Log.warn("ItemUtil: Could not register Build Craft pipe handler. Machines will not be able to output to BC pipes.");
            }
        }
    }

    private static final class sidedSlotter
    implements ISlotIterator {
        private static final sidedSlotter me = new sidedSlotter();
        private int[] slots;
        private int current;

        private sidedSlotter() {
        }

        public static final sidedSlotter getInstance(int[] slots) {
            sidedSlotter.me.slots = slots;
            sidedSlotter.me.current = 0;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.slots[this.current++];
        }

        @Override
        public final boolean hasNext() {
            return this.slots != null && this.current < this.slots.length;
        }
    }

    private static final class invSlotter
    implements ISlotIterator {
        private static final invSlotter me = new invSlotter();
        private int end;
        private int current;

        private invSlotter() {
        }

        public static final invSlotter getInstance(int start, int end) {
            invSlotter.me.end = end;
            invSlotter.me.current = start;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.current++;
        }

        @Override
        public final boolean hasNext() {
            return this.current < this.end;
        }
    }

    private static interface ISlotIterator {
        public int nextSlot();

        public boolean hasNext();
    }
}

