/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.api.common.util.IFluidReceptor;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidUtil {
    public static final List<IFluidReceptor> fluidReceptors;

    public static Map<ForgeDirection, IFluidHandler> getNeighbouringFluidHandlers(IBlockAccess world, BlockCoord bc) {
        HashMap<ForgeDirection, IFluidHandler> res = new HashMap<ForgeDirection, IFluidHandler>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IFluidHandler fh = FluidUtil.getFluidHandler(world, bc.getLocation(dir));
            if (fh == null) continue;
            res.put(dir, fh);
        }
        return res;
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockCoord bc) {
        return FluidUtil.getFluidHandler(world, bc.x, bc.y, bc.z);
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        return FluidUtil.getFluidHandler(te);
    }

    public static IFluidHandler getFluidHandler(TileEntity te) {
        if (te instanceof IFluidHandler) {
            IFluidHandler res = (IFluidHandler)te;
            for (IFluidReceptor rec : fluidReceptors) {
                if (rec.isValidReceptor(res)) continue;
                return null;
            }
            return res;
        }
        return null;
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (stack != null) {
            Fluid fluid;
            FluidStack fluidStack = null;
            if (stack.getItem() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.getItem()).getFluid(stack);
            }
            if (fluidStack == null) {
                fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (fluidStack == null && Block.getBlockFromItem((Item)stack.getItem()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.getBlockFromItem((Item)stack.getItem())).getFluid()) != null) {
                return new FluidStack(fluid, 1000);
            }
            return fluidStack;
        }
        return null;
    }

    public static boolean doPull(IFluidHandler into, ForgeDirection fromDir, int maxVolume) {
        FluidTankInfo[] infos;
        TileEntity te = (TileEntity)into;
        BlockCoord loc = new BlockCoord(te).getLocation(fromDir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)te.getWorldObj(), loc);
        if (target != null && (infos = target.getTankInfo(fromDir.getOpposite())) != null) {
            for (FluidTankInfo info : infos) {
                int filled;
                if (info.fluid == null || info.fluid.amount <= 0 || !into.canFill(fromDir, info.fluid.getFluid())) continue;
                FluidStack canPull = info.fluid.copy();
                canPull.amount = Math.min(maxVolume, canPull.amount);
                FluidStack drained = target.drain(fromDir.getOpposite(), canPull, false);
                if (drained == null || drained.amount <= 0 || (filled = into.fill(fromDir, drained, false)) <= 0) continue;
                drained = target.drain(fromDir.getOpposite(), filled, true);
                into.fill(fromDir, drained, true);
                return true;
            }
        }
        return false;
    }

    public static boolean doPush(IFluidHandler from, ForgeDirection fromDir, int maxVolume) {
        TileEntity te = (TileEntity)from;
        BlockCoord loc = new BlockCoord(te).getLocation(fromDir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)te.getWorldObj(), loc);
        if (target == null) {
            return false;
        }
        FluidTankInfo[] infos = from.getTankInfo(fromDir);
        boolean res = false;
        if (infos != null) {
            for (FluidTankInfo info : infos) {
                FluidStack maxDrain;
                FluidStack canDrain;
                if (info.fluid == null || info.fluid.amount <= 0 || !from.canDrain(fromDir, info.fluid.getFluid()) || (canDrain = from.drain(fromDir, maxDrain = new FluidStack(info.fluid, maxVolume), false)) == null || canDrain.amount <= 0) continue;
                int filled = target.fill(fromDir.getOpposite(), canDrain, true);
                from.drain(fromDir, new FluidStack(info.fluid, filled), true);
                res |= true;
            }
        }
        return res;
    }

    public static FluidAndStackResult tryFillContainer(ItemStack target, FluidStack source) {
        if (target != null && target.getItem() != null && source != null && source.getFluid() != null && source.amount > 0) {
            FluidStack resultFluid;
            if (target.getItem() instanceof IFluidContainerItem) {
                ItemStack resultStack = target.copy();
                resultStack.stackSize = 1;
                int amount = ((IFluidContainerItem)target.getItem()).fill(resultStack, source, true);
                if (amount <= 0) {
                    return new FluidAndStackResult(null, null, target, source);
                }
                FluidStack resultFluid2 = source.copy();
                resultFluid2.amount = amount;
                ItemStack remainderStack = target.copy();
                --remainderStack.stackSize;
                if (remainderStack.stackSize <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = source.copy();
                remainderFluid.amount -= amount;
                if (remainderFluid.amount <= 0) {
                    remainderFluid = null;
                }
                return new FluidAndStackResult(resultStack, resultFluid2, remainderStack, remainderFluid);
            }
            ItemStack resultStack = FluidContainerRegistry.fillFluidContainer((FluidStack)source.copy(), (ItemStack)target);
            if (resultStack != null && (resultFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)resultStack)) != null) {
                ItemStack remainderStack = target.copy();
                --remainderStack.stackSize;
                if (remainderStack.stackSize <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = source.copy();
                remainderFluid.amount -= resultFluid.amount;
                if (remainderFluid.amount <= 0) {
                    remainderFluid = null;
                }
                return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
            }
        }
        return new FluidAndStackResult(null, null, target, source);
    }

    public static FluidAndStackResult tryDrainContainer(ItemStack source, FluidStack target, int capacity) {
        if (source != null && source.getItem() != null) {
            int maxDrain = capacity - (target != null ? target.amount : 0);
            if (source.getItem() instanceof IFluidContainerItem) {
                ItemStack resultStack = source.copy();
                resultStack.stackSize = 1;
                FluidStack resultFluid = ((IFluidContainerItem)source.getItem()).drain(resultStack, maxDrain, true);
                if (resultFluid == null || resultFluid.amount <= 0 || target != null && resultFluid.getFluid() != target.getFluid()) {
                    return new FluidAndStackResult(null, null, source, target);
                }
                ItemStack remainderStack = source.copy();
                --remainderStack.stackSize;
                if (remainderStack.stackSize <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid, 0);
                remainderFluid.amount += resultFluid.amount;
                return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
            }
            FluidStack resultFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)source);
            if (resultFluid != null && resultFluid.amount > 0 && resultFluid.amount <= maxDrain && (target == null || resultFluid.isFluidEqual(target))) {
                ItemStack resultStack = source.getItem().getContainerItem(source);
                ItemStack remainderStack = source.copy();
                --remainderStack.stackSize;
                if (remainderStack.stackSize <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid, 0);
                remainderFluid.amount += resultFluid.amount;
                return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
            }
        }
        return new FluidAndStackResult(null, null, source, target);
    }

    public static FluidAndStackResult tryDrainContainer(ItemStack source, ITankAccess tank) {
        if (source != null && source.getItem() != null) {
            FluidStack resultFluid;
            FluidTank targetTank;
            if (source.getItem() instanceof IFluidContainerItem) {
                FluidStack fluid = ((IFluidContainerItem)source.getItem()).getFluid(source);
                FluidTank fluidTank = targetTank = fluid != null ? tank.getInputTank(fluid) : null;
                if (targetTank != null) {
                    FluidStack target = targetTank.getFluid();
                    int maxDrain = targetTank.getCapacity() - (target != null ? target.amount : 0);
                    ItemStack resultStack = source.copy();
                    resultStack.stackSize = 1;
                    FluidStack resultFluid2 = ((IFluidContainerItem)source.getItem()).drain(resultStack, maxDrain, true);
                    if (resultFluid2 == null || resultFluid2.amount <= 0 || target != null && !resultFluid2.isFluidEqual(target)) {
                        return new FluidAndStackResult(null, null, source, target);
                    }
                    ItemStack remainderStack = source.copy();
                    --remainderStack.stackSize;
                    if (remainderStack.stackSize <= 0) {
                        remainderStack = null;
                    }
                    FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid2, 0);
                    remainderFluid.amount += resultFluid2.amount;
                    return new FluidAndStackResult(resultStack, resultFluid2, remainderStack, remainderFluid);
                }
            }
            if ((resultFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)source)) != null && resultFluid.amount > 0 && (targetTank = tank.getInputTank(resultFluid)) != null) {
                FluidStack target = targetTank.getFluid();
                int maxDrain = targetTank.getCapacity() - (target != null ? target.amount : 0);
                if (resultFluid.amount <= maxDrain && (target == null || resultFluid.isFluidEqual(target))) {
                    ItemStack resultStack = source.getItem().getContainerItem(source);
                    ItemStack remainderStack = source.copy();
                    --remainderStack.stackSize;
                    if (remainderStack.stackSize <= 0) {
                        remainderStack = null;
                    }
                    FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid, 0);
                    remainderFluid.amount += resultFluid.amount;
                    return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
                }
            }
        }
        return new FluidAndStackResult(null, null, source, null);
    }

    public static boolean fillPlayerHandItemFromInternalTank(World world, int x, int y, int z, EntityPlayer entityPlayer, ITankAccess tank) {
        for (FluidTank subTank : tank.getOutputTanks()) {
            FluidAndStackResult fill = FluidUtil.tryFillContainer(entityPlayer.inventory.getCurrentItem(), subTank.getFluid());
            if (fill.result.fluidStack == null) continue;
            subTank.setFluid(fill.remainder.fluidStack);
            tank.setTanksDirty();
            if (!entityPlayer.capabilities.isCreativeMode) {
                int i;
                if (fill.remainder.itemStack == null) {
                    entityPlayer.inventory.setInventorySlotContents(entityPlayer.inventory.currentItem, fill.result.itemStack);
                    return true;
                }
                entityPlayer.inventory.setInventorySlotContents(entityPlayer.inventory.currentItem, fill.remainder.itemStack);
                if (fill.result.itemStack.isStackable()) {
                    for (i = 0; i < entityPlayer.inventory.mainInventory.length; ++i) {
                        ItemStack inventoryItem = entityPlayer.inventory.mainInventory[i];
                        if (!ItemUtil.areStackMergable(inventoryItem, fill.result.itemStack) || inventoryItem.stackSize >= inventoryItem.getMaxStackSize()) continue;
                        fill.result.itemStack.stackSize += inventoryItem.stackSize;
                        entityPlayer.inventory.setInventorySlotContents(i, fill.result.itemStack);
                        return true;
                    }
                }
                for (i = 0; i < entityPlayer.inventory.mainInventory.length; ++i) {
                    if (entityPlayer.inventory.mainInventory[i] != null) continue;
                    entityPlayer.inventory.setInventorySlotContents(i, fill.result.itemStack);
                    return true;
                }
                if (!world.isRemote) {
                    double x0 = ((double)x + entityPlayer.posX) / 2.0;
                    double y0 = ((double)y + entityPlayer.posY) / 2.0 + 0.5;
                    double z0 = ((double)z + entityPlayer.posZ) / 2.0;
                    Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean fillInternalTankFromPlayerHandItem(World world, int x, int y, int z, EntityPlayer entityPlayer, ITankAccess tank) {
        FluidAndStackResult fill = FluidUtil.tryDrainContainer(entityPlayer.inventory.getCurrentItem(), tank);
        if (fill.result.fluidStack == null) {
            return false;
        }
        tank.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        tank.setTanksDirty();
        if (!entityPlayer.capabilities.isCreativeMode) {
            int i;
            if (fill.remainder.itemStack == null) {
                entityPlayer.inventory.setInventorySlotContents(entityPlayer.inventory.currentItem, fill.result.itemStack);
                return true;
            }
            entityPlayer.inventory.setInventorySlotContents(entityPlayer.inventory.currentItem, fill.remainder.itemStack);
            if (fill.result.itemStack == null) {
                return true;
            }
            if (fill.result.itemStack.isStackable()) {
                for (i = 0; i < entityPlayer.inventory.mainInventory.length; ++i) {
                    ItemStack inventoryItem = entityPlayer.inventory.mainInventory[i];
                    if (!ItemUtil.areStackMergable(inventoryItem, fill.result.itemStack) || inventoryItem.stackSize >= inventoryItem.getMaxStackSize()) continue;
                    fill.result.itemStack.stackSize += inventoryItem.stackSize;
                    entityPlayer.inventory.setInventorySlotContents(i, fill.result.itemStack);
                    return true;
                }
            }
            for (i = 0; i < entityPlayer.inventory.mainInventory.length; ++i) {
                if (entityPlayer.inventory.mainInventory[i] != null) continue;
                entityPlayer.inventory.setInventorySlotContents(i, fill.result.itemStack);
                return true;
            }
            if (!world.isRemote) {
                double x0 = ((double)x + entityPlayer.posX) / 2.0;
                double y0 = ((double)y + entityPlayer.posY) / 2.0 + 0.5;
                double z0 = ((double)z + entityPlayer.posZ) / 2.0;
                Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
            }
        }
        return true;
    }

    static {
        block2: {
            fluidReceptors = new ArrayList<IFluidReceptor>();
            try {
                Class.forName("crazypants.util.BuildcraftUtil");
            }
            catch (Exception e) {
                if (!Loader.isModLoaded((String)"BuildCraft|Transport")) break block2;
                Log.warn("ItemUtil: Could not register Build Craft pipe handler. Fluid conduits will show connections to all Build Craft pipes.");
            }
        }
    }

    public static class FluidAndStackResult {
        public final FluidAndStack result;
        public final FluidAndStack remainder;

        public FluidAndStackResult(FluidAndStack result, FluidAndStack remainder) {
            this.result = result;
            this.remainder = remainder;
        }

        public FluidAndStackResult(FluidStack fluidStackResult, ItemStack itemStackResult, FluidStack fluidStackRemainder, ItemStack itemStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }

        public FluidAndStackResult(ItemStack itemStackResult, FluidStack fluidStackResult, ItemStack itemStackRemainder, FluidStack fluidStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }
    }

    public static class FluidAndStack {
        public final FluidStack fluidStack;
        public final ItemStack itemStack;

        public FluidAndStack(FluidStack fluidStack, ItemStack itemStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }

        public FluidAndStack(ItemStack itemStack, FluidStack fluidStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }
    }
}

