/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class PacketGhostSlot
extends MessageTileEntity<TileEntityEnder> {
    private int slot;
    private ItemStack stack;

    public PacketGhostSlot() {
    }

    private PacketGhostSlot(TileEntityEnder tile) {
        super(tile);
    }

    public static PacketGhostSlot setGhostSlotContents(TileEntityEnder te, int slot, ItemStack stack) {
        PacketGhostSlot msg = new PacketGhostSlot(te);
        msg.slot = slot;
        msg.stack = stack;
        return msg;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.slot = buf.readShort();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<PacketGhostSlot, IMessage> {
        public IMessage onMessage(PacketGhostSlot msg, MessageContext ctx) {
            TileEntityEnder te = (TileEntityEnder)((Object)msg.getTileEntity(ctx.getServerHandler().playerEntity.worldObj));
            if (te != null) {
                te.setGhostSlotContents(msg.slot, msg.stack);
                te.getWorldObj().markBlockForUpdate(msg.x, msg.y, msg.z);
            }
            return null;
        }
    }
}

