/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.enchant;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.enchant.IAdvancedEnchant;
import com.enderio.core.common.config.ConfigHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class EnchantXPBoost
extends Enchantment
implements IAdvancedEnchant {
    public static final EnchantXPBoost INSTANCE = new EnchantXPBoost(ConfigHandler.enchantIDXPBoost);

    private EnchantXPBoost(int id) {
        super(id, 2, EnumEnchantmentType.breakable);
    }

    public int getMaxEnchantability(int level) {
        return super.getMaxEnchantability(level) + 30;
    }

    public int getMinEnchantability(int level) {
        return super.getMinEnchantability(level);
    }

    public int getMaxLevel() {
        return 3;
    }

    public boolean canApply(ItemStack stack) {
        return this.type.canEnchantItem(stack.getItem()) && !(stack.getItem() instanceof ItemArmor);
    }

    public String getName() {
        return "enchantment.xpboost";
    }

    public boolean isAllowedOnBooks() {
        return ConfigHandler.allowXPBoost;
    }

    @Override
    public String[] getTooltipDetails(ItemStack stack) {
        return new String[]{EnderCore.lang.localize("enchantment.xpboost.tooltip", false)};
    }

    public void register() {
        if (ConfigHandler.allowXPBoost) {
            FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:enchanter", (String)"<enchantment name=\"enchantment.xpboost\" costPerLevel=\"4\">\n<itemStack oreDictionary=\"ingotGold\" number=\"16\"/>\n</enchantment>");
        } else {
            Enchantment.enchantmentsList[this.effectId] = null;
        }
    }
}

