/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.GhostSlotHandler;
import com.enderio.core.client.gui.ToolTipManager;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.gui.widget.VScrollbar;
import com.enderio.core.client.render.RenderUtil;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Timer;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Optional.InterfaceList(value={@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")})
public abstract class GuiContainerBase
extends GuiContainer
implements ToolTipManager.ToolTipRenderer,
IGuiScreen,
INEIGuiHandler {
    protected ToolTipManager ttMan = new ToolTipManager();
    protected List<IGuiOverlay> overlays = Lists.newArrayList();
    protected List<TextFieldEnder> textFields = Lists.newArrayList();
    protected List<VScrollbar> scrollbars = Lists.newArrayList();
    protected GhostSlotHandler ghostSlotHandler = new GhostSlotHandler();
    @Deprecated
    protected List<GhostSlot> ghostSlots = this.ghostSlotHandler.getGhostSlots();
    @Deprecated
    protected GhostSlot hoverGhostSlot;
    protected VScrollbar draggingScrollbar;
    private int realMx;
    private int realMy;

    protected GuiContainerBase(Container par1Container) {
        super(par1Container);
    }

    public void initGui() {
        super.initGui();
        this.fixupGuiPosition();
        for (IGuiOverlay overlay : this.overlays) {
            overlay.init(this);
        }
        for (TextFieldEnder f : this.textFields) {
            f.init(this);
        }
    }

    protected void fixupGuiPosition() {
    }

    protected void keyTyped(char c, int key) {
        TextFieldEnder focused = null;
        for (TextFieldEnder f : this.textFields) {
            if (!f.isFocused()) continue;
            focused = f;
        }
        if (key == 1) {
            if (focused != null && key == 1) {
                focused.setFocused(false);
                focused = null;
                return;
            }
            if (!this.hideOverlays()) {
                this.mc.thePlayer.closeScreen();
                return;
            }
        }
        if (c == '\t') {
            for (int i = 0; i < this.textFields.size(); ++i) {
                TextFieldEnder f;
                f = this.textFields.get(i);
                if (!f.isFocused()) continue;
                this.textFields.get((i + 1) % this.textFields.size()).setFocused(true);
                f.setFocused(false);
                return;
            }
        }
        if (focused != null) {
            String old = focused.getText();
            if (focused.textboxKeyTyped(c, key)) {
                this.onTextFieldChanged(focused, old);
                return;
            }
        }
        if (c == 'f' && focused == null && !this.textFields.isEmpty()) {
            focused = this.textFields.get(0);
            focused.setFocused(true);
        }
        if (key == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            if (!this.hideOverlays()) {
                this.mc.thePlayer.closeScreen();
            }
            return;
        }
        super.keyTyped(c, key);
    }

    protected final void setText(TextFieldEnder tf, String newText) {
        String old = tf.getText();
        tf.setText(newText);
        this.onTextFieldChanged(tf, old);
    }

    protected void onTextFieldChanged(TextFieldEnder tf, String old) {
    }

    public boolean hideOverlays() {
        for (IGuiOverlay overlay : this.overlays) {
            if (!overlay.isVisible()) continue;
            overlay.setVisible(false);
            return true;
        }
        return false;
    }

    @Override
    public void addToolTip(GuiToolTip toolTip) {
        this.ttMan.addToolTip(toolTip);
    }

    public void updateScreen() {
        super.updateScreen();
        if (!ForgeHooks.canInteractWith((EntityPlayer)this.mc.thePlayer, (Container)this.inventorySlots)) {
            this.mc.thePlayer.closeScreen();
        }
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.updateCursorCounter();
        }
    }

    public void handleMouseInput() {
        int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        int b = Mouse.getEventButton();
        for (IGuiOverlay overlay : this.overlays) {
            if (overlay == null || !overlay.isVisible() || !overlay.handleMouseInput(x, y, b)) continue;
            return;
        }
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            this.mouseWheel(x, y, delta);
        }
        super.handleMouseInput();
    }

    protected boolean func_146978_c(int p_146978_1_, int p_146978_2_, int p_146978_3_, int p_146978_4_, int p_146978_5_, int p_146978_6_) {
        int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        for (IGuiOverlay overlay : this.overlays) {
            if (overlay == null || !overlay.isVisible() || !overlay.isMouseInBounds(x, y)) continue;
            return false;
        }
        return super.func_146978_c(p_146978_1_, p_146978_2_, p_146978_3_, p_146978_4_, p_146978_5_, p_146978_6_);
    }

    @Override
    public List<GhostSlot> getGhostSlots() {
        return this.ghostSlotHandler.getGhostSlots();
    }

    @Deprecated
    protected void ghostSlotClicked(GhostSlot slot, int x, int y, int button) {
        this.ghostSlotHandler.ghostSlotClicked(this, slot, x, y, button);
    }

    protected void mouseClicked(int x, int y, int button) {
        GhostSlot slot;
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.mouseClicked(x, y, button);
        }
        if (!this.scrollbars.isEmpty()) {
            if (this.draggingScrollbar != null) {
                this.draggingScrollbar.mouseClicked(x, y, button);
                return;
            }
            for (VScrollbar vScrollbar : this.scrollbars) {
                if (!vScrollbar.mouseClicked(x, y, button)) continue;
                this.draggingScrollbar = vScrollbar;
                return;
            }
        }
        if (!this.ghostSlotHandler.getGhostSlots().isEmpty() && (slot = this.getGhostSlot(x, y)) != null) {
            this.ghostSlotClicked(slot, x, y, button);
            return;
        }
        if (button == 1) {
            for (TextFieldEnder textFieldEnder : this.textFields) {
                if (!textFieldEnder.contains(x, y)) continue;
                this.setText(textFieldEnder, "");
            }
        }
        if (button >= 1) {
            for (Object object : this.buttonList) {
                IconButton btn;
                if (!(object instanceof IconButton) || !(btn = (IconButton)((Object)object)).mousePressedButton(this.mc, x, y, button)) continue;
                btn.func_146113_a(this.mc.getSoundHandler());
                this.actionPerformedButton(btn, button);
            }
        }
        super.mouseClicked(x, y, button);
    }

    protected void mouseMovedOrUp(int x, int y, int button) {
        if (this.draggingScrollbar != null) {
            this.draggingScrollbar.mouseMovedOrUp(x, y, button);
            this.draggingScrollbar = null;
        }
        super.mouseMovedOrUp(x, y, button);
    }

    protected void mouseClickMove(int x, int y, int button, long time) {
        if (this.draggingScrollbar != null) {
            this.draggingScrollbar.mouseClickMove(x, y, button, time);
            return;
        }
        super.mouseClickMove(x, y, button, time);
    }

    protected void mouseWheel(int x, int y, int delta) {
        GhostSlot slot;
        if (!this.scrollbars.isEmpty()) {
            for (VScrollbar vs : this.scrollbars) {
                vs.mouseWheel(x, y, delta);
            }
        }
        if (!this.ghostSlotHandler.getGhostSlots().isEmpty() && (slot = this.getGhostSlot(x, y)) != null) {
            this.ghostSlotClicked(slot, x, y, delta < 0 ? -1 : -2);
        }
    }

    protected void actionPerformedButton(IconButton btn, int mouseButton) {
        this.actionPerformed(btn);
    }

    public void addOverlay(IGuiOverlay overlay) {
        this.overlays.add(overlay);
    }

    public void removeOverlay(IGuiOverlay overlay) {
        this.overlays.remove(overlay);
    }

    public void addScrollbar(VScrollbar vs) {
        this.scrollbars.add(vs);
        vs.adjustPosition();
    }

    public void removeScrollbar(VScrollbar vs) {
        this.scrollbars.remove(vs);
        if (this.draggingScrollbar == vs) {
            this.draggingScrollbar = null;
        }
    }

    protected final void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.drawForegroundImpl(mouseX, mouseY);
        Timer t = RenderUtil.getTimer();
        if (t != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            for (IGuiOverlay overlay : this.overlays) {
                if (overlay == null || !overlay.isVisible()) continue;
                overlay.draw(this.realMx, this.realMy, t.renderPartialTicks);
            }
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int mouseX, int mouseY) {
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.drawTextBox();
        }
        if (!this.scrollbars.isEmpty()) {
            for (VScrollbar vScrollbar : this.scrollbars) {
                vScrollbar.drawScrollbar(mouseX, mouseY);
            }
        }
        if (!this.ghostSlotHandler.getGhostSlots().isEmpty()) {
            this.drawGhostSlots(mouseX, mouseY);
        }
    }

    public void drawScreen(int par1, int par2, float par3) {
        int mx = this.realMx = par1;
        int my = this.realMy = par2;
        super.drawScreen(mx, my, par3);
        if (this.draggingScrollbar == null) {
            this.ghostSlotHandler.drawGhostSlotToolTip(this, par1, par2);
            this.ttMan.drawTooltips(this, par1, par2);
        }
    }

    protected void drawItemStack(ItemStack stack, int mouseX, int mouseY, String str) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.zLevel = 200.0f;
        GuiContainerBase.itemRender.zLevel = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.getItem().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.fontRendererObj;
        }
        itemRender.renderItemAndEffectIntoGUI(font, this.mc.getTextureManager(), stack, mouseX, mouseY);
        itemRender.renderItemOverlayIntoGUI(font, this.mc.getTextureManager(), stack, mouseX, mouseY, str);
        this.zLevel = 0.0f;
        GuiContainerBase.itemRender.zLevel = 0.0f;
    }

    protected void drawFakeItemsStart() {
        this.zLevel = 0.0f;
        GuiContainerBase.itemRender.zLevel = -25.0f;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        RenderHelper.enableGUIStandardItemLighting();
    }

    protected void drawFakeItemStack(int x, int y, ItemStack stack) {
        itemRender.renderItemAndEffectIntoGUI(this.fontRendererObj, this.mc.renderEngine, stack, x, y);
    }

    protected void drawFakeItemStackStdOverlay(int x, int y, ItemStack stack) {
        itemRender.renderItemOverlayIntoGUI(this.fontRendererObj, this.mc.renderEngine, stack, x, y, null);
    }

    protected void drawFakeItemHover(int x, int y) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.drawGradientRect(x, y, x + 16, y + 16, -2130706433, -2130706433);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    protected void drawFakeItemsEnd() {
        GL11.glPopAttrib();
        GuiContainerBase.itemRender.zLevel = 0.0f;
        this.zLevel = 0.0f;
    }

    public void renderToolTip(ItemStack p_146285_1_, int p_146285_2_, int p_146285_3_) {
        super.renderToolTip(p_146285_1_, p_146285_2_, p_146285_3_);
    }

    @Deprecated
    protected void drawGhostSlotTooltip(GhostSlot slot, int mouseX, int mouseY) {
        this.ghostSlotHandler.drawGhostSlotTooltip(this, slot, mouseX, mouseY);
    }

    protected String getGuiTexture() {
        return null;
    }

    @Deprecated
    protected void drawGhostSlots(int mouseX, int mouseY) {
        this.ghostSlotHandler.drawGhostSlots(this, mouseX, mouseY);
    }

    @Deprecated
    protected GhostSlot getGhostSlot(int mouseX, int mouseY) {
        return this.ghostSlotHandler.getGhostSlot(this, mouseX, mouseY);
    }

    @Override
    public boolean removeToolTip(GuiToolTip toolTip) {
        return this.ttMan.removeToolTip(toolTip);
    }

    protected void drawForegroundImpl(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        this.copyOfdrawHoveringText(par1List, par2, par3, font);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
    }

    protected void copyOfdrawHoveringText(List<String> par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.getStringWidth(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.width) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.height) {
                j1 = this.height - k1 - 6;
            }
            this.zLevel = 300.0f;
            int l1 = -267386864;
            this.drawGradientRect(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.drawGradientRect(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.drawGradientRect(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.drawGradientRect(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = par1List.get(k2);
                font.drawStringWithShadow(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.zLevel = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.enableStandardItemLighting();
            GL11.glEnable((int)32826);
        }
    }

    public float getZlevel() {
        return this.zLevel;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getYSize() {
        return this.ySize;
    }

    public void setGuiLeft(int i) {
        this.guiLeft = i;
    }

    public void setGuiTop(int i) {
        this.guiTop = i;
    }

    public void setXSize(int i) {
        this.xSize = i;
    }

    public void setYSize(int i) {
        this.ySize = i;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return Minecraft.getMinecraft().fontRenderer;
    }

    @Override
    public void addButton(GuiButton button) {
        if (!this.buttonList.contains(button)) {
            this.buttonList.add(button);
        }
    }

    @Override
    public void removeButton(GuiButton button) {
        this.buttonList.remove(button);
    }

    @Override
    public int getOverlayOffsetX() {
        return 0;
    }

    @Override
    public void doActionPerformed(GuiButton guiButton) {
        this.actionPerformed(guiButton);
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gc, VisiblityData vd) {
        return vd;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gc, ItemStack is) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gc) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gc, int i, int i1, ItemStack is, int i2) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gc, int x, int y, int w, int h) {
        return false;
    }
}

