/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.common.config.ConfigProcessor;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PacketConfigSync
implements IMessage {
    private Map<String, Object> configValues;
    private String modid;

    public PacketConfigSync() {
    }

    public PacketConfigSync(ConfigProcessor toSync) {
        this.configValues = toSync.configValues;
        this.modid = toSync.modid;
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        ObjectOutputStream objStream = new ObjectOutputStream(gzip);
        objStream.writeObject(this.configValues);
        objStream.close();
        buf.writeShort(obj.size());
        buf.writeBytes(obj.toByteArray());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modid);
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        byte[] compressedBody = new byte[len];
        for (short i = 0; i < len; i = (short)(i + 1)) {
            compressedBody[i] = buf.readByte();
        }
        ObjectInputStream obj = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(compressedBody)));
        this.configValues = (Map)obj.readObject();
        obj.close();
        this.modid = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketConfigSync, PacketConfigSync> {
        public PacketConfigSync onMessage(PacketConfigSync message, MessageContext ctx) {
            ConfigProcessor processor = ConfigProcessor.processorMap.get(message.modid);
            if (processor != null) {
                processor.syncTo(message.configValues);
            }
            return null;
        }
    }
}

