/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.Lang;
import com.enderio.core.common.network.EnderPacketHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public final class ChatUtil {
    private static final int DELETION_ID = 8675309;
    private static int lastAdded;

    private static void sendNoSpamMessages(IChatComponent[] messages) {
        int i;
        GuiNewChat chat = Minecraft.getMinecraft().ingameGUI.getChatGUI();
        for (i = 8675309 + messages.length - 1; i <= lastAdded; ++i) {
            chat.deleteChatLine(i);
        }
        for (i = 0; i < messages.length; ++i) {
            chat.printChatMessageWithOptionalDeletion(messages[i], 8675309 + i);
        }
        lastAdded = 8675309 + messages.length - 1;
    }

    public static IChatComponent wrap(String s) {
        return new ChatComponentText(s);
    }

    public static IChatComponent[] wrap(String ... s) {
        IChatComponent[] ret = new IChatComponent[s.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ChatUtil.wrap(s[i]);
        }
        return ret;
    }

    public static IChatComponent wrapFormatted(String s, Object ... args) {
        return new ChatComponentTranslation(s, args);
    }

    public static void sendChat(EntityPlayer player, String ... lines) {
        ChatUtil.sendChat(player, ChatUtil.wrap(lines));
    }

    public static void sendChatUnloc(EntityPlayer player, Lang lang, String ... unlocLines) {
        ChatUtil.sendChat(player, lang.localizeAll(lang, unlocLines));
    }

    public static void sendChat(EntityPlayer player, IChatComponent ... lines) {
        for (IChatComponent c : lines) {
            player.addChatComponentMessage(c);
        }
    }

    public static void sendNoSpamClientUnloc(Lang lang, String ... unlocLines) {
        ChatUtil.sendNoSpamClient(lang.localizeAll(lang, unlocLines));
    }

    public static void sendNoSpamClient(String ... lines) {
        ChatUtil.sendNoSpamClient(ChatUtil.wrap(lines));
    }

    public static void sendNoSpamClient(IChatComponent ... lines) {
        ChatUtil.sendNoSpamMessages(lines);
    }

    public static void sendNoSpamUnloc(EntityPlayer player, Lang lang, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, lang.localizeAll(lang, unlocLines));
    }

    public static void sendNoSpam(EntityPlayer player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(EntityPlayer player, IChatComponent ... lines) {
        if (player instanceof EntityPlayerMP) {
            ChatUtil.sendNoSpam((EntityPlayerMP)player, lines);
        }
    }

    public static void sendNoSpamUnloc(EntityPlayerMP player, Lang lang, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, lang.localizeAll(lang, unlocLines));
    }

    public static void sendNoSpam(EntityPlayerMP player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(EntityPlayerMP player, IChatComponent ... lines) {
        if (lines.length > 0) {
            EnderPacketHandler.INSTANCE.sendTo((IMessage)new PacketNoSpamChat(lines), player);
        }
    }

    private ChatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class PacketNoSpamChat
    implements IMessage {
        private IChatComponent[] chatLines;

        private PacketNoSpamChat(IChatComponent ... lines) {
            this.chatLines = lines;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.chatLines.length);
            for (IChatComponent c : this.chatLines) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)IChatComponent.Serializer.func_150696_a((IChatComponent)c));
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.chatLines = new IChatComponent[buf.readInt()];
            for (int i = 0; i < this.chatLines.length; ++i) {
                this.chatLines[i] = IChatComponent.Serializer.func_150699_a((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }

        public PacketNoSpamChat() {
        }

        public static class Handler
        implements IMessageHandler<PacketNoSpamChat, IMessage> {
            public IMessage onMessage(PacketNoSpamChat message, MessageContext ctx) {
                ChatUtil.sendNoSpamMessages(message.chatLines);
                return null;
            }
        }
    }
}

