/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.EnderCore;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;

public final class Handlers {
    private static final Set<String> packageSet = new HashSet<String>();
    private static Set<ASMDataTable.ASMData> annotations;
    private static boolean registered;

    public static void preInit(FMLPreInitializationEvent event) {
        annotations = event.getAsmData().getAll(Handler.class.getName());
    }

    @Deprecated
    public static void addPackage(String packageName) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new RuntimeException("This method must only be called in preinit");
        }
        EnderCore.logger.info("Adding package " + packageName + " to handler search.");
        packageSet.add(packageName);
    }

    public static void register(FMLInitializationEvent event) {
        if (registered) {
            throw new IllegalStateException("I warned you!");
        }
        for (ASMDataTable.ASMData data : annotations) {
            String className = data.getClassName();
            if (!className.contains("client") || FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                try {
                    Class<?> c = Class.forName(className);
                    Handler a = c.getAnnotation(Handler.class);
                    if (a == null) continue;
                    Handlers.registerHandler(c, data, a);
                }
                catch (Throwable t) {
                    EnderCore.logger.error(String.format("[Handlers] %s threw an error on load, skipping...", className));
                    t.printStackTrace();
                }
                continue;
            }
            EnderCore.logger.info(String.format("[Handlers] Skipping client class %s, we are on a dedicated server", className));
        }
        registered = true;
    }

    private static void registerHandler(Class<?> c, ASMDataTable.ASMData data, Handler handler) throws InstantiationException, IllegalAccessException {
        EnderCore.logger.info(String.format("[Handlers] Registering handler %s to busses: %s", c.getSimpleName(), Arrays.deepToString((Object[])handler.value())));
        Object inst = Handlers.tryInit(handler, c);
        Method[] methods = c.getDeclaredMethods();
        EnumSet<HandlerType> types = EnumSet.noneOf(HandlerType.class);
        block0: for (Method m : methods) {
            Class<?>[] params;
            if (!m.isAnnotationPresent(SubscribeEvent.class) || (params = m.getParameterTypes()).length < 1) continue;
            for (Class<?> param = params[0]; param != Event.class && param != null && param != Object.class; param = param.getSuperclass()) {
                for (HandlerType type : HandlerType.values()) {
                    if (!param.getName().contains(type.eventIdentifier)) continue;
                    types.add(type);
                    continue block0;
                }
            }
        }
        for (HandlerType type : types) {
            type.bus.register(inst);
        }
    }

    private static Object tryInit(Handler annot, Class<?> c) {
        Handler.Inst pref = annot.getInstFrom();
        if (pref.matches(Handler.Inst.CONSTRUCTOR)) {
            try {
                return c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pref.matches(Handler.Inst.FIELD)) {
            try {
                Field inst = c.getDeclaredField("INSTANCE");
                inst.setAccessible(true);
                return inst.get(null);
            }
            catch (Exception inst) {
                // empty catch block
            }
        }
        if (pref.matches(Handler.Inst.METHOD)) {
            try {
                Method inst = c.getDeclaredMethod("instance", new Class[0]);
                inst.setAccessible(true);
                return inst.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Could not instantiate @Handler class " + c.getName() + " or access INSTANCE field or instance() method.");
    }

    private Handlers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        registered = false;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Handler {
        @Deprecated
        public HandlerType[] value() default {HandlerType.FORGE, HandlerType.FML};

        public Inst getInstFrom() default Inst.AUTO;

        public static enum Inst {
            AUTO,
            CONSTRUCTOR,
            FIELD,
            METHOD;


            boolean matches(Inst other) {
                return this == AUTO || other == AUTO || other == this;
            }
        }

        @Deprecated
        public static enum HandlerType {
            FORGE,
            FML;

        }
    }

    public static enum HandlerType {
        FORGE_OREGEN("net.minecraftforge.event.terraingen.OreGenEvent", MinecraftForge.ORE_GEN_BUS),
        FORGE_TERRAIN("net.minecraftforge.event.terraingen", MinecraftForge.TERRAIN_GEN_BUS),
        FORGE("net.minecraftforge", MinecraftForge.EVENT_BUS),
        FML("cpw.mods.fml", FMLCommonHandler.instance().bus());

        public final String eventIdentifier;
        public final EventBus bus;

        private HandlerType(String eventIdentifier, EventBus bus) {
            this.eventIdentifier = eventIdentifier;
            this.bus = bus;
        }
    }
}

