/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.Log;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockEnder
extends Block {
    protected final Class<? extends TileEntityEnder> teClass;
    protected final String name;

    protected BlockEnder(String name, Class<? extends TileEntityEnder> teClass) {
        this(name, teClass, new Material(MapColor.ironColor));
    }

    protected BlockEnder(String name, Class<? extends TileEntityEnder> teClass, Material mat) {
        super(mat);
        this.teClass = teClass;
        this.name = name;
        this.setHardness(0.5f);
        this.setBlockName(name);
        this.setStepSound(Block.soundTypeMetal);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity(this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.teClass != null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.teClass != null) {
            try {
                TileEntityEnder te = this.teClass.newInstance();
                te.init();
                return te;
            }
            catch (Exception e) {
                Log.error("Could not create tile entity for block " + this.name + " for class " + this.teClass);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        this.blockIcon = iIconRegister.registerIcon("enderio:" + this.name);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (entityPlayer.isSneaking()) {
            return false;
        }
        if (te instanceof ITankAccess) {
            if (FluidUtil.fillInternalTankFromPlayerHandItem(world, x, y, z, entityPlayer, (ITankAccess)te)) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank(world, x, y, z, entityPlayer, (ITankAccess)te)) {
                return true;
            }
        }
        return this.openGui(world, x, y, z, entityPlayer, side);
    }

    protected boolean shouldWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return true;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.harvestBlock(world, player, x, y, z, meta);
        world.setBlockToAir(x, y, z);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.doNormalDrops(world, x, y, z)) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getNBTDrop(world, x, y, z, (TileEntityEnder)world.getTileEntity(x, y, z))});
    }

    public ItemStack getNBTDrop(World world, int x, int y, int z, TileEntityEnder te) {
        int meta = this.damageDropped(te.getBlockMetadata());
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        this.processDrop(world, x, y, z, te, itemStack);
        return itemStack;
    }

    protected void processDrop(World world, int x, int y, int z, @Nullable TileEntityEnder te, ItemStack drop) {
    }

    protected TileEntityEnder getTileEntityEio(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (this.teClass.isInstance(te)) {
            return (TileEntityEnder)te;
        }
        return null;
    }

    protected boolean shouldDoWorkThisTick(World world, int x, int y, int z, int interval) {
        TileEntityEnder te = this.getTileEntityEio((IBlockAccess)world, x, y, z);
        if (te == null) {
            return world.getTotalWorldTime() % (long)interval == 0L;
        }
        return te.shouldDoWorkThisTick(interval);
    }

    protected boolean shouldDoWorkThisTick(World world, int x, int y, int z, int interval, int offset) {
        TileEntityEnder te = this.getTileEntityEio((IBlockAccess)world, x, y, z);
        if (te == null) {
            return (world.getTotalWorldTime() + (long)offset) % (long)interval == 0L;
        }
        return te.shouldDoWorkThisTick(interval, offset);
    }

    public void setBlockBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void setBlockBounds(AxisAlignedBB bb) {
        this.setBlockBounds(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
    }
}

