/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.client.render.TechneUtil;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class SimpleModelRenderer
implements ISimpleBlockRenderingHandler {
    private final Tessellator tes = Tessellator.instance;
    private final WavefrontObject model;
    private final int renderId;

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        RenderHelper.disableStandardItemLighting();
        this.tes.startDrawingQuads();
        this.tes.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        TechneUtil.renderWithIcon(this.model, block.getIcon(0, metadata), this.tes);
        this.tes.draw();
        RenderHelper.enableStandardItemLighting();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.tes.setBrightness(block.getMixedBrightnessForBlock(world, x, y, z));
        this.tes.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        this.tes.addTranslation((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        TechneUtil.renderWithIcon(this.model, block.getIcon(0, world.getBlockMetadata(x, y, z)), this.tes);
        this.tes.addTranslation((float)(-x) - 0.5f, (float)(-y) - 0.5f, (float)(-z) - 0.5f);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    @ConstructorProperties(value={"model", "renderId"})
    public SimpleModelRenderer(WavefrontObject model, int renderId) {
        this.model = model;
        this.renderId = renderId;
    }

    public int getRenderId() {
        return this.renderId;
    }
}

