/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.api.recipes.ICraftingInventory;
import minetweaker.api.recipes.ICraftingRecipe;
import minetweaker.api.recipes.IRecipeAction;
import minetweaker.api.recipes.IRecipeFunction;
import minetweaker.api.recipes.IRecipeManager;
import minetweaker.api.recipes.ShapedRecipe;
import minetweaker.api.recipes.ShapelessRecipe;
import minetweaker.mc1710.item.MCItemStack;
import minetweaker.mc1710.recipes.RecipeConverter;
import minetweaker.mc1710.util.MineTweakerHacks;
import minetweaker.util.IEventHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.Optional;

public final class MCRecipeManager
implements IRecipeManager {
    public static final List<ActionBaseAddRecipe> recipesToAdd = new ArrayList<ActionBaseAddRecipe>();
    public static final List<ActionBaseRemoveRecipes> recipesToRemove = new ArrayList<ActionBaseRemoveRecipes>();
    public static final ActionRemoveRecipesNoIngredients actionRemoveRecipesNoIngredients = new ActionRemoveRecipesNoIngredients();
    public static List<IRecipe> recipes;
    public static final List<ICraftingRecipe> transformerRecipes;

    public MCRecipeManager() {
        MineTweakerImplementationAPI.onPostReload(new HandlePostReload());
    }

    public static boolean hasTransformerRecipes() {
        return transformerRecipes.size() > 0;
    }

    public static void applyTransformations(ICraftingInventory inventory, IPlayer byPlayer) {
        for (ICraftingRecipe recipe : transformerRecipes) {
            if (!recipe.matches(inventory)) continue;
            recipe.applyTransformers(inventory, byPlayer);
            return;
        }
    }

    private static boolean matches(Object input, IIngredient ingredient) {
        if (input == null != (ingredient == null)) {
            return false;
        }
        if (ingredient != null) {
            if (input instanceof ItemStack) {
                return ingredient.matches(MineTweakerMC.getIItemStack((ItemStack)input));
            }
            if (input instanceof String) {
                return ingredient.contains(MineTweakerMC.getOreDict((String)input));
            }
        }
        return true;
    }

    @Override
    public List<ICraftingRecipe> getAll() {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        for (IRecipe recipe : recipes) {
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe(recipe);
            results.add(converted);
        }
        return results;
    }

    @Override
    public List<ICraftingRecipe> getRecipesFor(IIngredient ingredient) {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        for (IRecipe recipe : recipes) {
            if (!ingredient.matches(MineTweakerMC.getIItemStack(recipe.getRecipeOutput()))) continue;
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe(recipe);
            results.add(converted);
        }
        return results;
    }

    @Override
    public void remove(IIngredient output, @Optional boolean nbtMatch) {
        if (output == null) {
            MineTweakerAPI.logError("Cannot remove recipes for a null item!");
            return;
        }
        actionRemoveRecipesNoIngredients.addOutput(output, nbtMatch);
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, false));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, true));
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, IRecipeFunction function, IRecipeAction action) {
        if (this.checkShapelessNulls(output, ingredients)) {
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(output, ingredients, function, action));
    }

    private boolean checkShapelessNulls(IItemStack output, IIngredient[] ingredients) {
        if (output != null && Arrays.stream(ingredients).allMatch(Objects::isNull)) {
            MineTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return true;
        }
        return false;
    }

    @Override
    public void removeShaped(IIngredient output, IIngredient[][] ingredients) {
        if (output == null) {
            MineTweakerAPI.logError("Cannot remove recipes for a null item!");
            return;
        }
        recipesToRemove.add(new ActionRemoveShapedRecipes(output, ingredients));
    }

    @Override
    public void removeShapeless(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
        if (output == null) {
            MineTweakerAPI.logError("Cannot remove recipes for a null item!");
            return;
        }
        recipesToRemove.add(new ActionRemoveShapelessRecipes(output, ingredients, wildcard));
    }

    @Override
    public IItemStack craft(IItemStack[][] contents) {
        ContainerVirtual container = new ContainerVirtual();
        int width = 0;
        int height = contents.length;
        for (IItemStack[] row : contents) {
            width = Math.max(width, row.length);
        }
        ItemStack[] iContents = new ItemStack[width * height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < contents[i].length; ++j) {
                if (contents[i][j] == null) continue;
                iContents[i * width + j] = MineTweakerMC.getItemStack(contents[i][j]);
            }
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)container, width, height);
        for (int i = 0; i < iContents.length; ++i) {
            inventory.setInventorySlotContents(i, iContents[i]);
        }
        ItemStack result = CraftingManager.getInstance().findMatchingRecipe(inventory, null);
        if (result == null) {
            return null;
        }
        return MineTweakerMC.getIItemStack(result);
    }

    static {
        transformerRecipes = new ArrayList<ICraftingRecipe>();
    }

    private class ContainerVirtual
    extends Container {
        private ContainerVirtual() {
        }

        public boolean canInteractWith(EntityPlayer var1) {
            return false;
        }
    }

    public static class HandlePostReload
    implements IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
        @Override
        public void handle(MineTweakerImplementationAPI.ReloadEvent event) {
            System.out.println("MineTweaker: Applying additions and removals");
            MineTweakerAPI.apply(actionRemoveRecipesNoIngredients);
            recipesToRemove.forEach(MineTweakerAPI::apply);
            recipesToAdd.forEach(MineTweakerAPI::apply);
        }
    }

    private static class ActionAddShapelessRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapelessRecipe(IItemStack output, IIngredient[] ingredients, IRecipeFunction function, IRecipeAction action) {
            super(new ShapelessRecipe(output, ingredients, function, action), output, false);
        }
    }

    private static class ActionAddShapedRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
            super(new ShapedRecipe(output, ingredients, function, action, mirrored), output, true);
        }
    }

    public static class ActionBaseAddRecipe
    implements IUndoableAction {
        private final IRecipe iRecipe;
        private final ICraftingRecipe craftingRecipe;
        protected final IItemStack output;
        protected final boolean isShaped;

        private ActionBaseAddRecipe(ICraftingRecipe craftingRecipe, IItemStack output, boolean isShaped) {
            this.iRecipe = RecipeConverter.convert(craftingRecipe);
            this.craftingRecipe = craftingRecipe;
            this.output = output;
            this.isShaped = isShaped;
        }

        @Override
        public void apply() {
            recipes.add(this.iRecipe);
            if (this.craftingRecipe.hasTransformers()) {
                transformerRecipes.add(this.craftingRecipe);
            }
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Adding " + (this.isShaped ? "shaped" : "shapeless") + " recipe for " + this.output.getDisplayName();
            }
            return "Trying to add " + (this.isShaped ? "shaped" : "shapeless") + "recipe without correct output";
        }

        @Override
        public String describeUndo() {
            return null;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class ActionRemoveShapedRecipes
    extends ActionBaseRemoveRecipes
    implements IUndoableAction {
        final IIngredient output;
        final IIngredient[][] ingredients;

        public ActionRemoveShapedRecipes(IIngredient output, IIngredient[][] ingredients) {
            this.output = output;
            this.ingredients = ingredients;
        }

        @Override
        public void apply() {
            int ingredientsWidth = 0;
            int ingredientsHeight = 0;
            if (this.ingredients != null) {
                ingredientsHeight = this.ingredients.length;
                for (IIngredient[] ingredient : this.ingredients) {
                    ingredientsWidth = Math.max(ingredientsWidth, ingredient.length);
                }
            }
            HashSet<IRecipe> toRemove = new HashSet<IRecipe>();
            block1: for (IRecipe recipe : recipes) {
                ItemStack output = recipe.getRecipeOutput();
                if (output == null || !this.output.matches(new MCItemStack(output)) || !(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe)) continue;
                if (this.ingredients != null) {
                    int recipeHeight;
                    boolean ore = recipe instanceof ShapedOreRecipe;
                    ShapedRecipes shapedRecipe = !ore ? (ShapedRecipes)recipe : null;
                    ShapedOreRecipe shapedOreRecipe = ore ? (ShapedOreRecipe)recipe : null;
                    int recipeWidth = ore ? MineTweakerHacks.getShapedOreRecipeWidth(shapedOreRecipe) : shapedRecipe.recipeWidth;
                    int n = recipeHeight = ore ? shapedOreRecipe.getRecipeSize() / recipeWidth : shapedRecipe.recipeHeight;
                    if (ingredientsWidth != recipeWidth || ingredientsHeight != recipeHeight) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = this.ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            IIngredient ingredient;
                            Object input = (ore ? shapedOreRecipe.getInput() : shapedRecipe.recipeItems)[j * recipeWidth + k];
                            if (!MCRecipeManager.matches(input, ingredient = k > row.length ? null : row[k])) continue block1;
                        }
                    }
                }
                toRemove.add(recipe);
            }
            MineTweakerAPI.logInfo(toRemove.size() + " removed");
            super.removeRecipes(toRemove);
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            return null;
        }

        @Override
        public String describeUndo() {
            return null;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class ActionRemoveShapelessRecipes
    extends ActionBaseRemoveRecipes
    implements IUndoableAction {
        final IIngredient output;
        final IIngredient[] ingredients;
        final boolean wildcard;

        public ActionRemoveShapelessRecipes(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
            this.output = output;
            this.ingredients = ingredients;
            this.wildcard = wildcard;
        }

        @Override
        public void apply() {
            HashSet<IRecipe> toRemove = new HashSet<IRecipe>();
            block0: for (IRecipe recipe : recipes) {
                if (recipe.getRecipeOutput() == null || !this.output.matches(new MCItemStack(recipe.getRecipeOutput())) || recipe instanceof ShapedRecipes || !(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapelessOreRecipe)) continue;
                if (this.ingredients != null) {
                    ShapelessRecipes srecipe;
                    if (recipe instanceof ShapelessRecipes) {
                        srecipe = (ShapelessRecipes)recipe;
                        if (this.ingredients.length > srecipe.getRecipeSize() || !this.wildcard && this.ingredients.length < srecipe.getRecipeSize()) continue;
                        block1: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.getRecipeSize(); ++k) {
                                if (MCRecipeManager.matches(srecipe.recipeItems.get(k), ingredient)) continue block1;
                            }
                            continue block0;
                        }
                    } else if (recipe instanceof ShapelessOreRecipe) {
                        srecipe = (ShapelessOreRecipe)recipe;
                        ArrayList inputs = srecipe.getInput();
                        if (inputs.size() < this.ingredients.length || !this.wildcard && inputs.size() > this.ingredients.length) continue;
                        block3: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.getRecipeSize(); ++k) {
                                if (MCRecipeManager.matches(inputs.get(k), ingredient)) continue block3;
                            }
                            continue block0;
                        }
                    }
                }
                toRemove.add(recipe);
            }
            MineTweakerAPI.logInfo("Removing " + toRemove.size() + " Shapeless recipes.");
            super.removeRecipes(toRemove);
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shapeless recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }

        @Override
        public String describeUndo() {
            return null;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    public static class ActionRemoveRecipesNoIngredients
    extends ActionBaseRemoveRecipes
    implements IUndoableAction {
        private final List<Pair<IIngredient, Boolean>> outputs = new ArrayList<Pair<IIngredient, Boolean>>();

        public void addOutput(IIngredient output, @Optional boolean nbtMatch) {
            this.outputs.add((Pair<IIngredient, Boolean>)Pair.of((Object)output, (Object)nbtMatch));
        }

        @Override
        public void apply() {
            HashSet<IRecipe> toRemove = new HashSet<IRecipe>();
            for (IRecipe recipe : recipes) {
                IItemStack stack;
                ItemStack recipeOutput = recipe.getRecipeOutput();
                if (recipeOutput == null || !this.matches(stack = MineTweakerMC.getIItemStack(recipeOutput))) continue;
                toRemove.add(recipe);
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            return "Removing recipes for various outputs";
        }

        @Override
        public String describeUndo() {
            return null;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        private boolean matches(IItemStack stack) {
            for (Pair<IIngredient, Boolean> entry : this.outputs) {
                IIngredient output = (IIngredient)entry.getKey();
                Boolean nbtMatch = (Boolean)entry.getValue();
                if (!(nbtMatch != false ? output.matchesExact(stack) : output.matches(stack))) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class ActionBaseRemoveRecipes
    implements IUndoableAction {
        public void removeRecipes(Set<IRecipe> toRemove) {
            recipes.removeIf(toRemove::contains);
        }
    }
}

