/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.player;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import minetweaker.MineTweakerAPI;
import minetweaker.api.chat.IChatMessage;
import minetweaker.api.data.IData;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.mc1710.MineTweakerMod;
import minetweaker.mc1710.data.NBTConverter;
import minetweaker.mc1710.network.MineTweakerCopyClipboardPacket;
import minetweaker.mc1710.network.MineTweakerOpenBrowserPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class MCPlayer
implements IPlayer {
    private final EntityPlayer player;

    public MCPlayer(EntityPlayer player) {
        this.player = player;
    }

    public EntityPlayer getInternal() {
        return this.player;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public String getName() {
        return this.player.getCommandSenderName();
    }

    @Override
    public IData getData() {
        return NBTConverter.from((NBTBase)this.player.getEntityData(), true);
    }

    @Override
    public int getXP() {
        return this.player.experienceLevel;
    }

    @Override
    public void setXP(int xp) {
        this.player.experienceLevel = 0;
        this.player.addExperienceLevel(xp);
    }

    @Override
    public void removeXP(int xp) {
        int newLvl = Math.max(0, this.player.experienceLevel - xp);
        this.player.experienceLevel = 0;
        this.player.addExperienceLevel(newLvl);
    }

    @Override
    public void update(IData data) {
        NBTConverter.updateMap(this.player.getEntityData(), data);
    }

    @Override
    public void sendChat(IChatMessage message) {
        Object internal = message.getInternal();
        if (!(internal instanceof IChatComponent)) {
            MineTweakerAPI.logError("not a valid chat message");
            return;
        }
        this.player.addChatMessage((IChatComponent)internal);
    }

    @Override
    public void sendChat(String message) {
        this.player.addChatMessage((IChatComponent)new ChatComponentText(message));
    }

    @Override
    public int getHotbarSize() {
        return 9;
    }

    @Override
    public IItemStack getHotbarStack(int i) {
        return i < 0 || i >= 9 ? null : MineTweakerMC.getIItemStack(this.player.inventory.getStackInSlot(i));
    }

    @Override
    public int getInventorySize() {
        return this.player.inventory.getSizeInventory();
    }

    @Override
    public IItemStack getInventoryStack(int i) {
        return MineTweakerMC.getIItemStack(this.player.inventory.getStackInSlot(i));
    }

    @Override
    public IItemStack getCurrentItem() {
        return MineTweakerMC.getIItemStack(this.player.getCurrentEquippedItem());
    }

    @Override
    public boolean isCreative() {
        return this.player.capabilities.isCreativeMode;
    }

    @Override
    public boolean isAdventure() {
        return !this.player.capabilities.allowEdit;
    }

    @Override
    public void openBrowser(String url) {
        if (this.player instanceof EntityPlayerMP) {
            MineTweakerMod.NETWORK.sendTo((IMessage)new MineTweakerOpenBrowserPacket(url), (EntityPlayerMP)this.player);
        }
    }

    @Override
    public void copyToClipboard(String value) {
        if (this.player instanceof EntityPlayerMP) {
            MineTweakerMod.NETWORK.sendTo((IMessage)new MineTweakerCopyClipboardPacket(value), (EntityPlayerMP)this.player);
        }
    }

    public boolean equals(Object other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return ((MCPlayer)other).player == this.player;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.player != null ? this.player.hashCode() : 0);
        return hash;
    }

    @Override
    public void give(IItemStack stack) {
        this.player.inventory.addItemStackToInventory(MineTweakerMC.getItemStack(stack).copy());
    }
}

