/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.block;

import java.util.Collections;
import java.util.List;
import minetweaker.api.block.BlockPatternOr;
import minetweaker.api.block.IBlock;
import minetweaker.api.block.IBlockDefinition;
import minetweaker.api.block.IBlockPattern;
import minetweaker.api.data.IData;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class MCWorldBlock
implements IBlock {
    private final IBlockAccess blocks;
    private final int x;
    private final int y;
    private final int z;

    public MCWorldBlock(IBlockAccess blocks, int x, int y, int z) {
        this.blocks = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public IBlockDefinition getDefinition() {
        return MineTweakerMC.getBlockDefinition(this.blocks.getBlock(this.x, this.y, this.z));
    }

    @Override
    public int getMeta() {
        return this.blocks.getBlockMetadata(this.x, this.y, this.z);
    }

    @Override
    public IData getTileData() {
        TileEntity tileEntity = this.blocks.getTileEntity(this.x, this.y, this.z);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        tileEntity.writeToNBT(nbt);
        return MineTweakerMC.getIData((NBTBase)nbt);
    }

    @Override
    public String getDisplayName() {
        Block block = this.blocks.getBlock(this.x, this.y, this.z);
        Item item = Item.getItemFromBlock((Block)block);
        if (item != null) {
            return new ItemStack(item, 1, this.getMeta()).getDisplayName();
        }
        return block.getLocalizedName();
    }

    @Override
    public List<IBlock> getBlocks() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean matches(IBlock block) {
        return this.getDefinition() == block.getDefinition() && (this.getMeta() == Short.MAX_VALUE || this.getMeta() == block.getMeta()) && (this.getTileData() == null || block.getTileData() != null && block.getTileData().contains(this.getTileData()));
    }

    @Override
    public IBlockPattern or(IBlockPattern pattern) {
        return new BlockPatternOr(this, pattern);
    }
}

