/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.actions;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SetBlockHardnessAction
implements IUndoableAction {
    private final ItemStack stack;
    private final float hardness;
    private final float oldHardness;

    public SetBlockHardnessAction(ItemStack stack, float hardness) {
        this.stack = stack;
        this.hardness = hardness;
        this.oldHardness = Block.getBlockFromItem((Item)stack.getItem()).getBlockHardness(null, 0, 0, 0);
    }

    @Override
    public void apply() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            SetBlockHardnessAction.set(this.stack, this.hardness);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            SetBlockHardnessAction.set(this.stack, this.oldHardness);
        }
    }

    @Override
    public String describe() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            return "Setting hardness of " + this.stack.getDisplayName() + " to " + this.hardness;
        }
        return "Unable to set hardness of " + this.stack.getDisplayName() + " because it is an Item";
    }

    @Override
    public String describeUndo() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            return "Reverting hardness of " + this.stack.getDisplayName() + " to " + this.oldHardness;
        }
        return "Unable to revert hardness of " + this.stack.getDisplayName() + " because it is an Item";
    }

    private static void set(ItemStack stack, float hardness) {
        if (SetBlockHardnessAction.isBlock(stack)) {
            Block block = Block.getBlockFromItem((Item)stack.getItem());
            block.setHardness(hardness);
        } else {
            MineTweakerAPI.logError("Item is not a block");
        }
    }

    public static boolean isBlock(ItemStack stack) {
        String name = Block.blockRegistry.getNameForObject((Object)Block.getBlockFromItem((Item)stack.getItem()));
        return !name.equalsIgnoreCase("minecraft:air") && Block.blockRegistry.containsKey(name);
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }
}

