/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.CommonUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ReflectionManager;
import codechicken.lib.asm.ObfMapping;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IChatComponent;

public class ServerUtils
extends CommonUtils {
    private static Field field_152661_c;
    private static Class<?> c_ProfileEntry;
    private static Method func_152668_a;

    public static MinecraftServer mc() {
        return MinecraftServer.getServer();
    }

    public static EntityPlayerMP getPlayer(String playername) {
        return ServerUtils.mc().getConfigurationManager().func_152612_a(playername);
    }

    public static List<EntityPlayerMP> getPlayers() {
        return ServerUtils.mc().getConfigurationManager().playerEntityList;
    }

    public static ArrayList<EntityPlayer> getPlayersInDimension(int dimension) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (EntityPlayer entityPlayer : ServerUtils.getPlayers()) {
            if (entityPlayer.dimension != dimension) continue;
            players.add(entityPlayer);
        }
        return players;
    }

    public static void openSMPContainer(EntityPlayerMP player, Container container, IGuiPacketSender packetSender) {
        player.getNextWindowId();
        player.closeContainer();
        packetSender.sendPacket(player, player.currentWindowId);
        player.openContainer = container;
        player.openContainer.windowId = player.currentWindowId;
        player.openContainer.addCraftingToCrafters((ICrafting)player);
    }

    public static GameProfile getGameProfile(String username) {
        EntityPlayerMP player = ServerUtils.getPlayer(username);
        if (player != null) {
            return player.getGameProfile();
        }
        username = username.toLowerCase(Locale.ROOT);
        try {
            Object cacheEntry = ((Map)field_152661_c.get(ServerUtils.mc().func_152358_ax())).get(username);
            if (cacheEntry != null) {
                return (GameProfile)func_152668_a.invoke(cacheEntry, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ServerUtils.mc().func_152358_ax().func_152655_a(username);
    }

    public static boolean isPlayerOP(String username) {
        GameProfile prof = ServerUtils.getGameProfile(username);
        return prof != null && ServerUtils.mc().getConfigurationManager().func_152596_g(prof);
    }

    public static boolean isPlayerOwner(String username) {
        return ServerUtils.mc().isSinglePlayer() && ServerUtils.mc().getServerOwner().equalsIgnoreCase(username);
    }

    public static void sendChatToAll(IChatComponent msg) {
        for (EntityPlayer entityPlayer : ServerUtils.getPlayers()) {
            entityPlayer.addChatComponentMessage(msg);
        }
    }

    static {
        try {
            field_152661_c = ReflectionManager.getField(new ObfMapping("net/minecraft/server/management/PlayerProfileCache", "field_152661_c", "[Ljava/util/Map;"));
            c_ProfileEntry = ServerUtils.class.getClassLoader().loadClass("net.minecraft.server.management.PlayerProfileCache$ProfileEntry");
            func_152668_a = c_ProfileEntry.getDeclaredMethod(new ObfMapping((String)"net/minecraft/server/management/PlayerProfileCache$ProfileEntry", (String)"func_152668_a", (String)"()Lcom/mojang/authlib/GameProfile;").toRuntime().s_name, new Class[0]);
            func_152668_a.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

