/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.biome;

import java.util.Collection;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeInfo {
    private final Object data;
    private final boolean whitelist;
    private final int type;
    private final int hash;

    public BiomeInfo(String string) {
        this.data = string;
        this.hash = string.hashCode();
        this.whitelist = true;
        this.type = 0;
    }

    public BiomeInfo(Object object, int n, boolean bl) {
        this.data = object;
        this.hash = 0;
        this.whitelist = bl;
        this.type = n;
    }

    public boolean isBiomeEqual(BiomeGenBase biomeGenBase, Random random) {
        if (biomeGenBase != null) {
            switch (this.type) {
                default: {
                    break;
                }
                case 0: {
                    String string = biomeGenBase.biomeName;
                    return string.hashCode() == this.hash && string.equals(this.data);
                }
                case 1: {
                    return biomeGenBase.getTempCategory() == this.data == this.whitelist;
                }
                case 2: {
                    return BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)((BiomeDictionary.Type)this.data)) == this.whitelist;
                }
                case 4: {
                    return ((Collection)this.data).contains(biomeGenBase.biomeName);
                }
                case 5: {
                    return ((Collection)this.data).contains(biomeGenBase.getTempCategory()) == this.whitelist;
                }
                case 6: {
                    BiomeDictionary.Type[] typeArray = (BiomeDictionary.Type[])this.data;
                    int n = 0;
                    int n2 = typeArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)typeArray[i])) continue;
                        ++n;
                    }
                    return n == n2 == this.whitelist;
                }
            }
        }
        return !this.whitelist;
    }
}

