/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.position;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.position.BlockPosition;
import java.io.Serializable;
import net.minecraft.world.chunk.Chunk;

public final class ChunkCoord
implements Comparable<ChunkCoord>,
Serializable {
    private static final long serialVersionUID = -9154178151445196959L;
    public int chunkX;
    public int chunkZ;

    public ChunkCoord(Chunk chunk) {
        this.chunkX = chunk.xPosition;
        this.chunkZ = chunk.zPosition;
    }

    public ChunkCoord(BlockPosition blockPosition) {
        this(blockPosition.x >> 4, blockPosition.z >> 4);
    }

    public ChunkCoord(int n, int n2) {
        this.chunkX = n;
        this.chunkZ = n2;
    }

    public int getCenterX() {
        return (this.chunkX << 4) + 8;
    }

    public int getCenterZ() {
        return (this.chunkZ << 4) + 8;
    }

    public void step(int n) {
        this.chunkX += BlockHelper.SIDE_COORD_MOD[n][0];
        this.chunkZ += BlockHelper.SIDE_COORD_MOD[n][2];
    }

    public void step(int n, int n2) {
        switch (n) {
            case 2: {
                this.chunkZ -= n2;
                break;
            }
            case 3: {
                this.chunkZ += n2;
                break;
            }
            case 4: {
                this.chunkX -= n2;
                break;
            }
            case 5: {
                this.chunkX += n2;
                break;
            }
        }
    }

    public ChunkCoord copy() {
        return new ChunkCoord(this.chunkX, this.chunkZ);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChunkCoord)) {
            return false;
        }
        ChunkCoord chunkCoord = (ChunkCoord)object;
        return this.chunkX == chunkCoord.chunkX && this.chunkZ == chunkCoord.chunkZ;
    }

    public int hashCode() {
        int n = this.chunkX;
        return n *= 31 + this.chunkZ;
    }

    public String toString() {
        return "[" + this.chunkX + ", " + this.chunkZ + "]";
    }

    @Override
    public int compareTo(ChunkCoord chunkCoord) {
        return this.chunkX == chunkCoord.chunkX ? this.chunkZ - chunkCoord.chunkZ : this.chunkX - chunkCoord.chunkX;
    }
}

