/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.render;

import cofh.lib.render.IFluidOverlayItem;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFluidOverlayItem
implements IItemRenderer {
    private final boolean canFlip;

    public RenderFluidOverlayItem() {
        this(true);
    }

    public RenderFluidOverlayItem(boolean bl) {
        this.canFlip = bl;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        return itemRenderType.ordinal() < IItemRenderer.ItemRenderType.FIRST_PERSON_MAP.ordinal();
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return this.handleRenderType(itemStack, itemRenderType) & itemRendererHelper.ordinal() < IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK.ordinal();
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
        Item item = itemStack.getItem();
        FluidStack fluidStack = null;
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)item;
            fluidStack = iFluidContainerItem.getFluid(itemStack);
        } else if (item instanceof IFluidOverlayItem && item.getRenderPasses(ItemHelper.getItemDamage(itemStack)) == 2) {
            fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        }
        this.doRenderItem(itemRenderType, itemStack, item, fluidStack);
    }

    protected void doRenderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Item item, FluidStack fluidStack) {
        boolean bl;
        int n;
        IIcon iIcon = item.getIcon(itemStack, 0);
        IIcon iIcon2 = item.getIcon(itemStack, 1);
        boolean bl2 = fluidStack != null;
        IIcon iIcon3 = bl2 ? fluidStack.getFluid().getIcon(fluidStack) : iIcon2;
        int n2 = bl2 ? fluidStack.getFluid().getSpriteNumber() : 0;
        int n3 = n = bl2 ? fluidStack.getFluid().getColor(fluidStack) : 0xFFFFFF;
        boolean bl3 = bl2 ? fluidStack.getFluid().getDensity(fluidStack) < 0 : (bl = false);
        if (iIcon3 == null) {
            iIcon3 = Blocks.flowing_lava.getIcon(2, 0);
            n2 = 0;
            n = 0x3F3F3F;
        }
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.instance;
        float f = iIcon.getMinU();
        float f2 = iIcon.getMaxU();
        float f3 = iIcon.getMinV();
        float f4 = iIcon.getMaxV();
        float f5 = iIcon2.getMinU();
        float f6 = iIcon2.getMaxU();
        float f7 = iIcon2.getMinV();
        float f8 = iIcon2.getMaxV();
        float f9 = iIcon3.getMinU();
        float f10 = iIcon3.getMaxU();
        float f11 = iIcon3.getMinV();
        float f12 = iIcon3.getMaxV();
        if (bl && this.canFlip) {
            f4 = iIcon.getMinV();
            f3 = iIcon.getMaxV();
            f8 = iIcon2.getMinV();
            f7 = iIcon2.getMaxV();
            f12 = iIcon3.getMinV();
            f11 = iIcon3.getMaxV();
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        int n4 = GL11.glGetInteger((int)32873);
        if (itemRenderType == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glDisable((int)2896);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(0.0, 16.0, 0.0, (double)f, (double)f4);
            tessellator.addVertexWithUV(16.0, 16.0, 0.0, (double)f2, (double)f4);
            tessellator.addVertexWithUV(16.0, 0.0, 0.0, (double)f2, (double)f3);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, (double)f, (double)f3);
            tessellator.draw();
            if (bl2) {
                tessellator.startDrawingQuads();
                tessellator.addVertexWithUV(0.0, 16.0, 0.001, (double)f5, (double)f8);
                tessellator.addVertexWithUV(16.0, 16.0, 0.001, (double)f6, (double)f8);
                tessellator.addVertexWithUV(16.0, 0.0, 0.001, (double)f6, (double)f7);
                tessellator.addVertexWithUV(0.0, 0.0, 0.001, (double)f5, (double)f7);
                tessellator.draw();
                GL11.glEnable((int)2884);
                GL11.glDepthFunc((int)514);
                GL11.glDepthMask((boolean)false);
                GL11.glMatrixMode((int)5890);
                this.bindTexture(RenderHelper.engine(), n2);
                OpenGlHelper.glBlendFunc((int)1, (int)0, (int)1, (int)0);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(n);
                tessellator.addVertexWithUV(0.0, 16.0, 0.001, (double)f9, (double)f12);
                tessellator.addVertexWithUV(16.0, 16.0, 0.001, (double)f10, (double)f12);
                tessellator.addVertexWithUV(16.0, 0.0, 0.001, (double)f10, (double)f11);
                tessellator.addVertexWithUV(0.0, 0.0, 0.001, (double)f9, (double)f11);
                tessellator.draw();
                GL11.glMatrixMode((int)5888);
                GL11.glDepthMask((boolean)true);
                GL11.glDepthFunc((int)515);
            }
            GL11.glEnable((int)2896);
        } else {
            GL11.glEnable((int)32826);
            if (itemRenderType == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslatef((float)0.5f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)f2, (float)f3, (float)f, (float)f4, (int)iIcon.getIconWidth(), (int)iIcon.getIconHeight(), (float)0.0625f);
            if (bl2) {
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                tessellator.addVertexWithUV(0.0, 0.0, 0.001, (double)f6, (double)f8);
                tessellator.addVertexWithUV(1.0, 0.0, 0.001, (double)f5, (double)f8);
                tessellator.addVertexWithUV(1.0, 1.0, 0.001, (double)f5, (double)f7);
                tessellator.addVertexWithUV(0.0, 1.0, 0.001, (double)f6, (double)f7);
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                tessellator.addVertexWithUV(0.0, 1.0, -0.0635, (double)f5, (double)f7);
                tessellator.addVertexWithUV(1.0, 1.0, -0.0635, (double)f6, (double)f7);
                tessellator.addVertexWithUV(1.0, 0.0, -0.0635, (double)f6, (double)f8);
                tessellator.addVertexWithUV(0.0, 0.0, -0.0635, (double)f5, (double)f8);
                tessellator.draw();
                GL11.glEnable((int)2884);
                GL11.glDepthFunc((int)514);
                GL11.glDepthMask((boolean)false);
                this.bindTexture(RenderHelper.engine(), n2);
                OpenGlHelper.glBlendFunc((int)1, (int)0, (int)1, (int)0);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                tessellator.setColorOpaque_I(n);
                tessellator.addVertexWithUV(0.0, 0.0, 0.001, (double)f10, (double)f12);
                tessellator.addVertexWithUV(1.0, 0.0, 0.001, (double)f9, (double)f12);
                tessellator.addVertexWithUV(1.0, 1.0, 0.001, (double)f9, (double)f11);
                tessellator.addVertexWithUV(0.0, 1.0, 0.001, (double)f10, (double)f11);
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                tessellator.setColorOpaque_I(n);
                tessellator.addVertexWithUV(0.0, 1.0, -0.0635, (double)f9, (double)f11);
                tessellator.addVertexWithUV(1.0, 1.0, -0.0635, (double)f10, (double)f11);
                tessellator.addVertexWithUV(1.0, 0.0, -0.0635, (double)f10, (double)f12);
                tessellator.addVertexWithUV(0.0, 0.0, -0.0635, (double)f9, (double)f12);
                tessellator.draw();
                GL11.glDepthMask((boolean)true);
                GL11.glDepthFunc((int)515);
            }
            GL11.glDisable((int)32826);
        }
        GL11.glBindTexture((int)3553, (int)n4);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        GL11.glPopMatrix();
    }

    protected void bindTexture(TextureManager textureManager, int n) {
        if (n == 0) {
            textureManager.bindTexture(RenderHelper.MC_BLOCK_SHEET);
        } else {
            GL11.glBindTexture((int)3553, (int)n);
        }
    }
}

