/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.util.ComparableItem;
import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItemStack
extends ComparableItem {
    public int stackSize = -1;
    public int oreID = -1;

    public static ComparableItemStack fromItemStack(ItemStack itemStack) {
        return new ComparableItemStack(itemStack);
    }

    protected static ItemStack getOre(String string) {
        if (ItemHelper.oreNameExists(string)) {
            return ItemHelper.oreProxy.getOre(string);
        }
        return null;
    }

    public ComparableItemStack(String string) {
        this(ComparableItemStack.getOre(string));
    }

    public ComparableItemStack(ItemStack itemStack) {
        super(itemStack);
        if (itemStack != null) {
            this.stackSize = itemStack.stackSize;
            this.oreID = ItemHelper.oreProxy.getOreID(itemStack);
        }
    }

    public ComparableItemStack(Item item, int n, int n2) {
        super(item, n);
        this.stackSize = n2;
        this.oreID = ItemHelper.oreProxy.getOreID(this.toItemStack());
    }

    public ComparableItemStack(ComparableItemStack comparableItemStack) {
        super(comparableItemStack.item, comparableItemStack.metadata);
        this.stackSize = comparableItemStack.stackSize;
        this.oreID = comparableItemStack.oreID;
    }

    @Override
    public ComparableItemStack set(ItemStack itemStack) {
        if (itemStack != null) {
            this.item = itemStack.getItem();
            this.metadata = ItemHelper.getItemDamage(itemStack);
            this.stackSize = itemStack.stackSize;
            this.oreID = ItemHelper.oreProxy.getOreID(itemStack);
        } else {
            this.item = null;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public ComparableItemStack set(ComparableItemStack comparableItemStack) {
        if (comparableItemStack != null) {
            this.item = comparableItemStack.item;
            this.metadata = comparableItemStack.metadata;
            this.stackSize = comparableItemStack.stackSize;
            this.oreID = comparableItemStack.oreID;
        } else {
            this.item = null;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public boolean isItemEqual(ComparableItemStack comparableItemStack) {
        return comparableItemStack != null && (this.oreID != -1 && this.oreID == comparableItemStack.oreID || this.isEqual(comparableItemStack));
    }

    public boolean isStackEqual(ComparableItemStack comparableItemStack) {
        return this.isItemEqual(comparableItemStack) && this.stackSize == comparableItemStack.stackSize;
    }

    public boolean isStackValid() {
        return this.item != null;
    }

    public ItemStack toItemStack() {
        return this.item != null ? new ItemStack(this.item, this.stackSize, this.metadata) : null;
    }

    @Override
    public ComparableItemStack clone() {
        return new ComparableItemStack(this);
    }

    @Override
    public int hashCode() {
        return this.oreID != -1 ? this.oreID : super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        return this.isItemEqual((ComparableItemStack)object);
    }
}

