/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui;

import cofh.lib.audio.SoundBase;
import cofh.lib.gui.TabTracker;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.gui.slot.SlotFalseCopy;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    public static final SoundHandler guiSoundManager = FMLClientHandler.instance().getClient().getSoundHandler();
    protected boolean drawTitle = true;
    protected boolean drawInventory = true;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int lastIndex = -1;
    protected String name;
    protected ResourceLocation texture;
    public ArrayList<TabBase> tabs = new ArrayList();
    protected ArrayList<ElementBase> elements = new ArrayList();
    protected List<String> tooltip = new LinkedList<String>();
    protected boolean tooltips = true;

    public static void playSound(String string, float f, float f2) {
        guiSoundManager.playSound((ISound)new SoundBase(string, f, f2));
    }

    public GuiBase(Container container) {
        super(container);
    }

    public GuiBase(Container container, ResourceLocation resourceLocation) {
        super(container);
        this.texture = resourceLocation;
    }

    public void initGui() {
        super.initGui();
        this.tabs.clear();
        this.elements.clear();
    }

    public void drawScreen(int n, int n2, float f) {
        this.updateElementInformation();
        super.drawScreen(n, n2, f);
        if (this.tooltips && this.mc.thePlayer.inventory.getItemStack() == null) {
            this.addTooltips(this.tooltip);
            this.drawTooltip(this.tooltip);
        }
        this.mouseX = n - this.guiLeft;
        this.mouseY = n2 - this.guiTop;
        this.updateElements();
    }

    protected void drawGuiContainerForegroundLayer(int n, int n2) {
        if (this.drawTitle & this.name != null) {
            this.fontRendererObj.drawString(StringHelper.localize(this.name), this.getCenteredOffset(StringHelper.localize(this.name)), 6, 0x404040);
        }
        if (this.drawInventory) {
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 3, 0x404040);
        }
        this.drawElements(0.0f, true);
        this.drawTabs(0.0f, true);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int n, int n2) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.mouseX = n - this.guiLeft;
        this.mouseY = n2 - this.guiTop;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawElements(f, false);
        this.drawTabs(f, false);
        GL11.glPopMatrix();
    }

    protected void keyTyped(char c, int n) {
        int n2 = this.elements.size();
        while (n2-- > 0) {
            ElementBase elementBase = this.elements.get(n2);
            if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.onKeyTyped(c, n)) continue;
            return;
        }
        super.keyTyped(c, n);
    }

    public void handleMouseInput() {
        int n = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int n2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        this.mouseX = n - this.guiLeft;
        this.mouseY = n2 - this.guiTop;
        int n3 = Mouse.getEventDWheel();
        if (n3 != 0) {
            int n4 = this.elements.size();
            while (n4-- > 0) {
                ElementBase elementBase = this.elements.get(n4);
                if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.intersectsWith(this.mouseX, this.mouseY) || !elementBase.onMouseWheel(this.mouseX, this.mouseY, n3)) continue;
                return;
            }
            TabBase tabBase = this.getTabAtPosition(this.mouseX, this.mouseY);
            if (tabBase != null && tabBase.onMouseWheel(this.mouseX, this.mouseY, n3)) {
                return;
            }
            if (this.onMouseWheel(this.mouseX, this.mouseY, n3)) {
                return;
            }
        }
        super.handleMouseInput();
    }

    protected boolean onMouseWheel(int n, int n2, int n3) {
        return false;
    }

    protected void mouseClicked(int n, int n2, int n3) {
        int n4;
        n -= this.guiLeft;
        n2 -= this.guiTop;
        int n5 = this.elements.size();
        while (n5-- > 0) {
            ElementBase elementBase = this.elements.get(n5);
            if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.intersectsWith(n, n2) || !elementBase.onMousePressed(n, n2, n3)) continue;
            return;
        }
        TabBase tabBase = this.getTabAtPosition(n, n2);
        if (tabBase != null && !tabBase.onMousePressed(n4 = n, n2, n3)) {
            int n6 = this.tabs.size();
            while (n6-- > 0) {
                TabBase tabBase2 = this.tabs.get(n6);
                if (tabBase2 == tabBase || !tabBase2.open || tabBase2.side != tabBase.side) continue;
                tabBase2.toggleOpen();
            }
            tabBase.toggleOpen();
            return;
        }
        n += this.guiLeft;
        n2 += this.guiTop;
        if (tabBase != null) {
            switch (tabBase.side) {
                case 0: {
                    break;
                }
                case 1: {
                    this.xSize += tabBase.currentWidth;
                }
            }
        }
        super.mouseClicked(n, n2, n3);
        if (tabBase != null) {
            switch (tabBase.side) {
                case 0: {
                    break;
                }
                case 1: {
                    this.xSize -= tabBase.currentWidth;
                }
            }
        }
    }

    protected void mouseMovedOrUp(int n, int n2, int n3) {
        n -= this.guiLeft;
        n2 -= this.guiTop;
        if (n3 >= 0 && n3 <= 2) {
            int n4 = this.elements.size();
            while (n4-- > 0) {
                ElementBase elementBase = this.elements.get(n4);
                if (!elementBase.isVisible() || !elementBase.isEnabled()) continue;
                elementBase.onMouseReleased(n, n2);
            }
        }
        super.mouseMovedOrUp(n += this.guiLeft, n2 += this.guiTop, n3);
    }

    protected void mouseClickMove(int n, int n2, int n3, long l) {
        Slot slot = this.getSlotAtPosition(n, n2);
        ItemStack itemStack = this.mc.thePlayer.inventory.getItemStack();
        if (this.field_147007_t && slot != null && itemStack != null && slot instanceof SlotFalseCopy) {
            if (this.lastIndex != slot.slotNumber) {
                this.lastIndex = slot.slotNumber;
                this.handleMouseClick(slot, slot.slotNumber, 0, 0);
            }
        } else {
            this.lastIndex = -1;
            super.mouseClickMove(n, n2, n3, l);
        }
    }

    public Slot getSlotAtPosition(int n, int n2) {
        for (int i = 0; i < this.inventorySlots.inventorySlots.size(); ++i) {
            Slot slot = (Slot)this.inventorySlots.inventorySlots.get(i);
            if (!this.isMouseOverSlot(slot, n, n2)) continue;
            return slot;
        }
        return null;
    }

    public boolean isMouseOverSlot(Slot slot, int n, int n2) {
        return this.func_146978_c(slot.xDisplayPosition, slot.yDisplayPosition, 16, 16, n, n2);
    }

    protected void drawElements(float f, boolean bl) {
        if (bl) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementBase elementBase = this.elements.get(i);
                if (!elementBase.isVisible()) continue;
                elementBase.drawForeground(this.mouseX, this.mouseY);
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementBase elementBase = this.elements.get(i);
                if (!elementBase.isVisible()) continue;
                elementBase.drawBackground(this.mouseX, this.mouseY, f);
            }
        }
    }

    protected void drawTabs(float f, boolean bl) {
        int n = 4;
        int n2 = 4;
        if (bl) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                TabBase tabBase = this.tabs.get(i);
                tabBase.update();
                if (!tabBase.isVisible()) continue;
                if (tabBase.side == 0) {
                    tabBase.drawForeground(this.mouseX, this.mouseY);
                    n2 += tabBase.currentHeight;
                    continue;
                }
                tabBase.drawForeground(this.mouseX, this.mouseY);
                n += tabBase.currentHeight;
            }
        } else {
            for (int i = 0; i < this.tabs.size(); ++i) {
                TabBase tabBase = this.tabs.get(i);
                tabBase.update();
                if (!tabBase.isVisible()) continue;
                if (tabBase.side == 0) {
                    tabBase.setPosition(0, n2);
                    tabBase.drawBackground(this.mouseX, this.mouseY, f);
                    n2 += tabBase.currentHeight;
                    continue;
                }
                tabBase.setPosition(this.xSize, n);
                tabBase.drawBackground(this.mouseX, this.mouseY, f);
                n += tabBase.currentHeight;
            }
        }
    }

    public List<String> handleTooltip(int n, int n2, List<String> list) {
        if (this.mc.thePlayer.inventory.getItemStack() == null) {
            this.addTooltips(list);
        }
        return list;
    }

    public void addTooltips(List<String> list) {
        ElementBase elementBase;
        TabBase tabBase = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tabBase != null) {
            tabBase.addTooltip(list);
        }
        if ((elementBase = this.getElementAtPosition(this.mouseX, this.mouseY)) != null && elementBase.isVisible()) {
            elementBase.addTooltip(list);
        }
    }

    public ElementBase addElement(ElementBase elementBase) {
        this.elements.add(elementBase);
        return elementBase;
    }

    public TabBase addTab(TabBase tabBase) {
        int n = 4;
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (this.tabs.get((int)i).side != tabBase.side || !this.tabs.get(i).isVisible()) continue;
            n += this.tabs.get((int)i).currentHeight;
        }
        tabBase.setPosition(tabBase.side == 0 ? 0 : this.xSize, n);
        this.tabs.add(tabBase);
        if (TabTracker.getOpenedLeftTab() != null && tabBase.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tabBase.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tabBase.getClass().equals(TabTracker.getOpenedRightTab())) {
            tabBase.setFullyOpen();
        }
        return tabBase;
    }

    protected ElementBase getElementAtPosition(int n, int n2) {
        int n3 = this.elements.size();
        while (n3-- > 0) {
            ElementBase elementBase = this.elements.get(n3);
            if (!elementBase.intersectsWith(n, n2)) continue;
            return elementBase;
        }
        return null;
    }

    protected TabBase getTabAtPosition(int n, int n2) {
        TabBase tabBase;
        int n3;
        int n4 = 0;
        int n5 = 4;
        for (n3 = 0; n3 < this.tabs.size(); ++n3) {
            tabBase = this.tabs.get(n3);
            if (!tabBase.isVisible() || tabBase.side == 1) continue;
            tabBase.setCurrentShift(n4, n5);
            if (tabBase.intersectsWith(n, n2, n4, n5)) {
                return tabBase;
            }
            n5 += tabBase.currentHeight;
        }
        n4 = this.xSize;
        n5 = 4;
        for (n3 = 0; n3 < this.tabs.size(); ++n3) {
            tabBase = this.tabs.get(n3);
            if (!tabBase.isVisible() || tabBase.side == 0) continue;
            tabBase.setCurrentShift(n4, n5);
            if (tabBase.intersectsWith(n, n2, n4, n5)) {
                return tabBase;
            }
            n5 += tabBase.currentHeight;
        }
        return null;
    }

    protected final void updateElements() {
        int n = this.elements.size();
        while (n-- > 0) {
            ElementBase elementBase = this.elements.get(n);
            if (!elementBase.isVisible() || !elementBase.isEnabled()) continue;
            elementBase.update(this.mouseX, this.mouseY);
        }
    }

    protected void updateElementInformation() {
    }

    public void handleElementButtonClick(String string, int n) {
    }

    public void bindTexture(ResourceLocation resourceLocation) {
        this.mc.renderEngine.bindTexture(resourceLocation);
    }

    public IIcon getIcon(String string) {
        return null;
    }

    public void drawButton(IIcon iIcon, int n, int n2, int n3, int n4) {
        this.drawIcon(iIcon, n, n2, n3);
    }

    public void drawButton(String string, int n, int n2, int n3, int n4) {
        this.drawButton(this.getIcon(string), n, n2, n3, n4);
    }

    public void drawItemStack(ItemStack itemStack, int n, int n2, boolean bl, String string) {
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.zLevel = 200.0f;
        GuiBase.itemRender.zLevel = 200.0f;
        FontRenderer fontRenderer = null;
        if (itemStack != null) {
            fontRenderer = itemStack.getItem().getFontRenderer(itemStack);
        }
        if (fontRenderer == null) {
            fontRenderer = this.fontRendererObj;
        }
        itemRender.renderItemAndEffectIntoGUI(fontRenderer, this.mc.getTextureManager(), itemStack, n, n2);
        if (bl) {
            itemRender.renderItemOverlayIntoGUI(fontRenderer, this.mc.getTextureManager(), itemStack, n, n2 - (this.draggedStack == null ? 0 : 8), string);
        }
        this.zLevel = 0.0f;
        GuiBase.itemRender.zLevel = 0.0f;
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
    }

    public void drawFluid(int n, int n2, FluidStack fluidStack, int n3, int n4) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub(fluidStack.getFluid().getColor(fluidStack));
        this.drawTiledTexture(n, n2, fluidStack.getFluid().getIcon(fluidStack), n3, n4);
    }

    public void drawTiledTexture(int n, int n2, IIcon iIcon, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n5 = 0; n5 < n3; n5 += 16) {
            for (n6 = 0; n6 < n4; n6 += 16) {
                n8 = Math.min(n3 - n5, 16);
                n7 = Math.min(n4 - n6, 16);
                this.drawScaledTexturedModelRectFromIcon(n + n5, n2 + n6, iIcon, n8, n7);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawIcon(IIcon iIcon, int n, int n2, int n3) {
        if (n3 == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModelRectFromIcon(n, n2, iIcon, 16, 16);
    }

    public void drawColorIcon(IIcon iIcon, int n, int n2, int n3) {
        if (n3 == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        this.drawTexturedModelRectFromIcon(n, n2, iIcon, 16, 16);
    }

    public void drawIcon(String string, int n, int n2, int n3) {
        this.drawIcon(this.getIcon(string), n, n2, n3);
    }

    public void drawSizedModalRect(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n < n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 < n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        float f = (float)(n5 >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(n5 >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(n5 >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(n5 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f2, (float)f3, (float)f4, (float)f);
        tessellator.startDrawingQuads();
        tessellator.addVertex((double)n, (double)n4, (double)this.zLevel);
        tessellator.addVertex((double)n3, (double)n4, (double)this.zLevel);
        tessellator.addVertex((double)n3, (double)n2, (double)this.zLevel);
        tessellator.addVertex((double)n, (double)n2, (double)this.zLevel);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawSizedRect(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n < n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 < n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        float f = (float)(n5 >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(n5 >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(n5 >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(n5 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)f2, (float)f3, (float)f4, (float)f);
        tessellator.startDrawingQuads();
        tessellator.addVertex((double)n, (double)n4, (double)this.zLevel);
        tessellator.addVertex((double)n3, (double)n4, (double)this.zLevel);
        tessellator.addVertex((double)n3, (double)n2, (double)this.zLevel);
        tessellator.addVertex((double)n, (double)n2, (double)this.zLevel);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public void drawSizedTexturedModalRect(int n, int n2, int n3, int n4, int n5, int n6, float f, float f2) {
        float f3 = 1.0f / f;
        float f4 = 1.0f / f2;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(n + 0), (double)(n2 + n6), (double)this.zLevel, (double)((float)(n3 + 0) * f3), (double)((float)(n4 + n6) * f4));
        tessellator.addVertexWithUV((double)(n + n5), (double)(n2 + n6), (double)this.zLevel, (double)((float)(n3 + n5) * f3), (double)((float)(n4 + n6) * f4));
        tessellator.addVertexWithUV((double)(n + n5), (double)(n2 + 0), (double)this.zLevel, (double)((float)(n3 + n5) * f3), (double)((float)(n4 + 0) * f4));
        tessellator.addVertexWithUV((double)(n + 0), (double)(n2 + 0), (double)this.zLevel, (double)((float)(n3 + 0) * f3), (double)((float)(n4 + 0) * f4));
        tessellator.draw();
    }

    public void drawScaledTexturedModelRectFromIcon(int n, int n2, IIcon iIcon, int n3, int n4) {
        if (iIcon == null) {
            return;
        }
        double d = iIcon.getMinU();
        double d2 = iIcon.getMaxU();
        double d3 = iIcon.getMinV();
        double d4 = iIcon.getMaxV();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(n + 0), (double)(n2 + n4), (double)this.zLevel, d, d3 + (d4 - d3) * (double)n4 / 16.0);
        tessellator.addVertexWithUV((double)(n + n3), (double)(n2 + n4), (double)this.zLevel, d + (d2 - d) * (double)n3 / 16.0, d3 + (d4 - d3) * (double)n4 / 16.0);
        tessellator.addVertexWithUV((double)(n + n3), (double)(n2 + 0), (double)this.zLevel, d + (d2 - d) * (double)n3 / 16.0, d3);
        tessellator.addVertexWithUV((double)(n + 0), (double)(n2 + 0), (double)this.zLevel, d, d3);
        tessellator.draw();
    }

    public void drawTooltip(List<String> list) {
        this.drawTooltipHoveringText(list, this.mouseX + this.guiLeft, this.mouseY + this.guiTop, this.fontRendererObj);
        this.tooltip.clear();
    }

    protected void drawTooltipHoveringText(List list, int n, int n2, FontRenderer fontRenderer) {
        int n3;
        if (list == null || list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int n4 = 0;
        for (String string : list) {
            n3 = fontRenderer.getStringWidth(string);
            if (n3 <= n4) continue;
            n4 = n3;
        }
        int n5 = n + 12;
        n3 = n2 - 12;
        int n6 = 8;
        if (list.size() > 1) {
            n6 += 2 + (list.size() - 1) * 10;
        }
        if (n5 + n4 > this.width) {
            n5 -= 28 + n4;
        }
        if (n3 + n6 + 6 > this.height) {
            n3 = this.height - n6 - 6;
        }
        this.zLevel = 300.0f;
        GuiBase.itemRender.zLevel = 300.0f;
        int n7 = -267386864;
        this.drawGradientRect(n5 - 3, n3 - 4, n5 + n4 + 3, n3 - 3, n7, n7);
        this.drawGradientRect(n5 - 3, n3 + n6 + 3, n5 + n4 + 3, n3 + n6 + 4, n7, n7);
        this.drawGradientRect(n5 - 3, n3 - 3, n5 + n4 + 3, n3 + n6 + 3, n7, n7);
        this.drawGradientRect(n5 - 4, n3 - 3, n5 - 3, n3 + n6 + 3, n7, n7);
        this.drawGradientRect(n5 + n4 + 3, n3 - 3, n5 + n4 + 4, n3 + n6 + 3, n7, n7);
        int n8 = 0x505000FF;
        int n9 = (n8 & 0xFEFEFE) >> 1 | n8 & 0xFF000000;
        this.drawGradientRect(n5 - 3, n3 - 3 + 1, n5 - 3 + 1, n3 + n6 + 3 - 1, n8, n9);
        this.drawGradientRect(n5 + n4 + 2, n3 - 3 + 1, n5 + n4 + 3, n3 + n6 + 3 - 1, n8, n9);
        this.drawGradientRect(n5 - 3, n3 - 3, n5 + n4 + 3, n3 - 3 + 1, n8, n8);
        this.drawGradientRect(n5 - 3, n3 + n6 + 2, n5 + n4 + 3, n3 + n6 + 3, n9, n9);
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            fontRenderer.drawStringWithShadow(string, n5, n3, -1);
            if (i == 0) {
                n3 += 2;
            }
            n3 += 10;
        }
        this.zLevel = 0.0f;
        GuiBase.itemRender.zLevel = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public void mouseClicked(int n) {
        super.mouseClicked(this.guiLeft + this.mouseX, this.guiTop + this.mouseY, n);
    }

    public FontRenderer getFontRenderer() {
        return this.fontRendererObj;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.xSize);
    }

    protected int getCenteredOffset(String string, int n) {
        return (n - this.fontRendererObj.getStringWidth(string)) / 2;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void overlayRecipe() {
    }
}

