/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.audio;

import cofh.lib.audio.ISoundSource;
import cofh.lib.audio.SoundBase;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.util.ResourceLocation;

public class SoundTile
extends SoundBase
implements ITickableSound {
    ISoundSource source;
    boolean beginFadeOut;
    boolean donePlaying;
    int ticks = 0;
    int fadeIn = 50;
    int fadeOut = 50;
    float baseVolume = 1.0f;

    public SoundTile(ISoundSource iSoundSource, String string, float f, float f2, boolean bl, int n, double d, double d2, double d3) {
        this(iSoundSource, string, f, f2, bl, n, d, d2, d3, ISound.AttenuationType.LINEAR);
    }

    public SoundTile(ISoundSource iSoundSource, String string, float f, float f2, boolean bl, int n, double d, double d2, double d3, ISound.AttenuationType attenuationType) {
        this(iSoundSource, new ResourceLocation(string), f, f2, bl, n, d, d2, d3, attenuationType);
    }

    public SoundTile(ISoundSource iSoundSource, ResourceLocation resourceLocation, float f, float f2, boolean bl, int n, double d, double d2, double d3) {
        this(iSoundSource, resourceLocation, f, f2, bl, n, d, d2, d3, ISound.AttenuationType.LINEAR);
    }

    public SoundTile(ISoundSource iSoundSource, ResourceLocation resourceLocation, float f, float f2, boolean bl, int n, double d, double d2, double d3, ISound.AttenuationType attenuationType) {
        super(resourceLocation, f, f2, bl, n, d, d2, d3, attenuationType);
        this.source = iSoundSource;
        this.baseVolume = f;
    }

    public SoundTile setFadeIn(int n) {
        this.fadeIn = Math.min(0, n);
        return this;
    }

    public SoundTile setFadeOut(int n) {
        this.fadeOut = Math.min(0, n);
        return this;
    }

    public float getFadeInMultiplier() {
        return this.ticks >= this.fadeIn ? 1.0f : (float)this.ticks / (float)this.fadeIn;
    }

    public float getFadeOutMultiplier() {
        return this.ticks >= this.fadeOut ? 0.0f : (float)(this.fadeOut - this.ticks) / (float)this.fadeOut;
    }

    public void update() {
        if (!this.beginFadeOut) {
            if (this.ticks < this.fadeIn) {
                ++this.ticks;
            }
            if (!this.source.shouldPlaySound()) {
                this.beginFadeOut = true;
                this.ticks = 0;
            }
        } else {
            ++this.ticks;
        }
        float f = this.beginFadeOut ? this.getFadeOutMultiplier() : this.getFadeInMultiplier();
        this.volume = this.baseVolume * f;
        if (f <= 0.0f) {
            this.donePlaying = true;
        }
    }

    public boolean isDonePlaying() {
        return this.donePlaying;
    }
}

