/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSmallTree
extends WorldGenerator {
    private final List<WeightedRandomBlock> leaves;
    private final List<WeightedRandomBlock> trunk;
    private final WeightedRandomBlock[] genBlock;
    public WeightedRandomBlock[] genSurface = null;
    public int minHeight = 5;
    public int heightVariance = 3;
    public boolean treeChecks = true;
    public boolean leafVariance = true;
    public boolean relaxedGrowth = false;
    public boolean waterLoving = false;

    public WorldGenSmallTree(List<WeightedRandomBlock> list, List<WeightedRandomBlock> list2, List<WeightedRandomBlock> list3) {
        this.trunk = list;
        this.leaves = list2;
        this.genBlock = list3.toArray(new WeightedRandomBlock[list3.size()]);
    }

    protected int getLeafRadius(int n, int n2, boolean bl) {
        if (bl) {
            if (n2 >= 1 + n - 2) {
                return 2;
            }
            return this.relaxedGrowth ? 0 : 1;
        }
        if (n2 >= 1 + n - 4) {
            return 1 - (n2 - n) / 2;
        }
        return 0;
    }

    public boolean generate(World world, Random random, int n, int n2, int n3) {
        int n4;
        int n5 = (this.heightVariance <= 1 ? 0 : random.nextInt(this.heightVariance)) + this.minHeight;
        if (n2 + n5 + 1 <= (n4 = world.getHeight())) {
            if (!WorldGenMinableCluster.canGenerateInBlock(world, n, n2 - 1, n3, this.genSurface)) {
                return false;
            }
            if (n2 < n4 - n5 - 1) {
                int n6;
                int n7;
                Block block;
                int n8;
                int n9;
                if (this.treeChecks) {
                    for (n9 = n2; n9 <= n2 + 1 + n5; ++n9) {
                        n8 = this.getLeafRadius(n5, n9 - n2, true);
                        if (n9 >= 0 & n9 < n4) {
                            if (n8 == 0) {
                                block = world.getBlock(n, n9, n3);
                                if (!(block.isLeaves((IBlockAccess)world, n, n9, n3) || block.isAir((IBlockAccess)world, n, n9, n3) || block.isReplaceable((IBlockAccess)world, n, n9, n3) || block.canBeReplacedByLeaves((IBlockAccess)world, n, n9, n3) || WorldGenMinableCluster.canGenerateInBlock(world, n, n9, n3, this.genBlock))) {
                                    return false;
                                }
                                if (this.waterLoving || n9 < n2 + 1) continue;
                                n8 = 1;
                                for (n7 = n - n8; n7 <= n + n8; ++n7) {
                                    for (n6 = n3 - n8; n6 <= n3 + n8; ++n6) {
                                        block = world.getBlock(n7, n9, n6);
                                        if (!block.getMaterial().isLiquid()) continue;
                                        return false;
                                    }
                                }
                                continue;
                            }
                            for (n7 = n - n8; n7 <= n + n8; ++n7) {
                                for (n6 = n3 - n8; n6 <= n3 + n8; ++n6) {
                                    block = world.getBlock(n7, n9, n6);
                                    if (block.isLeaves((IBlockAccess)world, n7, n9, n6) || block.isAir((IBlockAccess)world, n7, n9, n6) || block.canBeReplacedByLeaves((IBlockAccess)world, n7, n9, n6) || WorldGenMinableCluster.canGenerateInBlock(world, n7, n9, n6, this.genBlock)) continue;
                                    return false;
                                }
                            }
                            continue;
                        }
                        return false;
                    }
                    if (this.genSurface != null && !WorldGenMinableCluster.canGenerateInBlock(world, n, n2 - 1, n3, this.genSurface)) {
                        return false;
                    }
                    block = world.getBlock(n, n2 - 1, n3);
                    block.onPlantGrow(world, n, n2 - 1, n3, n, n2, n3);
                }
                n8 = 0;
                for (n9 = n2; n9 <= n2 + n5; ++n9) {
                    int n10 = n9 - (n2 + n5);
                    int n11 = this.getLeafRadius(n5, n9 - n2, false);
                    if (n11 <= 0) continue;
                    for (n7 = n - n11; n7 <= n + n11; ++n7) {
                        int n12 = n7 - n;
                        int n13 = n12 >> 31;
                        n12 = n12 + n13 ^ n13;
                        for (n6 = n3 - n11; n6 <= n3 + n11; ++n6) {
                            int n14 = n6 - n3;
                            n13 = n14 >> 31;
                            n14 = n14 + n13 ^ n13;
                            block = world.getBlock(n7, n9, n6);
                            if (!(n12 != n11 | n14 != n11) && this.leafVariance && (random.nextInt(2) == 0 || n10 == 0) || (!this.treeChecks || !block.isLeaves((IBlockAccess)world, n7, n9, n6) && !block.isAir((IBlockAccess)world, n7, n9, n6) && !block.canBeReplacedByLeaves((IBlockAccess)world, n7, n9, n6)) && !WorldGenMinableCluster.canGenerateInBlock(world, n7, n9, n6, this.genBlock)) continue;
                            n8 |= WorldGenMinableCluster.generateBlock(world, n7, n9, n6, this.leaves);
                        }
                    }
                }
                for (n9 = 0; n9 < n5; ++n9) {
                    block = world.getBlock(n, n2 + n9, n3);
                    if ((!this.treeChecks || !block.isAir((IBlockAccess)world, n, n2 + n9, n3) && !block.isLeaves((IBlockAccess)world, n, n2 + n9, n3) && !block.isReplaceable((IBlockAccess)world, n, n2 + n9, n3)) && !WorldGenMinableCluster.canGenerateInBlock(world, n, n9 + n2, n3, this.genBlock)) continue;
                    n8 |= WorldGenMinableCluster.generateBlock(world, n, n9 + n2, n3, this.trunk);
                }
                return n8 != 0;
            }
        }
        return false;
    }
}

