/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;

public class SecurityHelper {
    private static boolean setup = false;
    private static UUID cachedId;

    public static void setup() {
        if (setup) {
            return;
        }
        EnumConnectionState.PLAY.func_150755_b().put((Object)-26, Login.S__PacketSendUUID.class);
        Map map = (Map)ReflectionHelper.getPrivateValue(EnumConnectionState.class, null, (String[])new String[]{"field_150761_f"});
        map.put(Login.S__PacketSendUUID.class, EnumConnectionState.PLAY);
        FMLCommonHandler.instance().bus().register((Object)new Login.S__PacketSendUUID());
        setup = true;
    }

    private SecurityHelper() {
    }

    public static boolean isDefaultUUID(UUID uUID) {
        return uUID == null || uUID.version() == 4 && uUID.variant() == 0;
    }

    public static UUID getID(EntityPlayer entityPlayer) {
        if (MinecraftServer.getServer() != null) {
            return entityPlayer.getGameProfile().getId();
        }
        return SecurityHelper.getClientId(entityPlayer);
    }

    private static UUID getClientId(EntityPlayer entityPlayer) {
        if (entityPlayer != Minecraft.getMinecraft().thePlayer) {
            return entityPlayer.getGameProfile().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.getMinecraft().thePlayer.getGameProfile().getId();
        }
        return cachedId;
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound nBTTagCompound, ISecurable iSecurable) {
        if (iSecurable == null) {
            return null;
        }
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        nBTTagCompound.setBoolean("Secure", true);
        nBTTagCompound.setByte("Access", (byte)iSecurable.getAccess().ordinal());
        nBTTagCompound.setString("OwnerUUID", iSecurable.getOwner().getId().toString());
        nBTTagCompound.setString("Owner", iSecurable.getOwner().getName());
        return nBTTagCompound;
    }

    public static void addOwnerInformation(ItemStack itemStack, List<String> list) {
        if (SecurityHelper.isSecure(itemStack)) {
            boolean bl = itemStack.stackTagCompound.hasKey("OwnerUUID");
            if (!itemStack.stackTagCompound.hasKey("Owner") && !bl) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else if (bl && itemStack.stackTagCompound.hasKey("Owner")) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + itemStack.stackTagCompound.getString("Owner"));
            } else {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.anotherplayer"));
            }
        }
    }

    public static void addAccessInformation(ItemStack itemStack, List<String> list) {
        if (SecurityHelper.isSecure(itemStack)) {
            String string = "";
            switch (itemStack.stackTagCompound.getByte("Access")) {
                case 0: {
                    string = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case 1: {
                    string = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case 2: {
                    string = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            list.add(StringHelper.localize("info.cofh.access") + ": " + string);
        }
    }

    public static boolean isSecure(ItemStack itemStack) {
        return itemStack.stackTagCompound == null ? false : itemStack.stackTagCompound.hasKey("Secure");
    }

    public static ItemStack setSecure(ItemStack itemStack) {
        if (SecurityHelper.isSecure(itemStack)) {
            return itemStack;
        }
        if (itemStack.stackTagCompound == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        itemStack.stackTagCompound.setBoolean("Secure", true);
        itemStack.stackTagCompound.setByte("Access", (byte)0);
        return itemStack;
    }

    public static boolean setAccess(ItemStack itemStack, ISecurable.AccessMode accessMode) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return false;
        }
        itemStack.stackTagCompound.setByte("Access", (byte)accessMode.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack itemStack) {
        return itemStack.stackTagCompound == null ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[itemStack.stackTagCompound.getByte("Access")];
    }

    public static boolean setOwner(ItemStack itemStack, GameProfile gameProfile) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return false;
        }
        itemStack.setTagInfo("OwnerUUID", (NBTBase)new NBTTagString(gameProfile.getId().toString()));
        itemStack.setTagInfo("Owner", (NBTBase)new NBTTagString(gameProfile.getName()));
        return true;
    }

    public static GameProfile getOwner(ItemStack itemStack) {
        if (itemStack.stackTagCompound != null) {
            NBTTagCompound nBTTagCompound = itemStack.stackTagCompound;
            String string = nBTTagCompound.getString("OwnerUUID");
            String string2 = nBTTagCompound.getString("Owner");
            if (!Strings.isNullOrEmpty((String)string)) {
                return new GameProfile(UUID.fromString(string), string2);
            }
            if (!Strings.isNullOrEmpty((String)string2)) {
                return new GameProfile(UUID.fromString(PreYggdrasilConverter.func_152719_a((String)string2)), string2);
            }
        }
        return new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    }

    public static GameProfile getProfile(UUID uUID, String string) {
        GameProfile gameProfile = MinecraftServer.getServer().func_152358_ax().func_152652_a(uUID);
        if (gameProfile == null) {
            GameProfile gameProfile2 = new GameProfile(uUID, string);
            gameProfile = MinecraftServer.getServer().func_147130_as().fillProfileProperties(gameProfile2, true);
            if (gameProfile != gameProfile2) {
                MinecraftServer.getServer().func_152358_ax().func_152649_a(gameProfile);
            }
        }
        return gameProfile;
    }

    @Deprecated
    public static boolean setOwnerName(ItemStack itemStack, String string) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return false;
        }
        itemStack.stackTagCompound.setString("Owner", string);
        return true;
    }

    public static String getOwnerName(ItemStack itemStack) {
        boolean bl;
        NBTTagCompound nBTTagCompound = itemStack.stackTagCompound;
        if (nBTTagCompound == null || !(bl = nBTTagCompound.hasKey("OwnerUUID")) && !nBTTagCompound.hasKey("Owner")) {
            return "[None]";
        }
        return bl ? itemStack.stackTagCompound.getString("Owner") : StringHelper.localize("info.cofh.anotherplayer");
    }

    static {
        SecurityHelper.setup();
    }

    private static class Login {
        private Login() {
        }

        public static class S__PacketSendUUID
        extends Packet {
            private UUID id;

            @SubscribeEvent
            public void login(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent) {
                ((EntityPlayerMP)playerLoggedInEvent.player).playerNetServerHandler.sendPacket((Packet)new S__PacketSendUUID(playerLoggedInEvent.player));
            }

            public S__PacketSendUUID() {
            }

            public S__PacketSendUUID(EntityPlayer entityPlayer) {
                this.id = entityPlayer.getGameProfile().getId();
            }

            public void readPacketData(PacketBuffer packetBuffer) throws IOException {
                this.id = new UUID(packetBuffer.readLong(), packetBuffer.readLong());
            }

            public void writePacketData(PacketBuffer packetBuffer) throws IOException {
                packetBuffer.writeLong(this.id.getMostSignificantBits());
                packetBuffer.writeLong(this.id.getLeastSignificantBits());
            }

            public boolean hasPriority() {
                return true;
            }

            public void processPacket(INetHandler iNetHandler) {
                cachedId = this.id;
            }
        }
    }
}

