/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class NBTHelper {
    public static NBTTagCompound getTagCompound(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        return itemStack.getTagCompound();
    }

    public static boolean keyExists(ItemStack itemStack, String string) {
        if (itemStack == null) {
            return false;
        }
        return NBTHelper.getTagCompound(itemStack).hasKey(string);
    }

    public static int getInt(ItemStack itemStack, String string, int n) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return n;
        }
        return NBTHelper.getTagCompound(itemStack).getInteger(string);
    }

    public static void setInt(ItemStack itemStack, String string, int n) {
        NBTHelper.getTagCompound(itemStack).setInteger(string, n);
    }

    public static long getLong(ItemStack itemStack, String string, long l) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return l;
        }
        return NBTHelper.getTagCompound(itemStack).getLong(string);
    }

    public static void setLong(ItemStack itemStack, String string, Long l) {
        NBTHelper.getTagCompound(itemStack).setLong(string, l.longValue());
    }

    public static boolean getBoolean(ItemStack itemStack, String string, boolean bl) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return bl;
        }
        return NBTHelper.getTagCompound(itemStack).getBoolean(string);
    }

    public static void setBoolean(ItemStack itemStack, String string, boolean bl) {
        NBTHelper.getTagCompound(itemStack).setBoolean(string, bl);
    }

    public static byte getByte(ItemStack itemStack, String string, byte by) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return by;
        }
        return NBTHelper.getTagCompound(itemStack).getByte(string);
    }

    public static void setByte(ItemStack itemStack, String string, byte by) {
        NBTHelper.getTagCompound(itemStack).setByte(string, by);
    }

    public static byte[] getByteArray(ItemStack itemStack, String string, byte[] byArray) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return byArray;
        }
        return NBTHelper.getTagCompound(itemStack).getByteArray(string);
    }

    public static void setByteArray(ItemStack itemStack, String string, byte[] byArray) {
        NBTHelper.getTagCompound(itemStack).setByteArray(string, byArray);
    }

    public static double getDouble(ItemStack itemStack, String string, double d) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return d;
        }
        return NBTHelper.getTagCompound(itemStack).getDouble(string);
    }

    public static void setDouble(ItemStack itemStack, String string, double d) {
        NBTHelper.getTagCompound(itemStack).setDouble(string, d);
    }

    public static float getFloat(ItemStack itemStack, String string, float f) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return f;
        }
        return NBTHelper.getTagCompound(itemStack).getFloat(string);
    }

    public static void setFloat(ItemStack itemStack, String string, float f) {
        NBTHelper.getTagCompound(itemStack).setFloat(string, f);
    }

    public static int[] getIntArray(ItemStack itemStack, String string, int[] nArray) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return nArray;
        }
        return NBTHelper.getTagCompound(itemStack).getIntArray(string);
    }

    public static void setIntArray(ItemStack itemStack, String string, int[] nArray) {
        NBTHelper.getTagCompound(itemStack).setIntArray(string, nArray);
    }

    public static short getShort(ItemStack itemStack, String string, short s) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return s;
        }
        return NBTHelper.getTagCompound(itemStack).getShort(string);
    }

    public static void setShort(ItemStack itemStack, String string, short s) {
        NBTHelper.getTagCompound(itemStack).setShort(string, s);
    }

    public static String getString(ItemStack itemStack, String string, String string2) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return string2;
        }
        return NBTHelper.getTagCompound(itemStack).getString(string);
    }

    public static void setString(ItemStack itemStack, String string, String string2) {
        NBTHelper.getTagCompound(itemStack).setString(string, string2);
    }

    public static NBTBase getTag(ItemStack itemStack, String string) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return null;
        }
        return NBTHelper.getTagCompound(itemStack).getTag(string);
    }

    public static void setTag(ItemStack itemStack, String string, NBTBase nBTBase) {
        NBTHelper.getTagCompound(itemStack).setTag(string, nBTBase);
    }

    public static NBTTagCompound getCompoundTag(ItemStack itemStack, String string) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return null;
        }
        return NBTHelper.getTagCompound(itemStack).getCompoundTag(string);
    }

    public static void removeTag(ItemStack itemStack, String string) {
        NBTHelper.getTagCompound(itemStack).removeTag(string);
    }
}

