/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.transport.IItemDuct;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static ItemStack[] cloneInventory(ItemStack[] itemStackArray) {
        ItemStack[] itemStackArray2 = new ItemStack[itemStackArray.length];
        for (int i = 0; i < itemStackArray.length; ++i) {
            itemStackArray2[i] = itemStackArray[i] == null ? null : itemStackArray[i].copy();
        }
        return itemStackArray2;
    }

    public static boolean addItemStackToInventory(ItemStack[] itemStackArray, ItemStack itemStack, int n, int n2) {
        if (itemStack == null) {
            return true;
        }
        int n3 = -1;
        for (int i = n; i <= n2; ++i) {
            if (ItemHelper.itemsEqualForCrafting(itemStack, itemStackArray[i]) && itemStackArray[i].getMaxStackSize() > itemStackArray[i].stackSize) {
                int n4 = itemStackArray[i].getMaxStackSize() - itemStackArray[i].stackSize;
                if (n4 >= itemStack.stackSize) {
                    itemStackArray[i].stackSize += itemStack.stackSize;
                    itemStack = null;
                    return true;
                }
                itemStack.stackSize -= n4;
                itemStackArray[i].stackSize += n4;
                continue;
            }
            if (itemStackArray[i] != null || n3 != -1) continue;
            n3 = i;
        }
        if (n3 <= -1) {
            return false;
        }
        itemStackArray[n3] = itemStack;
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] itemStackArray, ItemStack itemStack, int n) {
        return InventoryHelper.addItemStackToInventory(itemStackArray, itemStack, n, itemStackArray.length - 1);
    }

    public static boolean addItemStackToInventory(ItemStack[] itemStackArray, ItemStack itemStack) {
        return InventoryHelper.addItemStackToInventory(itemStackArray, itemStack, 0);
    }

    public static ItemStack extractItemStackFromInventory(IInventory iInventory, int n) {
        if (iInventory == null) {
            return null;
        }
        ItemStack itemStack = null;
        if (iInventory instanceof ISidedInventory) {
            ISidedInventory iSidedInventory = (ISidedInventory)iInventory;
            int[] nArray = iSidedInventory.getAccessibleSlotsFromSide(n);
            for (int i = 0; i < nArray.length && itemStack == null; ++i) {
                if (iSidedInventory.getStackInSlot(i) == null || !iSidedInventory.canExtractItem(i, iSidedInventory.getStackInSlot(i), n)) continue;
                itemStack = iSidedInventory.getStackInSlot(i).copy();
                iSidedInventory.setInventorySlotContents(i, null);
            }
        } else {
            for (int i = 0; i < iInventory.getSizeInventory() && itemStack == null; ++i) {
                if (iInventory.getStackInSlot(i) == null) continue;
                itemStack = iInventory.getStackInSlot(i).copy();
                iInventory.setInventorySlotContents(i, null);
            }
        }
        if (itemStack != null) {
            iInventory.markDirty();
        }
        return itemStack;
    }

    public static ItemStack insertItemStackIntoInventory(IInventory iInventory, ItemStack itemStack, int n) {
        if (itemStack == null || iInventory == null) {
            return null;
        }
        int n2 = itemStack.stackSize;
        if (iInventory instanceof ISidedInventory) {
            int n3;
            ISidedInventory iSidedInventory = (ISidedInventory)iInventory;
            int[] nArray = iSidedInventory.getAccessibleSlotsFromSide(n);
            if (nArray == null) {
                return itemStack;
            }
            for (n3 = 0; n3 < nArray.length && itemStack != null; ++n3) {
                ItemStack itemStack2;
                if (!iSidedInventory.canInsertItem(nArray[n3], itemStack, n) || !ItemHelper.itemsEqualWithMetadata(itemStack, itemStack2 = iInventory.getStackInSlot(nArray[n3]), true)) continue;
                itemStack = InventoryHelper.addToOccupiedInventorySlot((IInventory)iSidedInventory, nArray[n3], itemStack, itemStack2);
            }
            for (n3 = 0; n3 < nArray.length && itemStack != null; ++n3) {
                if (iInventory.getStackInSlot(nArray[n3]) != null || !iSidedInventory.canInsertItem(nArray[n3], itemStack, n)) continue;
                itemStack = InventoryHelper.addToEmptyInventorySlot((IInventory)iSidedInventory, nArray[n3], itemStack);
            }
        } else {
            int n4;
            int n5 = iInventory.getSizeInventory();
            for (n4 = 0; n4 < n5 && itemStack != null; ++n4) {
                ItemStack itemStack3 = iInventory.getStackInSlot(n4);
                if (!ItemHelper.itemsEqualWithMetadata(itemStack, itemStack3, true)) continue;
                itemStack = InventoryHelper.addToOccupiedInventorySlot(iInventory, n4, itemStack, itemStack3);
            }
            for (n4 = 0; n4 < n5 && itemStack != null; ++n4) {
                if (iInventory.getStackInSlot(n4) != null) continue;
                itemStack = InventoryHelper.addToEmptyInventorySlot(iInventory, n4, itemStack);
            }
        }
        if (itemStack == null || itemStack.stackSize != n2) {
            iInventory.markDirty();
        }
        return itemStack;
    }

    public static ItemStack simulateInsertItemStackIntoInventory(IInventory iInventory, ItemStack itemStack, int n) {
        if (itemStack == null || iInventory == null) {
            return null;
        }
        if (iInventory instanceof ISidedInventory) {
            int n2;
            ISidedInventory iSidedInventory = (ISidedInventory)iInventory;
            int[] nArray = iSidedInventory.getAccessibleSlotsFromSide(n);
            if (nArray == null) {
                return itemStack;
            }
            for (n2 = 0; n2 < nArray.length && itemStack != null; ++n2) {
                ItemStack itemStack2;
                if (!iSidedInventory.canInsertItem(nArray[n2], itemStack, n) || !ItemHelper.itemsEqualWithMetadata(itemStack, itemStack2 = iInventory.getStackInSlot(nArray[n2]), true)) continue;
                itemStack = InventoryHelper.simulateAddToOccupiedInventorySlot((IInventory)iSidedInventory, nArray[n2], itemStack, itemStack2);
            }
            for (n2 = 0; n2 < nArray.length && itemStack != null; ++n2) {
                if (iInventory.getStackInSlot(nArray[n2]) != null || !iSidedInventory.canInsertItem(nArray[n2], itemStack, n)) continue;
                itemStack = InventoryHelper.simulateAddToEmptyInventorySlot((IInventory)iSidedInventory, nArray[n2], itemStack);
            }
        } else {
            int n3;
            int n4 = iInventory.getSizeInventory();
            for (n3 = 0; n3 < n4 && itemStack != null; ++n3) {
                ItemStack itemStack3 = iInventory.getStackInSlot(n3);
                if (!ItemHelper.itemsEqualWithMetadata(itemStack, itemStack3, true)) continue;
                itemStack = InventoryHelper.simulateAddToOccupiedInventorySlot(iInventory, n3, itemStack, itemStack3);
            }
            for (n3 = 0; n3 < n4 && itemStack != null; ++n3) {
                if (iInventory.getStackInSlot(n3) != null) continue;
                itemStack = InventoryHelper.simulateAddToEmptyInventorySlot(iInventory, n3, itemStack);
            }
        }
        return itemStack;
    }

    public static ItemStack addToEmptyInventorySlot(IInventory iInventory, int n, ItemStack itemStack) {
        if (!iInventory.isItemValidForSlot(n, itemStack)) {
            return itemStack;
        }
        int n2 = iInventory.getInventoryStackLimit();
        iInventory.setInventorySlotContents(n, ItemHelper.cloneStack(itemStack, Math.min(itemStack.stackSize, n2)));
        return n2 >= itemStack.stackSize ? null : itemStack.splitStack(itemStack.stackSize - n2);
    }

    public static ItemStack addToOccupiedInventorySlot(IInventory iInventory, int n, ItemStack itemStack) {
        int n2 = Math.min(iInventory.getInventoryStackLimit(), itemStack.getMaxStackSize());
        ItemStack itemStack2 = iInventory.getStackInSlot(n);
        if (itemStack.stackSize + itemStack2.stackSize > n2) {
            int n3 = n2 - itemStack2.stackSize;
            itemStack2.stackSize = n2;
            itemStack.stackSize -= n3;
            iInventory.setInventorySlotContents(n, itemStack2);
            return itemStack;
        }
        itemStack2.stackSize += Math.min(itemStack.stackSize, n2);
        iInventory.setInventorySlotContents(n, itemStack2);
        return n2 >= itemStack.stackSize ? null : itemStack.splitStack(itemStack.stackSize - n2);
    }

    public static ItemStack addToOccupiedInventorySlot(IInventory iInventory, int n, ItemStack itemStack, ItemStack itemStack2) {
        int n2 = Math.min(iInventory.getInventoryStackLimit(), itemStack.getMaxStackSize());
        if (itemStack2.stackSize >= n2) {
            return itemStack;
        }
        if (itemStack.stackSize + itemStack2.stackSize > n2) {
            int n3 = n2 - itemStack2.stackSize;
            itemStack2.stackSize = n2;
            itemStack.stackSize -= n3;
            iInventory.setInventorySlotContents(n, itemStack2);
            return itemStack;
        }
        itemStack2.stackSize += itemStack.stackSize;
        iInventory.setInventorySlotContents(n, itemStack2);
        return n2 >= itemStack.stackSize ? null : itemStack.splitStack(itemStack.stackSize - n2);
    }

    public static ItemStack simulateAddToEmptyInventorySlot(IInventory iInventory, int n, ItemStack itemStack) {
        if (!iInventory.isItemValidForSlot(n, itemStack)) {
            return itemStack;
        }
        int n2 = Math.min(iInventory.getInventoryStackLimit(), itemStack.getMaxStackSize());
        return n2 >= itemStack.stackSize ? null : itemStack.splitStack(itemStack.stackSize - n2);
    }

    public static ItemStack simulateAddToOccupiedInventorySlot(IInventory iInventory, int n, ItemStack itemStack) {
        int n2 = Math.min(iInventory.getInventoryStackLimit(), itemStack.getMaxStackSize());
        ItemStack itemStack2 = iInventory.getStackInSlot(n);
        if (itemStack.stackSize + itemStack2.stackSize > n2) {
            itemStack.stackSize -= n2 - itemStack2.stackSize;
            return itemStack;
        }
        return n2 >= itemStack.stackSize ? null : itemStack.splitStack(itemStack.stackSize - n2);
    }

    public static ItemStack simulateAddToOccupiedInventorySlot(IInventory iInventory, int n, ItemStack itemStack, ItemStack itemStack2) {
        int n2 = Math.min(iInventory.getInventoryStackLimit(), itemStack.getMaxStackSize());
        if (itemStack2.stackSize >= n2) {
            return itemStack;
        }
        if (itemStack.stackSize + itemStack2.stackSize > n2) {
            itemStack.stackSize -= n2 - itemStack2.stackSize;
            return itemStack;
        }
        return n2 >= itemStack.stackSize ? null : itemStack.splitStack(itemStack.stackSize - n2);
    }

    public static boolean mergeItemStack(List<Slot> list, ItemStack itemStack, int n, int n2, boolean bl) {
        return InventoryHelper.mergeItemStack(list, itemStack, n, n2, bl, true);
    }

    public static boolean mergeItemStack(List<Slot> list, ItemStack itemStack, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        ItemStack itemStack2;
        Slot slot;
        int n4;
        int n5;
        boolean bl3 = false;
        int n6 = n5 = !bl ? 1 : -1;
        if (itemStack.isStackable()) {
            for (n4 = !bl ? n : n2 - 1; itemStack.stackSize > 0 && (!bl && n4 < n2 || bl && n4 >= n); n4 += n5) {
                slot = list.get(n4);
                itemStack2 = slot.getStack();
                if (!slot.isItemValid(itemStack) || itemStack2 == null || !itemStack2.getItem().equals(itemStack.getItem()) || itemStack.getHasSubtypes() && itemStack.getItemDamage() != itemStack2.getItemDamage() || !ItemStack.areItemStackTagsEqual((ItemStack)itemStack, (ItemStack)itemStack2)) continue;
                n3 = itemStack2.stackSize + itemStack.stackSize;
                int n7 = Math.min(itemStack.getMaxStackSize(), slot.getSlotStackLimit());
                if (n3 <= n7) {
                    itemStack.stackSize = 0;
                    itemStack2.stackSize = n3;
                    slot.onSlotChanged();
                    bl3 = true;
                    continue;
                }
                if (itemStack2.stackSize >= n7) continue;
                itemStack.stackSize -= n7 - itemStack2.stackSize;
                itemStack2.stackSize = n7;
                slot.onSlotChanged();
                bl3 = true;
            }
        }
        if (itemStack.stackSize > 0) {
            int n8 = n4 = !bl ? n : n2 - 1;
            while (itemStack.stackSize > 0 && (!bl && n4 < n2 || bl && n4 >= n)) {
                slot = list.get(n4);
                itemStack2 = slot.getStack();
                if (slot.isItemValid(itemStack) && itemStack2 == null) {
                    n3 = bl2 ? Math.min(itemStack.getMaxStackSize(), slot.getSlotStackLimit()) : slot.getSlotStackLimit();
                    itemStack2 = itemStack.splitStack(Math.min(itemStack.stackSize, n3));
                    slot.putStack(itemStack2);
                    slot.onSlotChanged();
                    bl3 = true;
                }
                n4 += n5;
            }
        }
        return bl3;
    }

    public static ItemStack addToInsertion(Object object, int n, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        itemStack = object instanceof IInventory ? InventoryHelper.insertItemStackIntoInventory((IInventory)object, itemStack, BlockHelper.SIDE_OPPOSITE[n]) : ((IItemDuct)object).insertItem(ForgeDirection.VALID_DIRECTIONS[n ^ 1], itemStack);
        return itemStack;
    }

    public static boolean isInventory(TileEntity tileEntity) {
        return tileEntity instanceof IInventory;
    }

    public static boolean isInsertion(Object object) {
        return object instanceof IInventory || object instanceof IItemDuct;
    }
}

