/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.lib.util.helpers.BlockHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyHelper {
    public static final int RF_PER_MJ = 10;
    public static final int RF_PER_EU = 4;

    private EnergyHelper() {
    }

    public static int extractEnergyFromContainer(ItemStack itemStack, int n, boolean bl) {
        return EnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyContainerItem)itemStack.getItem()).extractEnergy(itemStack, n, bl) : 0;
    }

    public static int insertEnergyIntoContainer(ItemStack itemStack, int n, boolean bl) {
        return EnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyContainerItem)itemStack.getItem()).receiveEnergy(itemStack, n, bl) : 0;
    }

    public static int extractEnergyFromHeldContainer(EntityPlayer entityPlayer, int n, boolean bl) {
        ItemStack itemStack = entityPlayer.getCurrentEquippedItem();
        return EnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyContainerItem)itemStack.getItem()).extractEnergy(itemStack, n, bl) : 0;
    }

    public static int insertEnergyIntoHeldContainer(EntityPlayer entityPlayer, int n, boolean bl) {
        ItemStack itemStack = entityPlayer.getCurrentEquippedItem();
        return EnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyContainerItem)itemStack.getItem()).receiveEnergy(itemStack, n, bl) : 0;
    }

    public static boolean isPlayerHoldingEnergyContainerItem(EntityPlayer entityPlayer) {
        return EnergyHelper.isEnergyContainerItem(entityPlayer.getCurrentEquippedItem());
    }

    public static boolean isEnergyContainerItem(ItemStack itemStack) {
        return itemStack != null && itemStack.getItem() instanceof IEnergyContainerItem;
    }

    public static ItemStack setDefaultEnergyTag(ItemStack itemStack, int n) {
        if (itemStack.stackTagCompound == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        itemStack.stackTagCompound.setInteger("Energy", n);
        return itemStack;
    }

    @Deprecated
    public static int extractEnergyFromAdjacentEnergyHandler(TileEntity tileEntity, int n, int n2, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity2).extractEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], n2, bl) : 0;
    }

    @Deprecated
    public static int insertEnergyIntoAdjacentEnergyHandler(TileEntity tileEntity, int n, int n2, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity2).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], n2, bl) : 0;
    }

    public static int extractEnergyFromAdjacentEnergyProvider(TileEntity tileEntity, int n, int n2, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IEnergyProvider ? ((IEnergyProvider)tileEntity2).extractEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], n2, bl) : 0;
    }

    public static int insertEnergyIntoAdjacentEnergyReceiver(TileEntity tileEntity, int n, int n2, boolean bl) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return tileEntity2 instanceof IEnergyReceiver ? ((IEnergyReceiver)tileEntity2).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[n ^ 1], n2, bl) : 0;
    }

    @Deprecated
    public static boolean isAdjacentEnergyHandlerFromSide(TileEntity tileEntity, int n) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return EnergyHelper.isEnergyHandlerFromSide(tileEntity2, ForgeDirection.VALID_DIRECTIONS[n ^ 1]);
    }

    @Deprecated
    public static boolean isEnergyHandlerFromSide(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return tileEntity instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity).canConnectEnergy(forgeDirection) : false;
    }

    public static boolean isAdjacentEnergyConnectableFromSide(TileEntity tileEntity, int n) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return EnergyHelper.isEnergyConnectableFromSide(tileEntity2, ForgeDirection.VALID_DIRECTIONS[n ^ 1]);
    }

    public static boolean isEnergyConnectableFromSide(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return tileEntity instanceof IEnergyConnection ? ((IEnergyConnection)tileEntity).canConnectEnergy(forgeDirection) : false;
    }

    public static boolean isAdjacentEnergyReceiverFromSide(TileEntity tileEntity, int n) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return EnergyHelper.isEnergyReceiverFromSide(tileEntity2, ForgeDirection.VALID_DIRECTIONS[n ^ 1]);
    }

    public static boolean isEnergyReceiverFromSide(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return tileEntity instanceof IEnergyReceiver ? ((IEnergyReceiver)tileEntity).canConnectEnergy(forgeDirection) : false;
    }

    public static boolean isAdjacentEnergyProviderFromSide(TileEntity tileEntity, int n) {
        TileEntity tileEntity2 = BlockHelper.getAdjacentTileEntity(tileEntity, n);
        return EnergyHelper.isEnergyProviderFromSide(tileEntity2, ForgeDirection.VALID_DIRECTIONS[n ^ 1]);
    }

    public static boolean isEnergyProviderFromSide(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return tileEntity instanceof IEnergyProvider ? ((IEnergyProvider)tileEntity).canConnectEnergy(forgeDirection) : false;
    }
}

